/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.AbstractMath;
import JSci.maths.EngineerMath;
import JSci.maths.wavelet.FWTCoef;

public final class FWTCoefMath
extends AbstractMath {
    private FWTCoefMath() {
    }

    public static boolean areCompatible(FWTCoef fWTCoef, FWTCoef fWTCoef2) {
        if (fWTCoef.getJ() != fWTCoef2.getJ()) {
            return false;
        }
        int n = 0;
        while (n < fWTCoef.getJ()) {
            if (fWTCoef.dimension(n) != fWTCoef2.dimension(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean areCompatible(FWTCoef[] fWTCoefArray) {
        if (fWTCoefArray.length == 1) {
            return true;
        }
        int n = 0;
        while (n < fWTCoefArray.length - 1) {
            if (!FWTCoefMath.areCompatible(fWTCoefArray[n], fWTCoefArray[n + 1])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int getJ(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The objects are not compatible.");
        }
        return fWTCoefArray[0].getJ();
    }

    public static double sumSquares(FWTCoef[] fWTCoefArray, int n) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The objects are not compatible.");
        }
        if (n < 0 || n >= FWTCoefMath.getJ(fWTCoefArray)) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (FWTCoefMath.getJ(fWTCoefArray) - 1));
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < fWTCoefArray.length) {
            d += fWTCoefArray[n2].sumSquares(n);
            ++n2;
        }
        return d;
    }

    public static double variance(FWTCoef[] fWTCoefArray, int n) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The objects are not compatible.");
        }
        if (n < 0 || n >= FWTCoefMath.getJ(fWTCoefArray)) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (FWTCoefMath.getJ(fWTCoefArray) - 1));
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < fWTCoefArray.length) {
            d += fWTCoefArray[n2].variance(n);
            ++n2;
        }
        return d;
    }

    public static double sumEnergies(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double d = 0.0;
        int n = 0;
        while (n < fWTCoefArray.length) {
            d += fWTCoefArray[n].sumEnergies();
            ++n;
        }
        return d;
    }

    public static double entropy(FWTCoef[] fWTCoefArray, int n) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (n < 0 || n >= FWTCoefMath.getJ(fWTCoefArray)) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (FWTCoefMath.getJ(fWTCoefArray) - 1));
        }
        double d = FWTCoefMath.sumSquares(fWTCoefArray, n);
        int n2 = fWTCoefArray[0].coefs[n].length;
        double[] dArray = new double[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < fWTCoefArray[0].coefs[n].length) {
            int n5 = 0;
            while (n5 < fWTCoefArray.length) {
                int n6 = n3;
                dArray[n6] = dArray[n6] + fWTCoefArray[n5].coefs[n][n4] * fWTCoefArray[n5].coefs[n][n4] / d;
                ++n5;
            }
            ++n3;
            ++n4;
        }
        return EngineerMath.icf((double[])dArray);
    }

    public static double entropy(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double d = FWTCoefMath.sumEnergies(fWTCoefArray);
        int n = 0;
        int n2 = 1;
        while (n2 < fWTCoefArray[0].coefs.length) {
            n += fWTCoefArray[0].coefs[n2].length;
            ++n2;
        }
        double[] dArray = new double[n];
        int n3 = 0;
        int n4 = 1;
        while (n4 < fWTCoefArray[0].coefs.length) {
            int n5 = 0;
            while (n5 < fWTCoefArray[0].coefs[n4].length) {
                int n6 = 0;
                while (n6 < fWTCoefArray.length) {
                    int n7 = n3;
                    dArray[n7] = dArray[n7] + fWTCoefArray[n6].coefs[n4][n5] * fWTCoefArray[n6].coefs[n4][n5] / d;
                    ++n6;
                }
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return EngineerMath.icf((double[])dArray);
    }

    public static double sumVariance(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The objects are not compatible");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double d = 0.0;
        int n = 0;
        while (n < fWTCoefArray.length) {
            d += fWTCoefArray[n].sumVariance();
            ++n;
        }
        return d;
    }

    public static double energyRatio(FWTCoef[] fWTCoefArray, int n) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 1 || n >= FWTCoefMath.getJ(fWTCoefArray)) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (FWTCoefMath.getJ(fWTCoefArray) - 1));
        }
        if (FWTCoefMath.sumEnergies(fWTCoefArray) == 0.0) {
            if (FWTCoefMath.getJ(fWTCoefArray) != 0) {
                return 1 / FWTCoefMath.getJ(fWTCoefArray);
            }
            throw new IllegalArgumentException("No energy!");
        }
        return FWTCoefMath.sumSquares(fWTCoefArray, n) / FWTCoefMath.sumEnergies(fWTCoefArray);
    }

    public static double varianceRatio(FWTCoef[] fWTCoefArray, int n) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 1 || n >= FWTCoefMath.getJ(fWTCoefArray)) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (FWTCoefMath.getJ(fWTCoefArray) - 1));
        }
        if (FWTCoefMath.sumVariance(fWTCoefArray) == 0.0) {
            if (FWTCoefMath.getJ(fWTCoefArray) != 0) {
                return 1 / FWTCoefMath.getJ(fWTCoefArray);
            }
            throw new IllegalArgumentException("No energy!");
        }
        return FWTCoefMath.variance(fWTCoefArray, n) / FWTCoefMath.sumVariance(fWTCoefArray);
    }

    public static double icf(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[FWTCoefMath.getJ(fWTCoefArray) - 1];
        int n = 1;
        while (n < FWTCoefMath.getJ(fWTCoefArray)) {
            dArray[n - 1] = FWTCoefMath.energyRatio(fWTCoefArray, n);
            ++n;
        }
        return EngineerMath.icf((double[])dArray);
    }

    public static double icfVariance(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[FWTCoefMath.getJ(fWTCoefArray) - 1];
        int n = 1;
        while (n < FWTCoefMath.getJ(fWTCoefArray)) {
            dArray[n - 1] = FWTCoefMath.varianceRatio(fWTCoefArray, n);
            ++n;
        }
        return EngineerMath.icf((double[])dArray);
    }
}

