/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayFuncs;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RandomStarTable;
import uk.ac.starlink.table.ValueInfo;

public class FitsStarTable
extends RandomStarTable {
    private final TableHDU thdu;
    private final int nrow;
    private final int ncol;
    private final ColumnInfo[] colinfos;
    private final double[] scales;
    private final double[] zeros;
    private final boolean[] isScaled;
    private final long[] blanks;
    private final boolean[] hasBlank;
    private static final ValueInfo tnullInfo = new DefaultValueInfo("Blank", class$java$lang$Long == null ? (class$java$lang$Long = FitsStarTable.class$("java.lang.Long")) : class$java$lang$Long, "Bad value indicator (TNULLn card)");
    private static final ValueInfo tscalInfo = new DefaultValueInfo("Scale", class$java$lang$Double == null ? (class$java$lang$Double = FitsStarTable.class$("java.lang.Double")) : class$java$lang$Double, "Multiplier for values (TSCALn card)");
    private static final ValueInfo tzeroInfo = new DefaultValueInfo("Zero", class$java$lang$Double == null ? (class$java$lang$Double = FitsStarTable.class$("java.lang.Double")) : class$java$lang$Double, "Offset for values (TZEROn card)");
    private static final ValueInfo tdispInfo = new DefaultValueInfo("Format", class$java$lang$String == null ? (class$java$lang$String = FitsStarTable.class$("java.lang.String")) : class$java$lang$String, "Display format in FORTRAN notation (TDISPn card)");
    private static final ValueInfo tbcolInfo = new DefaultValueInfo("Start column", class$java$lang$Integer == null ? (class$java$lang$Integer = FitsStarTable.class$("java.lang.Integer")) : class$java$lang$Integer, "Start column for data (TBCOLn card)");
    private static final ValueInfo tformInfo = new DefaultValueInfo("Format code", class$java$lang$String == null ? (class$java$lang$String = FitsStarTable.class$("java.lang.String")) : class$java$lang$String, "Data type code (TFORMn card)");
    private static final List auxDataInfos = Arrays.asList(tnullInfo, tscalInfo, tzeroInfo, tdispInfo, tbcolInfo, tformInfo);
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;

    public FitsStarTable(TableHDU thdu) throws IOException {
        this.thdu = thdu;
        this.nrow = thdu.getNRows();
        this.ncol = thdu.getNCols();
        this.colinfos = new ColumnInfo[this.ncol];
        this.scales = new double[this.ncol];
        Arrays.fill(this.scales, 1.0);
        this.zeros = new double[this.ncol];
        this.isScaled = new boolean[this.ncol];
        this.blanks = new long[this.ncol];
        this.hasBlank = new boolean[this.ncol];
        Header cards = thdu.getHeader();
        int icol = 0;
        while (icol < this.ncol) {
            String tform;
            String tbcol;
            String tcomm;
            String[] sdims;
            String blankKey;
            String tdisp;
            int jcol = icol + 1;
            ColumnInfo cinfo = new ColumnInfo(thdu.getColumnName(icol));
            List auxdata = cinfo.getAuxData();
            this.colinfos[icol] = cinfo;
            String tunit = cards.getStringValue("TUNIT" + jcol);
            if (tunit != null) {
                cinfo.setUnitString(tunit);
            }
            if ((tdisp = cards.getStringValue("TDISP" + jcol)) != null) {
                auxdata.add(new DescribedValue(tdispInfo, (Object)tdisp));
            }
            if (cards.containsKey(blankKey = "TNULL" + jcol)) {
                long nullval;
                this.blanks[icol] = nullval = cards.getLongValue(blankKey);
                this.hasBlank[icol] = true;
                auxdata.add(new DescribedValue(tnullInfo, (Object)new Long(nullval)));
            } else {
                cinfo.setNullable(false);
            }
            String tdim = cards.getStringValue("TDIM" + jcol);
            if (tdim != null && (tdim = tdim.trim()).charAt(0) == '(' && tdim.charAt(tdim.length() - 1) == ')' && (sdims = (tdim = tdim.substring(1, tdim.length() - 1).trim()).split(",")).length > 0) {
                try {
                    int[] dims = new int[sdims.length];
                    int i = 0;
                    while (i < sdims.length) {
                        dims[i] = Integer.parseInt(sdims[i]);
                        ++i;
                    }
                    cinfo.setShape(dims);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String tscal = cards.getStringValue("TSCAL" + jcol);
            String tzero = cards.getStringValue("TZERO" + jcol);
            if (tscal != null) {
                double scalval;
                this.scales[icol] = scalval = Double.parseDouble(tscal);
                auxdata.add(new DescribedValue(tscalInfo, (Object)new Double(scalval)));
            }
            if (tzero != null) {
                double zeroval;
                this.zeros[icol] = zeroval = Double.parseDouble(tzero);
                auxdata.add(new DescribedValue(tzeroInfo, (Object)new Double(zeroval)));
            }
            if (this.scales[icol] != 1.0 || this.zeros[icol] != 0.0) {
                this.isScaled[icol] = true;
            }
            if ((tcomm = cards.getStringValue("TCOMM" + jcol)) != null) {
                cinfo.setDescription(tcomm);
            }
            if ((tbcol = cards.getStringValue("TBCOL" + jcol)) != null) {
                int bcolval = Integer.parseInt(tbcol);
                auxdata.add(new DescribedValue(tbcolInfo, (Object)new Integer(bcolval)));
            }
            if ((tform = cards.getStringValue("TFORM" + jcol)) != null) {
                auxdata.add(new DescribedValue(tformInfo, (Object)tform));
            }
            if (this.nrow > 0) {
                Object test = null;
                try {
                    test = thdu.getElement(0, icol);
                }
                catch (FitsException e) {
                    throw (IOException)new IOException("Error reading test cell").initCause(e);
                }
                Class cls = this.packagedType(test, icol);
                cinfo.setContentClass(cls);
            } else if (this.isScaled[icol]) {
                cinfo.setContentClass(class$java$lang$Double == null ? FitsStarTable.class$("java.lang.Double") : class$java$lang$Double);
            }
            ++icol;
        }
    }

    public long getRowCount() {
        return this.nrow;
    }

    public int getColumnCount() {
        return this.ncol;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colinfos[icol];
    }

    public List getColumnAuxDataInfos() {
        return auxDataInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCell(long lrow, int icol) throws IOException {
        int irow = AbstractStarTable.checkedLongToInt((long)lrow);
        try {
            Object val;
            FitsStarTable fitsStarTable = this;
            synchronized (fitsStarTable) {
                val = this.thdu.getElement(irow, icol);
            }
            return this.packageValue(val, icol);
        }
        catch (FitsException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRow(long lrow) throws IOException {
        Object[] row;
        int irow = AbstractStarTable.checkedLongToInt((long)lrow);
        try {
            FitsStarTable fitsStarTable = this;
            synchronized (fitsStarTable) {
                row = this.thdu.getRow(irow);
            }
        }
        catch (FitsException e) {
            throw (IOException)new IOException().initCause(e);
        }
        int icol = 0;
        while (icol < this.ncol) {
            row[icol] = this.packageValue(row[icol], icol);
            ++icol;
        }
        return row;
    }

    private Object packageValue(Object base, int icol) {
        Class<?> cls;
        if (base == null) {
            return null;
        }
        Class<?> bcls = base.getClass();
        Class<?> clazz = cls = bcls.isArray() ? bcls.getComponentType() : null;
        if (cls != null && Array.getLength(base) == 1) {
            boolean hasblank = this.hasBlank[icol];
            long blank = this.blanks[icol];
            boolean scaled = this.isScaled[icol];
            double scale = this.scales[icol];
            double zero = this.zeros[icol];
            if (cls == Byte.TYPE) {
                byte val = ((byte[])base)[0];
                return hasblank && val == (byte)blank ? null : (scaled ? (Number)new Double((double)val * scale + zero) : (Number)new Byte(val));
            }
            if (cls == Short.TYPE) {
                short val = ((short[])base)[0];
                return hasblank && val == (short)blank ? null : (scaled ? (Number)new Double((double)val * scale + zero) : (Number)new Short(val));
            }
            if (cls == Integer.TYPE) {
                int val = ((int[])base)[0];
                return hasblank && val == (int)blank ? null : (scaled ? (Number)new Double((double)val * scale + zero) : (Number)new Integer(val));
            }
            if (cls == Long.TYPE) {
                long val = ((long[])base)[0];
                return hasblank && val == blank ? null : (scaled ? (Number)new Double((double)val * scale + zero) : (Number)new Long(val));
            }
            if (cls == Float.TYPE) {
                float val = ((float[])base)[0];
                return scaled ? (Number)new Double((double)val * scale + zero) : (Number)new Float(val);
            }
            if (cls == Double.TYPE) {
                double val = ((double[])base)[0];
                return scaled ? new Double(val * scale + zero) : new Double(val);
            }
            if (cls == Boolean.TYPE) {
                return new Boolean(((boolean[])base)[0]);
            }
            if (cls == (class$java$lang$String == null ? (class$java$lang$String = FitsStarTable.class$("java.lang.String")) : class$java$lang$String)) {
                String val = ((String[])base)[0];
                return FitsStarTable.isEmpty(val) ? null : val;
            }
        }
        if (cls != null && cls.isArray()) {
            return ArrayFuncs.flatten(base);
        }
        if (base instanceof String && FitsStarTable.isEmpty((String)base)) {
            return null;
        }
        return base;
    }

    private Class packagedType(Object base, int icol) {
        Class<?> cls = base.getClass().getComponentType();
        if (cls != null && Array.getLength(base) == 1) {
            boolean scaled = this.isScaled[icol];
            if (scaled) {
                return class$java$lang$Double == null ? (class$java$lang$Double = FitsStarTable.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (cls == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = FitsStarTable.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            if (cls == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = FitsStarTable.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (cls == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = FitsStarTable.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (cls == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = FitsStarTable.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (cls == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = FitsStarTable.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (cls == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = FitsStarTable.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (cls == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = FitsStarTable.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (cls == (class$java$lang$String == null ? (class$java$lang$String = FitsStarTable.class$("java.lang.String")) : class$java$lang$String)) {
                return class$java$lang$String == null ? (class$java$lang$String = FitsStarTable.class$("java.lang.String")) : class$java$lang$String;
            }
        } else if (cls != null && cls.isArray()) {
            return ArrayFuncs.flatten(base).getClass();
        }
        return base.getClass();
    }

    private static boolean isEmpty(String str) {
        int leng = str.length();
        int i = 0;
        while (i < leng) {
            if (str.charAt(i) != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

