/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.awt.datatransfer.DataFlavor;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import nom.tam.fits.AsciiTable;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.fits.BintableStarTable;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOUtils;

public class FitsTableBuilder
implements TableBuilder {
    public String getFormatName() {
        return "FITS";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy policy) throws IOException {
        StarTable e22;
        StarTable table;
        ArrayDataInput strm;
        block13: {
            StarTable e22;
            block12: {
                if (!FitsConstants.isMagic(datsrc.getIntro())) {
                    throw new TableFormatException("Doesn't look like a FITS file");
                }
                strm = null;
                table = null;
                try {
                    try {
                        strm = FitsConstants.getInputStreamStart(datsrc);
                        long[] pos = new long[]{0L};
                        if (datsrc.getPosition() != null) {
                            pos[0] = pos[0] + FitsConstants.positionStream(strm, datsrc.getPosition());
                            try {
                                table = FitsTableBuilder.attemptReadTable(strm, wantRandom, datsrc, pos);
                            }
                            catch (EOFException e22) {
                                throw new IOException("Fell off end of file looking for HDU " + datsrc.getPosition());
                            }
                            if (table == null) throw new IOException(datsrc + " not a Table HDU");
                            table.setName(datsrc.getName());
                            table.setURL(datsrc.getURL());
                            e22 = table;
                            Object var9_12 = null;
                            if (strm == null) return e22;
                            if (table != null) return e22;
                            break block12;
                        }
                        try {
                            while ((table = FitsTableBuilder.attemptReadTable(strm, wantRandom, datsrc, pos)) == null) {
                            }
                            table.setName(datsrc.getName());
                            table.setURL(datsrc.getURL());
                            e22 = table;
                            break block13;
                        }
                        catch (EOFException e3) {
                            throw new IOException("No table HDUs in " + datsrc);
                        }
                    }
                    catch (FitsException e4) {
                        throw (TableFormatException)new TableFormatException(e4.getMessage()).initCause((Throwable)e4);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    if (strm == null) throw throwable;
                    if (table != null) throw throwable;
                    strm.close();
                    throw throwable;
                }
            }
            strm.close();
            return e22;
        }
        Object var9_13 = null;
        if (strm == null) return e22;
        if (table != null) return e22;
        strm.close();
        return e22;
    }

    public boolean canImport(DataFlavor flavor) {
        return flavor.getPrimaryType().equals("application") && flavor.getSubType().equals("fits");
    }

    public void streamStarTable(InputStream istrm, TableSink sink, String extnum) throws IOException {
        BufferedDataInputStream in = new BufferedDataInputStream(istrm);
        try {
            if (extnum != null && extnum.matches("[1-9][0-9]*")) {
                int ihdu = Integer.parseInt(extnum);
                FitsConstants.skipHDUs(in, ihdu);
                if (!this.attemptStreamStarTable(in, sink, false)) {
                    throw new IOException("No table HDU at extension " + ihdu);
                }
            } else {
                boolean done = false;
                while (!done) {
                    done = this.attemptStreamStarTable(in, sink, true);
                }
                if (!done) {
                    throw new IOException("No table extensions found");
                }
            }
        }
        catch (FitsException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private boolean attemptStreamStarTable(ArrayDataInput in, TableSink sink, boolean readAnyway) throws IOException, FitsException {
        Header hdr = new Header();
        FitsConstants.readHeader(hdr, in);
        String xtension = hdr.getStringValue("XTENSION");
        if ("BINTABLE".equals(xtension)) {
            BintableStarTable.streamStarTable(hdr, in, sink);
            return true;
        }
        if ("TABLE".equals(xtension)) {
            AsciiTable tdata = new AsciiTable(hdr);
            tdata.read(in);
            tdata.getData();
            AsciiTableHDU thdu = new AsciiTableHDU(hdr, tdata);
            Tables.streamStarTable((StarTable)new FitsStarTable(thdu), (TableSink)sink);
            return true;
        }
        if (readAnyway) {
            long datasize = FitsConstants.getDataSize(hdr);
            IOUtils.skipBytes((DataInput)in, (long)datasize);
        }
        return false;
    }

    public static StarTable attemptReadTable(ArrayDataInput strm, boolean wantRandom, DataSource datsrc, long[] pos) throws FitsException, IOException {
        Header hdr = new Header();
        int headsize = FitsConstants.readHeader(hdr, strm);
        long datasize = FitsConstants.getDataSize(hdr);
        long datpos = pos[0] + (long)headsize;
        pos[0] = pos[0] + ((long)headsize + datasize);
        String xtension = hdr.getStringValue("XTENSION");
        if ("BINTABLE".equals(xtension)) {
            if (strm instanceof RandomAccess) {
                return BintableStarTable.makeRandomStarTable(hdr, (RandomAccess)strm);
            }
            return BintableStarTable.makeSequentialStarTable(hdr, datsrc, datpos);
        }
        if ("TABLE".equals(xtension)) {
            AsciiTable tdata = new AsciiTable(hdr);
            tdata.read(strm);
            tdata.getData();
            AsciiTableHDU thdu = new AsciiTableHDU(hdr, tdata);
            return new FitsStarTable(thdu);
        }
        IOUtils.skipBytes((DataInput)strm, (long)datasize);
        return null;
    }
}

