/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public class FitsTableSerializer {
    private static Logger logger;
    private final StarTable table;
    private final ColumnWriter[] colWriters;
    private final ColumnInfo[] colInfos;
    private final long rowCount;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$fits$FitsTableSerializer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Ljava$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FitsTableSerializer(StarTable table) throws IOException {
        this.table = table;
        int ncol = table.getColumnCount();
        long nrow = table.getRowCount();
        this.colInfos = Tables.getColumnInfos((StarTable)table);
        boolean hasVarShapes = false;
        boolean hasNullableInts = false;
        int[][] shapes = new int[ncol][];
        int[] maxChars = new int[ncol];
        boolean[] useCols = new boolean[ncol];
        boolean[] varShapes = new boolean[ncol];
        boolean[] varChars = new boolean[ncol];
        boolean[] varElementChars = new boolean[ncol];
        boolean[] nullableInts = new boolean[ncol];
        Arrays.fill(useCols, true);
        int icol = 0;
        while (icol < ncol) {
            ColumnInfo colinfo = this.colInfos[icol];
            Class clazz = colinfo.getContentClass();
            if (clazz.isArray()) {
                shapes[icol] = (int[])colinfo.getShape().clone();
                int[] shape = shapes[icol];
                if (shape[shape.length - 1] < 0) {
                    varShapes[icol] = true;
                    hasVarShapes = true;
                }
                if (clazz.getComponentType().equals(class$java$lang$String == null ? FitsTableSerializer.class$("java.lang.String") : class$java$lang$String)) {
                    maxChars[icol] = colinfo.getElementSize();
                    if (maxChars[icol] <= 0) {
                        varElementChars[icol] = true;
                        hasVarShapes = true;
                    }
                }
            } else if (clazz.equals(class$java$lang$String == null ? FitsTableSerializer.class$("java.lang.String") : class$java$lang$String)) {
                maxChars[icol] = colinfo.getElementSize();
                if (maxChars[icol] <= 0) {
                    varChars[icol] = true;
                    hasVarShapes = true;
                }
            } else if (colinfo.isNullable() && (clazz == (class$java$lang$Byte == null ? FitsTableSerializer.class$("java.lang.Byte") : class$java$lang$Byte) || clazz == (class$java$lang$Short == null ? FitsTableSerializer.class$("java.lang.Short") : class$java$lang$Short) || clazz == (class$java$lang$Integer == null ? FitsTableSerializer.class$("java.lang.Integer") : class$java$lang$Integer) || clazz == (class$java$lang$Long == null ? FitsTableSerializer.class$("java.lang.Long") : class$java$lang$Long))) {
                nullableInts[icol] = true;
                hasNullableInts = true;
            }
            ++icol;
        }
        boolean[] hasNulls = new boolean[ncol];
        if (hasVarShapes || hasNullableInts || nrow < 0L) {
            int icol2;
            int[] maxElements = new int[ncol];
            nrow = 0L;
            RowSequence rseq = table.getRowSequence();
            try {
                while (rseq.next()) {
                    ++nrow;
                    icol2 = 0;
                    while (icol2 < ncol) {
                        if (useCols[icol2] && (varShapes[icol2] || varChars[icol2] || varElementChars[icol2] || nullableInts[icol2] && !hasNulls[icol2])) {
                            Object cell = rseq.getCell(icol2);
                            if (cell == null) {
                                if (nullableInts[icol2]) {
                                    hasNulls[icol2] = true;
                                }
                            } else {
                                if (varChars[icol2]) {
                                    int leng = ((String)cell).length();
                                    maxChars[icol2] = Math.max(maxChars[icol2], leng);
                                } else if (varElementChars[icol2]) {
                                    String[] svals = (String[])cell;
                                    int i = 0;
                                    while (i < svals.length) {
                                        maxChars[icol2] = Math.max(maxChars[icol2], svals[i].length());
                                        ++i;
                                    }
                                }
                                if (varShapes[icol2]) {
                                    maxElements[icol2] = Math.max(maxElements[icol2], Array.getLength(cell));
                                }
                            }
                        }
                        ++icol2;
                    }
                }
                Object var23_26 = null;
            }
            catch (Throwable throwable) {
                Object var23_27 = null;
                rseq.close();
                throw throwable;
            }
            rseq.close();
            if (hasVarShapes) {
                icol2 = 0;
                while (icol2 < ncol) {
                    if (useCols[icol2] && varShapes[icol2]) {
                        int[] shape = shapes[icol2];
                        int ndim = shape.length;
                        if (!$assertionsDisabled && shape[ndim - 1] > 0) {
                            throw new AssertionError();
                        }
                        int nel = 1;
                        int i = 0;
                        while (i < ndim - 1) {
                            nel *= shape[i];
                            ++i;
                        }
                        shape[ndim - 1] = Math.max(1, (maxElements[icol2] + nel - 1) / nel);
                    }
                    ++icol2;
                }
            }
        }
        if (!$assertionsDisabled && nrow < 0L) {
            throw new AssertionError();
        }
        this.rowCount = nrow;
        this.colWriters = new ColumnWriter[ncol];
        boolean rbytes = false;
        int icol3 = 0;
        while (icol3 < ncol) {
            if (useCols[icol3]) {
                ColumnInfo cinfo = this.colInfos[icol3];
                ColumnWriter writer = FitsTableSerializer.makeColumnWriter(cinfo, shapes[icol3], maxChars[icol3], nullableInts[icol3] && hasNulls[icol3]);
                if (writer == null) {
                    logger.warning("Ignoring column " + cinfo.getName() + " - don't know how to write to FITS");
                }
                this.colWriters[icol3] = writer;
            }
            ++icol3;
        }
    }

    public void writeHeader(DataOutput strm) throws IOException {
        int rowLength = 0;
        int nUseCol = 0;
        int ncol = this.table.getColumnCount();
        int icol = 0;
        while (icol < ncol) {
            ColumnWriter writer = this.colWriters[icol];
            if (writer != null) {
                ++nUseCol;
                rowLength += writer.getLength();
            }
            ++icol;
        }
        Header hdr = new Header();
        try {
            hdr.addValue("XTENSION", "BINTABLE", "binary table extension");
            hdr.addValue("BITPIX", 8L, "8-bit bytes");
            hdr.addValue("NAXIS", 2L, "2-dimensional table");
            hdr.addValue("NAXIS1", rowLength, "width of table in bytes");
            hdr.addValue("NAXIS2", this.rowCount, "number of rows in table");
            hdr.addValue("PCOUNT", 0L, "size of special data area");
            hdr.addValue("GCOUNT", 1L, "one data group");
            hdr.addValue("TFIELDS", nUseCol, "number of columns");
            int jcol = 0;
            int icol2 = 0;
            while (icol2 < ncol) {
                ColumnWriter colwriter = this.colWriters[icol2];
                if (colwriter != null) {
                    String comm;
                    int[] dims;
                    Number bad;
                    String forcol = " for column " + ++jcol;
                    ColumnInfo colinfo = this.colInfos[icol2];
                    String name = colinfo.getName();
                    if (name != null && name.trim().length() > 0) {
                        hdr.addValue("TTYPE" + jcol, name, "label" + forcol);
                    }
                    String form = colwriter.getFormat();
                    hdr.addValue("TFORM" + jcol, form, "format" + forcol);
                    String unit = colinfo.getUnitString();
                    if (unit != null && unit.trim().length() > 0) {
                        hdr.addValue("TUNIT" + jcol, unit, "units" + forcol);
                    }
                    if ((bad = colwriter.getBadNumber()) != null) {
                        hdr.addValue("TNULL" + jcol, bad.toString(), "blank value" + forcol);
                    }
                    if ((dims = colwriter.getDims()) != null && dims.length > 1) {
                        StringBuffer sbuf = new StringBuffer();
                        int i = 0;
                        while (i < dims.length) {
                            sbuf.append(i == 0 ? (char)'(' : ',');
                            sbuf.append(dims[i]);
                            ++i;
                        }
                        sbuf.append(')');
                        hdr.addValue("TDIM" + jcol, sbuf.toString(), "dimensions" + forcol);
                    }
                    double zero = colwriter.getZero();
                    double scale = colwriter.getScale();
                    if (zero != 0.0) {
                        hdr.addValue("TZERO" + jcol, zero, "base" + forcol);
                    }
                    if (scale != 1.0) {
                        hdr.addValue("TSCALE" + jcol, scale, "factor" + forcol);
                    }
                    if ((comm = colinfo.getDescription()) != null && comm.trim().length() > 0) {
                        if (comm.length() > 67) {
                            comm = comm.substring(0, 68);
                        }
                        try {
                            hdr.addValue("TCOMM" + jcol, comm, null);
                        }
                        catch (HeaderCardException e) {
                            logger.warning("Description " + comm + " too long for FITS header");
                        }
                    }
                }
                ++icol2;
            }
        }
        catch (FitsException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        FitsConstants.writeHeader(strm, hdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(DataOutput strm) throws IOException {
        int rowBytes = 0;
        int ncol = this.table.getColumnCount();
        int icol = 0;
        while (icol < ncol) {
            ColumnWriter writer = this.colWriters[icol];
            if (writer != null) {
                rowBytes += writer.getLength();
            }
            ++icol;
        }
        long nWritten = 0L;
        RowSequence rseq = this.table.getRowSequence();
        try {
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                int icol2 = 0;
                while (icol2 < ncol) {
                    ColumnWriter writer = this.colWriters[icol2];
                    if (writer != null) {
                        writer.writeValue(strm, row[icol2]);
                    }
                    ++icol2;
                }
                nWritten += (long)rowBytes;
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            rseq.close();
            throw throwable;
        }
        rseq.close();
        int extra = (int)(nWritten % 2880L);
        if (extra > 0) {
            strm.write(new byte[2880 - extra]);
        }
    }

    public char getFormatChar(int icol) {
        if (this.colWriters[icol] == null) {
            return '\u0000';
        }
        return this.colWriters[icol].getFormatChar();
    }

    public int[] getDimensions(int icol) {
        if (this.colWriters[icol] == null) {
            return null;
        }
        int[] dims = this.colWriters[icol].getDims();
        return dims == null ? new int[]{} : dims;
    }

    private static ColumnWriter makeColumnWriter(ColumnInfo cinfo, int[] shape, int eSize, final boolean nullableInt) {
        byte[] buf;
        Object blankObj;
        DescribedValue blankVal;
        Class clazz = cinfo.getContentClass();
        int n1 = 1;
        if (shape != null) {
            int i = 0;
            while (i < shape.length) {
                n1 *= shape[i];
                ++i;
            }
        }
        final int nel = n1;
        Number blankNum = null;
        if (nullableInt && (blankVal = cinfo.getAuxDatum(Tables.NULL_VALUE_INFO)) != null && (blankObj = blankVal.getValue()) instanceof Number) {
            blankNum = (Number)blankObj;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FitsTableSerializer.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new ColumnWriter('L', 1){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    boolean flag = Boolean.TRUE.equals(value);
                    stream.writeByte(flag ? 84 : 70);
                }
            };
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = FitsTableSerializer.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            buf = new byte[1];
            final byte badVal = blankNum == null ? (byte)0 : blankNum.byteValue();
            return new ColumnWriter('B', 1){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    byte b = value != null ? ((Number)value).byteValue() : badVal;
                    buf[0] = (byte)(b ^ 0xFFFFFF80);
                    stream.write(buf);
                }

                double getZero() {
                    return -128.0;
                }

                Number getBadNumber() {
                    return nullableInt ? new Byte(badVal) : null;
                }
            };
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = FitsTableSerializer.class$("java.lang.Short")) : class$java$lang$Short)) {
            final short badVal = blankNum == null ? (short)Short.MIN_VALUE : (short)blankNum.shortValue();
            return new ColumnWriter('I', 2){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    short sval = value != null ? ((Number)value).shortValue() : badVal;
                    stream.writeShort(sval);
                }

                Number getBadNumber() {
                    return nullableInt ? new Short(badVal) : null;
                }
            };
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = FitsTableSerializer.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            final int badVal = blankNum == null ? Integer.MIN_VALUE : blankNum.intValue();
            return new ColumnWriter('J', 4){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    int ival = value != null ? ((Number)value).intValue() : badVal;
                    stream.writeInt(ival);
                }

                Number getBadNumber() {
                    return nullableInt ? new Integer(badVal) : null;
                }
            };
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = FitsTableSerializer.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new ColumnWriter('E', 4){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    float fval = value != null ? ((Number)value).floatValue() : Float.NaN;
                    stream.writeFloat(fval);
                }
            };
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = FitsTableSerializer.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new ColumnWriter('D', 8){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    double dval = value != null ? ((Number)value).doubleValue() : Double.NaN;
                    stream.writeDouble(dval);
                }
            };
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = FitsTableSerializer.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new ColumnWriter('A', 1){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    int cval = value != null ? (int)((Character)value).charValue() : 32;
                    stream.writeByte(cval);
                }
            };
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = FitsTableSerializer.class$("java.lang.String")) : class$java$lang$String)) {
            final int maxChars = eSize;
            final byte[] buf2 = new byte[maxChars];
            final byte[] blankBuf = new byte[maxChars];
            int PAD = 32;
            final int[] charDims = new int[]{maxChars};
            Arrays.fill(blankBuf, (byte)32);
            return new ColumnWriter('A', maxChars){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    byte[] bytes;
                    if (value == null) {
                        bytes = blankBuf;
                    } else {
                        String sval = (String)value;
                        int i = 0;
                        int leng = Math.min(sval.length(), maxChars);
                        bytes = buf2;
                        while (i < leng) {
                            bytes[i] = (byte)sval.charAt(i);
                            ++i;
                        }
                        Arrays.fill(bytes, i, maxChars, (byte)32);
                    }
                    stream.write(bytes);
                }

                String getFormat() {
                    return Integer.toString(maxChars) + 'A';
                }

                int[] getDims() {
                    return charDims;
                }
            };
        }
        if (clazz == (array$Z == null ? (array$Z = FitsTableSerializer.class$("[Z")) : array$Z)) {
            buf = new byte[nel];
            int PAD = 70;
            return new ColumnWriter('L', 1, shape){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    int i = 0;
                    if (value != null) {
                        boolean[] bvals = (boolean[])value;
                        int leng = Math.min(bvals.length, nel);
                        while (i < leng) {
                            buf[i] = bvals[i] ? 84 : 70;
                            ++i;
                        }
                    }
                    Arrays.fill(buf, i, nel, (byte)70);
                    stream.write(buf);
                }
            };
        }
        if (clazz == (array$B == null ? (array$B = FitsTableSerializer.class$("[B")) : array$B)) {
            buf = new byte[nel];
            boolean PAD = false;
            return new ColumnWriter('B', 1, shape){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    int i = 0;
                    if (value != null) {
                        byte[] bvals = (byte[])value;
                        int leng = Math.min(bvals.length, nel);
                        while (i < leng) {
                            buf[i] = bvals[i];
                            ++i;
                        }
                    }
                    Arrays.fill(buf, i, nel, (byte)0);
                    int j = 0;
                    while (j < nel) {
                        buf[j] = (byte)(buf[j] ^ 0xFFFFFF80);
                        ++j;
                    }
                    stream.write(buf);
                }

                double getZero() {
                    return -128.0;
                }
            };
        }
        if (clazz == (array$S == null ? (array$S = FitsTableSerializer.class$("[S")) : array$S)) {
            boolean PAD = false;
            return new ColumnWriter('I', 2, shape){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    int i = 0;
                    if (value != null) {
                        short[] svals = (short[])value;
                        int leng = Math.min(svals.length, nel);
                        while (i < leng) {
                            stream.writeShort(svals[i]);
                            ++i;
                        }
                    }
                    while (i < nel) {
                        stream.writeShort(0);
                        ++i;
                    }
                }
            };
        }
        if (clazz == (array$I == null ? (array$I = FitsTableSerializer.class$("[I")) : array$I)) {
            boolean PAD = false;
            return new ColumnWriter('J', 4, shape){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    int i = 0;
                    if (value != null) {
                        int[] ivals = (int[])value;
                        int leng = Math.min(ivals.length, nel);
                        while (i < leng) {
                            stream.writeInt(ivals[i]);
                            ++i;
                        }
                    }
                    while (i < nel) {
                        stream.writeInt(0);
                        ++i;
                    }
                }
            };
        }
        if (clazz == (array$F == null ? (array$F = FitsTableSerializer.class$("[F")) : array$F)) {
            float PAD = Float.NaN;
            return new ColumnWriter('E', 4, shape){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    int i = 0;
                    if (value != null) {
                        float[] fvals = (float[])value;
                        int leng = Math.min(fvals.length, nel);
                        while (i < leng) {
                            stream.writeFloat(fvals[i]);
                            ++i;
                        }
                    }
                    while (i < nel) {
                        stream.writeFloat(Float.NaN);
                        ++i;
                    }
                }
            };
        }
        if (clazz == (array$D == null ? (array$D = FitsTableSerializer.class$("[D")) : array$D)) {
            double PAD = Double.NaN;
            return new ColumnWriter('D', 8, shape){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    int i = 0;
                    if (value != null) {
                        double[] dvals = (double[])value;
                        int leng = Math.min(dvals.length, nel);
                        while (i < leng) {
                            stream.writeDouble(dvals[i]);
                            ++i;
                        }
                    }
                    while (i < nel) {
                        stream.writeDouble(Double.NaN);
                        ++i;
                    }
                }
            };
        }
        if (clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = FitsTableSerializer.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            int PAD = 32;
            final int maxChars = eSize;
            int[] charDims = new int[shape.length + 1];
            charDims[0] = maxChars;
            System.arraycopy(shape, 0, charDims, 1, shape.length);
            final byte[] buf3 = new byte[maxChars];
            return new ColumnWriter('A', 1, charDims){

                void writeValue(DataOutput stream, Object value) throws IOException {
                    int i = 0;
                    if (value != null) {
                        String[] svals = (String[])value;
                        int leng = Math.min(svals.length, nel);
                        while (i < leng) {
                            String str = svals[i];
                            int j = 0;
                            if (str != null) {
                                int sleng = Math.min(str.length(), maxChars);
                                while (j < sleng) {
                                    buf3[j] = (byte)str.charAt(j);
                                    ++j;
                                }
                            }
                            Arrays.fill(buf3, j, maxChars, (byte)32);
                            stream.write(buf3);
                            ++i;
                        }
                    }
                    if (i < nel) {
                        Arrays.fill(buf3, (byte)32);
                        while (i < nel) {
                            stream.write(buf3);
                            ++i;
                        }
                    }
                }

                String getFormat() {
                    return Integer.toString(maxChars * nel) + 'A';
                }
            };
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$fits$FitsTableSerializer == null ? (class$uk$ac$starlink$fits$FitsTableSerializer = FitsTableSerializer.class$("uk.ac.starlink.fits.FitsTableSerializer")) : class$uk$ac$starlink$fits$FitsTableSerializer).desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.fits");
    }

    private static abstract class ColumnWriter {
        final int length;
        final int[] dims;
        final char formatChar;
        String format;

        ColumnWriter(char formatChar, int elength, int[] dims) {
            this.formatChar = formatChar;
            this.dims = dims;
            int nel = 1;
            if (dims != null) {
                int i = 0;
                while (i < dims.length) {
                    nel *= dims[i];
                    ++i;
                }
            }
            this.length = elength * nel;
            this.format = nel == 1 ? "" + formatChar : Integer.toString(nel) + formatChar;
        }

        ColumnWriter(char formatChar, int length) {
            this(formatChar, length, null);
        }

        abstract void writeValue(DataOutput var1, Object var2) throws IOException;

        char getFormatChar() {
            return this.formatChar;
        }

        String getFormat() {
            return this.format;
        }

        int getLength() {
            return this.length;
        }

        int[] getDims() {
            return this.dims;
        }

        double getZero() {
            return 0.0;
        }

        double getScale() {
            return 1.0;
        }

        Number getBadNumber() {
            return null;
        }
    }
}

