/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.srb;

import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import uk.ac.starlink.connect.AuthKey;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;
import uk.ac.starlink.srb.SRBConnection;

public class SRBConnector
implements Connector {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.srb");
    private static Icon icon_;
    private static final AuthKey HOST_KEY;
    private static final AuthKey PORT_KEY;
    private static final AuthKey USER_KEY;
    private static final AuthKey PASSWORD_KEY;
    private static final AuthKey HOME_KEY;
    private static final AuthKey DOMAIN_KEY;
    private static final AuthKey RESOURCE_KEY;
    private static AuthKey[] authKeys_;

    public Icon getIcon() {
        if (icon_ == null) {
            URL url = this.getClass().getResource("jig3.gif");
            icon_ = url == null ? null : new ImageIcon(url);
        }
        return icon_;
    }

    public String getName() {
        return "SRB";
    }

    public AuthKey[] getKeys() {
        if (authKeys_ == null) {
            authKeys_ = new AuthKey[]{HOST_KEY, PORT_KEY, USER_KEY, PASSWORD_KEY, HOME_KEY, DOMAIN_KEY, RESOURCE_KEY};
            SRBConnector.configureKeys();
        }
        return (AuthKey[])authKeys_.clone();
    }

    public Connection logIn(Map authValues) throws IOException {
        int port;
        String host = (String)authValues.get(HOST_KEY);
        String portVal = (String)authValues.get(PORT_KEY);
        try {
            port = Integer.parseInt(portVal);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad port number: " + portVal);
        }
        String userName = (String)authValues.get(USER_KEY);
        char[] passVal = (char[])authValues.get(PASSWORD_KEY);
        String password = passVal == null ? null : new String(passVal);
        String homeDirectory = (String)authValues.get(HOME_KEY);
        String mdasDomainName = (String)authValues.get(DOMAIN_KEY);
        String defaultStorageResource = (String)authValues.get(RESOURCE_KEY);
        SRBAccount account = new SRBAccount(host, port, userName, password, homeDirectory, mdasDomainName, defaultStorageResource);
        SRBFileSystem filesys = new SRBFileSystem(account);
        SRBFile homeDir = new SRBFile(filesys, homeDirectory);
        if (!homeDir.isDirectory()) {
            throw new IOException("Home " + homeDirectory + " not a directory");
        }
        return new SRBConnection(this, authValues, homeDir);
    }

    private static void configureKeys() {
        Map envInfo = SRBConnector.getMdasEnvInfo();
        HOST_KEY.setDefault((String)envInfo.get("srbHost"));
        PORT_KEY.setDefault(envInfo.containsKey("srbPort") ? (String)envInfo.get("srbPort") : "5544");
        USER_KEY.setDefault((String)envInfo.get("srbUser"));
        HOME_KEY.setDefault((String)envInfo.get("mdasCollectionName"));
        HOME_KEY.setRequired(true);
        DOMAIN_KEY.setDefault((String)envInfo.get("mdasDomainName"));
        RESOURCE_KEY.setDefault((String)envInfo.get("defaultResource"));
        PASSWORD_KEY.setDefault(SRBConnector.getMdasAuth());
        PASSWORD_KEY.setHidden(true);
    }

    /*
     * WARNING - void declaration
     */
    private static Map getMdasEnvInfo() {
        HashMap<String, String> envInfo = new HashMap<String, String>();
        File configDir = new File(System.getProperty("user.home"), ".srb");
        File envFile = new File(configDir, ".MdasEnv");
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(envFile));
            Pattern kvpat = Pattern.compile(" *([a-zA-Z_]+) +'(.*)' *");
            while ((line = reader.readLine()) != null) {
                void var5_7;
                Matcher match = kvpat.matcher((CharSequence)var5_7);
                if (!match.matches()) continue;
                envInfo.put(match.group(1), match.group(2));
            }
            reader.close();
        }
        catch (IOException e) {
            logger_.info("Can't read MDAS env file for SRB config (" + e + ")");
        }
        catch (SecurityException e) {
            logger_.info("Can't read MDAS env file for SRB config (" + e + ")");
        }
        return envInfo;
    }

    private static String getMdasAuth() {
        File configDir = new File(System.getProperty("user.home"), ".srb");
        File authFile = new File(configDir, ".MdasAuth");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(authFile));
            String line = reader.readLine();
            return line;
        }
        catch (IOException e) {
            logger_.info("Can't read MDAS auth file");
            return null;
        }
    }

    static {
        HOST_KEY = new AuthKey("SRB Host");
        PORT_KEY = new AuthKey("SRB Port");
        USER_KEY = new AuthKey("User Name");
        PASSWORD_KEY = new AuthKey("Password");
        HOME_KEY = new AuthKey("Home Directory");
        DOMAIN_KEY = new AuthKey("MDAS Home Domain");
        RESOURCE_KEY = new AuthKey("Default Storage Resource");
    }
}

