/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.srb;

import edu.sdsc.grid.io.srb.SRBFile;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.Node;
import uk.ac.starlink.srb.SRBBranch;
import uk.ac.starlink.srb.SRBLeaf;

public abstract class SRBNode
implements Node {
    private final SRBFile file_;
    private final SRBFile root_;
    private final String name_;
    private final boolean isRoot_;

    public SRBNode(SRBFile srbFile, SRBFile srbRoot) {
        this.file_ = srbFile;
        this.root_ = srbRoot;
        this.isRoot_ = srbFile.equals(srbRoot);
        String name = this.file_.getName();
        this.name_ = name.substring(name.indexOf(47) + 1);
    }

    public String getName() {
        return this.name_;
    }

    public Branch getParent() {
        return this.isRoot_ ? null : new SRBBranch((SRBFile)this.file_.getParentFile(), this.root_);
    }

    public SRBFile getFile() {
        return this.file_;
    }

    SRBFile getRoot() {
        return this.root_;
    }

    public boolean equals(Object other) {
        if (other.getClass().equals(this.getClass())) {
            return this.file_.equals(((SRBNode)other).file_);
        }
        return false;
    }

    public int hashCode() {
        return this.file_.hashCode();
    }

    public String toString() {
        return this.file_.toString();
    }

    SRBNode createNode(SRBFile file) {
        boolean isDir = file.isDirectory();
        return isDir ? new SRBBranch(file, this.root_) : new SRBLeaf(file, this.root_);
    }
}

