/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import gnu.jel.CompilationException;
import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.AddJELColumnTable;
import uk.ac.starlink.ttools.ColumnIdentifier;
import uk.ac.starlink.ttools.ProcessingFilter;
import uk.ac.starlink.ttools.ProcessingStep;

public class AddColumnFilter
implements ProcessingFilter {
    public String getName() {
        return "addcol";
    }

    public String getFilterUsage() {
        return "[-after <col-id> | -before <col-id>] <col-name> <expr>";
    }

    public ProcessingStep createStep(Iterator argIt) {
        String posId = null;
        String colName = null;
        String expr = null;
        boolean after = false;
        while (argIt.hasNext() && (colName == null || expr == null)) {
            String arg = (String)argIt.next();
            if (arg.equals("-after") && posId == null && argIt.hasNext()) {
                argIt.remove();
                after = true;
                posId = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-before") && posId == null && argIt.hasNext()) {
                argIt.remove();
                after = false;
                posId = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (colName == null) {
                argIt.remove();
                colName = arg;
                continue;
            }
            if (expr != null) continue;
            argIt.remove();
            expr = arg;
        }
        if (colName != null && expr != null) {
            ColumnInfo colinfo = new ColumnInfo(colName);
            return new AddColumnStep(expr, colinfo, posId, after);
        }
        return null;
    }

    private static class AddColumnStep
    implements ProcessingStep {
        final String expr_;
        final ColumnInfo cinfo_;
        final String placeColid_;
        final boolean after_;

        AddColumnStep(String expr, ColumnInfo cinfo, String placeColid, boolean after) {
            this.cinfo_ = cinfo;
            this.expr_ = expr;
            this.placeColid_ = placeColid;
            this.after_ = after;
        }

        public StarTable wrap(StarTable base) throws IOException {
            int ipos;
            if (this.placeColid_ != null) {
                int iplace = new ColumnIdentifier(base).getColumnIndex(this.placeColid_);
                ipos = this.after_ ? iplace + 1 : iplace;
            } else {
                ipos = base.getColumnCount();
            }
            try {
                return new AddJELColumnTable(base, this.cinfo_, this.expr_, ipos);
            }
            catch (CompilationException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
    }
}

