/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.JELUtils;
import uk.ac.starlink.ttools.RandomJELRowReader;
import uk.ac.starlink.ttools.SequentialJELRowReader;

public class AddJELColumnTable
extends WrapperStarTable {
    private final StarTable baseTable_;
    private final String expr_;
    private final int[] colMap_;
    private final RandomJELRowReader randomReader_;
    private final CompiledExpression randomCompex_;
    private final ColumnInfo addInfo_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$AddJELColumnTable;

    public AddJELColumnTable(StarTable baseTable, ColumnInfo cinfo, String expr, int ipos) throws CompilationException {
        super(baseTable);
        this.baseTable_ = baseTable;
        this.expr_ = expr;
        this.colMap_ = new int[baseTable.getColumnCount() + 1];
        int j = 0;
        int i = 0;
        while (i < this.colMap_.length) {
            this.colMap_[i] = i == ipos ? -1 : j++;
            ++i;
        }
        if (!$assertionsDisabled && j != baseTable.getColumnCount()) {
            throw new AssertionError();
        }
        this.randomReader_ = new RandomJELRowReader(baseTable);
        Library lib = JELUtils.getLibrary(this.randomReader_);
        this.randomCompex_ = Evaluator.compile(this.expr_, lib);
        Class clazz = JELUtils.getWrapperType(JELUtils.getExpressionType(lib, expr));
        this.addInfo_ = cinfo;
        this.addInfo_.setContentClass(clazz);
    }

    public int getColumnCount() {
        return this.colMap_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        int ibase = this.colMap_[icol];
        return ibase >= 0 ? super.getColumnInfo(ibase) : this.addInfo_;
    }

    public Object getCell(long irow, int icol) throws IOException {
        int ibase = this.colMap_[icol];
        return ibase >= 0 ? super.getCell(irow, ibase) : this.evaluateAtRow(irow);
    }

    public Object[] getRow(long irow) throws IOException {
        Object[] baseRow = super.getRow(irow);
        int ncol = this.colMap_.length;
        if (!$assertionsDisabled && ncol != baseRow.length + 1) {
            throw new AssertionError();
        }
        Object[] row = new Object[ncol];
        int icol = 0;
        while (icol < ncol) {
            int ibase = this.colMap_[icol];
            row[icol] = ibase >= 0 ? baseRow[ibase] : this.evaluateAtRow(irow);
            ++icol;
        }
        return row;
    }

    public RowSequence getRowSequence() throws IOException {
        CompiledExpression seqCompex;
        final SequentialJELRowReader seqReader = new SequentialJELRowReader(this.baseTable_);
        try {
            seqCompex = Evaluator.compile(this.expr_, JELUtils.getLibrary(seqReader));
        }
        catch (CompilationException e) {
            throw (IOException)new IOException("Bad expression: " + this.expr_).initCause(e);
        }
        return new WrapperRowSequence(seqReader){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Object getCell(int icol) throws IOException {
                int ibase = AddJELColumnTable.this.colMap_[icol];
                return ibase >= 0 ? super.getCell(ibase) : this.evaluate();
            }

            public Object[] getRow() throws IOException {
                Object[] baseRow = super.getRow();
                int ncol = AddJELColumnTable.this.colMap_.length;
                if (!$assertionsDisabled && ncol != baseRow.length + 1) {
                    throw new AssertionError();
                }
                Object[] row = new Object[ncol];
                int icol = 0;
                while (icol < ncol) {
                    int ibase = AddJELColumnTable.this.colMap_[icol];
                    row[icol] = ibase >= 0 ? baseRow[ibase] : this.evaluate();
                    ++icol;
                }
                return row;
            }

            private Object evaluate() throws IOException {
                try {
                    return seqReader.evaluate(seqCompex);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$ttools$AddJELColumnTable == null ? (class$uk$ac$starlink$ttools$AddJELColumnTable = AddJELColumnTable.class$("uk.ac.starlink.ttools.AddJELColumnTable")) : class$uk$ac$starlink$ttools$AddJELColumnTable).desiredAssertionStatus();
            }
        };
    }

    private Object evaluateAtRow(long irow) throws IOException {
        try {
            return this.randomReader_.evaluateAtRow(this.randomCompex_, irow);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$ttools$AddJELColumnTable == null ? (class$uk$ac$starlink$ttools$AddJELColumnTable = AddJELColumnTable.class$("uk.ac.starlink.ttools.AddJELColumnTable")) : class$uk$ac$starlink$ttools$AddJELColumnTable).desiredAssertionStatus();
    }
}

