/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.ColumnIdentifier;
import uk.ac.starlink.ttools.ProcessingFilter;
import uk.ac.starlink.ttools.ProcessingStep;

public class ColumnSortFilter
implements ProcessingFilter {
    public String getName() {
        return "sort";
    }

    public String getFilterUsage() {
        return "[-down] [-nullsfirst] <colid-list>";
    }

    public ProcessingStep createStep(Iterator argIt) {
        boolean up = true;
        boolean nullsLast = true;
        String colidList = null;
        while (argIt.hasNext() && colidList == null) {
            String arg = (String)argIt.next();
            if (arg.equals("-down")) {
                argIt.remove();
                up = false;
                continue;
            }
            if (arg.equals("-nullsfirst")) {
                argIt.remove();
                nullsLast = false;
                continue;
            }
            argIt.remove();
            colidList = arg;
        }
        if (colidList != null) {
            return new ColumnSortStep(colidList.split("\\s+"), up, nullsLast);
        }
        return null;
    }

    private static class ColumnSortStep
    implements ProcessingStep {
        final String[] colIds_;
        final boolean up_;
        final boolean nullsLast_;

        ColumnSortStep(String[] colIds, boolean up, boolean nullsLast) {
            this.colIds_ = colIds;
            this.up_ = up;
            this.nullsLast_ = nullsLast;
        }

        public StarTable wrap(StarTable base) throws IOException {
            ColumnIdentifier identifier = new ColumnIdentifier(base);
            int[] colIndices = new int[this.colIds_.length];
            int i = 0;
            while (i < this.colIds_.length) {
                colIndices[i] = identifier.getColumnIndex(this.colIds_[i]);
                ++i;
            }
            return Tables.sortTable(base, colIndices, this.up_, this.nullsLast_);
        }
    }
}

