/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.ttools.ProcessingMode;

public class CopyMode
extends ProcessingMode {
    private String outLoc_;
    private String outFmt_;
    private StarTableOutput toutput_;

    public String getName() {
        return "write";
    }

    public boolean setArgs(List argList) {
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (!arg.startsWith("-") || arg.length() <= 1) continue;
            if (arg.equals("-ofmt")) {
                it.remove();
                if (it.hasNext()) {
                    this.outFmt_ = (String)it.next();
                    it.remove();
                    continue;
                }
                return false;
            }
            if (!arg.equals("-o") && !arg.equals("-out")) continue;
            it.remove();
            if (it.hasNext()) {
                this.outLoc_ = (String)it.next();
                it.remove();
                continue;
            }
            return false;
        }
        return true;
    }

    public String getModeUsage() {
        return "[-ofmt <out-format>] [-o <out-table>]";
    }

    public String getHelp() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n   Known out-formats:\n");
        Iterator it = this.getTableOutput().getKnownFormats().iterator();
        while (it.hasNext()) {
            buf.append("      ").append(((String)it.next()).toLowerCase()).append('\n');
        }
        return buf.toString();
    }

    public void process(StarTable table) throws IOException {
        StarTableOutput toutput = this.getTableOutput();
        if (this.outLoc_ == null) {
            if (this.outFmt_ == null) {
                this.outFmt_ = "text";
            }
            toutput.writeStarTable(table, System.out, toutput.getHandler(this.outFmt_));
        } else {
            toutput.writeStarTable(table, this.outLoc_, this.outFmt_);
        }
    }

    private StarTableOutput getTableOutput() {
        if (this.toutput_ == null) {
            this.toutput_ = new StarTableOutput();
        }
        return this.toutput_;
    }
}

