/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.EveryTable;
import uk.ac.starlink.ttools.ProcessingFilter;
import uk.ac.starlink.ttools.ProcessingStep;

public class EveryFilter
implements ProcessingFilter {
    public String getName() {
        return "every";
    }

    public String getFilterUsage() {
        return "<step>";
    }

    public ProcessingStep createStep(Iterator argIt) {
        if (argIt.hasNext()) {
            long count = Long.parseLong((String)argIt.next());
            if (count <= 0L) {
                throw new IllegalArgumentException("Step must be >= 1");
            }
            argIt.remove();
            return new EveryStep(count);
        }
        return null;
    }

    private static class EveryStep
    implements ProcessingStep {
        final long count_;

        EveryStep(long count) {
            this.count_ = count;
        }

        public StarTable wrap(StarTable base) {
            return new EveryTable(base, this.count_);
        }
    }
}

