/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.IOException;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class EveryTable
extends WrapperStarTable {
    private final long step_;

    public EveryTable(StarTable base, long step) {
        super(base);
        this.step_ = step;
    }

    public long getRowCount() {
        long baseCount = super.getRowCount();
        if (baseCount >= 0L) {
            return baseCount / this.step_;
        }
        return baseCount;
    }

    public Object getCell(long irow, int icol) throws IOException {
        return super.getCell(irow * this.step_, icol);
    }

    public Object[] getRow(long irow) throws IOException {
        return super.getRow(irow * this.step_);
    }

    public RowSequence getRowSequence() throws IOException {
        return new WrapperRowSequence(super.getRowSequence()){
            boolean started;

            public boolean next() throws IOException {
                if (this.started) {
                    int i = 0;
                    while ((long)i < EveryTable.this.step_) {
                        if (!super.next()) {
                            return false;
                        }
                        ++i;
                    }
                } else {
                    this.started = true;
                    return super.next();
                }
                return true;
            }
        };
    }
}

