/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.JELUtils;
import uk.ac.starlink.ttools.ProcessingFilter;
import uk.ac.starlink.ttools.ProcessingStep;
import uk.ac.starlink.ttools.RandomJELRowReader;

public class ExpressionSortFilter
implements ProcessingFilter {
    private static final boolean ALLOW_SUBKEYS = false;

    public String getName() {
        return "sortexpr";
    }

    public String getFilterUsage() {
        return "<expr>";
    }

    public ProcessingStep createStep(Iterator argIt) {
        LinkedList<String> keyList;
        block0: {
            keyList = new LinkedList<String>();
            if (!argIt.hasNext()) break block0;
            String arg = (String)argIt.next();
            argIt.remove();
            keyList.add(0, arg);
        }
        return new SortStep(keyList.toArray(new String[0]));
    }

    private static class SortException
    extends RuntimeException {
        SortException(String msg, Throwable e) {
            super(msg, e);
        }

        IOException asIOException() {
            Throwable error = this.getCause();
            return error instanceof IOException ? (IOException)error : (IOException)new IOException(error.getMessage()).initCause(error);
        }
    }

    private static class RowComparator
    implements Comparator {
        final CompiledExpression[] compExs_;
        final int nexpr_;
        final RandomJELRowReader rowReader_;
        boolean nullsLast_;

        public RowComparator(StarTable table, String[] keys) throws CompilationException {
            this.nexpr_ = keys.length;
            this.rowReader_ = new RandomJELRowReader(table);
            Library lib = JELUtils.getLibrary(this.rowReader_);
            this.compExs_ = new CompiledExpression[this.nexpr_];
            int i = 0;
            while (i < this.nexpr_) {
                this.compExs_[i] = Evaluator.compile(keys[i], lib);
                ++i;
            }
        }

        public int compare(Object o1, Object o2) {
            long row1 = ((Number)o1).longValue();
            long row2 = ((Number)o2).longValue();
            int c = 0;
            int i = 0;
            while (i < this.nexpr_ && c == 0) {
                Object val2;
                Object val1;
                CompiledExpression compEx = this.compExs_[i];
                try {
                    val1 = this.rowReader_.evaluateAtRow(compEx, row1);
                    val2 = this.rowReader_.evaluateAtRow(compEx, row2);
                }
                catch (Throwable e) {
                    throw new SortException("Sort error", e);
                }
                try {
                    c = this.compareValues((Comparable)val1, (Comparable)val2);
                }
                catch (ClassCastException e) {
                    throw new SortException("Expression comparison error during sorting", e);
                }
                ++i;
            }
            return c;
        }

        private int compareValues(Comparable o1, Comparable o2) {
            boolean null1 = Tables.isBlank(o1);
            boolean null2 = Tables.isBlank(o2);
            if (null1 && null2) {
                return 0;
            }
            if (null1) {
                return this.nullsLast_ ? -1 : 1;
            }
            if (null2) {
                return this.nullsLast_ ? 1 : -1;
            }
            return o1.compareTo(o2);
        }
    }

    private static class SortStep
    implements ProcessingStep {
        final String[] keys_;

        SortStep(String[] keys) {
            this.keys_ = keys;
        }

        public StarTable wrap(StarTable baseTable) throws IOException {
            RowComparator keyComparator;
            long lnrow = (baseTable = Tables.randomTable(baseTable)).getRowCount();
            if (lnrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Sorry, can't sort tables with >2^31 rows");
            }
            int nrow = (int)lnrow;
            Number[] rowMap = new Number[nrow];
            int i = 0;
            while (i < nrow) {
                rowMap[i] = new Integer(i);
                ++i;
            }
            try {
                keyComparator = new RowComparator(baseTable, this.keys_);
            }
            catch (CompilationException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            try {
                Arrays.sort(rowMap, keyComparator);
            }
            catch (SortException e) {
                throw e.asIOException();
            }
            long[] rmap = new long[nrow];
            int i2 = 0;
            while (i2 < nrow) {
                rmap[i2] = rowMap[i2].longValue();
                ++i2;
            }
            return new RowPermutedStarTable(baseTable, rmap);
        }
    }
}

