/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.HeadTable;
import uk.ac.starlink.ttools.ProcessingFilter;
import uk.ac.starlink.ttools.ProcessingStep;

public class HeadFilter
implements ProcessingFilter {
    public String getName() {
        return "head";
    }

    public String getFilterUsage() {
        return "<nrows>";
    }

    public ProcessingStep createStep(Iterator argIt) {
        if (argIt.hasNext()) {
            long count = Long.parseLong((String)argIt.next());
            if (count < 0L) {
                throw new IllegalArgumentException("Nrows must be >= 0");
            }
            argIt.remove();
            return new HeadStep(count);
        }
        return null;
    }

    private static class HeadStep
    implements ProcessingStep {
        final long count_;

        HeadStep(long count) {
            this.count_ = count;
        }

        public StarTable wrap(StarTable base) {
            return new HeadTable(base, this.count_);
        }
    }
}

