/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.table.jdbc.TerminalAuthenticator;
import uk.ac.starlink.ttools.ProcessingMode;

public class JdbcMode
extends ProcessingMode {
    private String url_;
    private String user_;
    private String password_;

    public String getName() {
        return "tosql";
    }

    public boolean setArgs(List argList) {
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.startsWith("-") && arg.length() > 1) {
                if (arg.equals("-user")) {
                    it.remove();
                    if (it.hasNext()) {
                        this.user_ = (String)it.next();
                        it.remove();
                        continue;
                    }
                    return false;
                }
                if (arg.equals("-password")) {
                    it.remove();
                    if (it.hasNext()) {
                        this.password_ = (String)it.next();
                        it.remove();
                        continue;
                    }
                    return false;
                }
                if (!arg.equals("-url")) continue;
                it.remove();
                if (it.hasNext()) {
                    this.url_ = (String)it.next();
                    it.remove();
                    continue;
                }
                return false;
            }
            if (this.url_ != null) continue;
            it.remove();
            this.url_ = arg;
        }
        return this.url_ != null;
    }

    public String getModeUsage() {
        return "<jdbc-url> [-user <username>] [-password <password>]";
    }

    public void process(StarTable table) throws IOException {
        JDBCAuthenticator authenticator = new JDBCAuthenticator(){

            public String[] authenticate() throws IOException {
                if (JdbcMode.this.user_ == null) {
                    JdbcMode.this.user_ = TerminalAuthenticator.readUser();
                }
                if (JdbcMode.this.password_ == null) {
                    JdbcMode.this.password_ = TerminalAuthenticator.readPassword();
                }
                return new String[]{JdbcMode.this.user_, JdbcMode.this.password_};
            }
        };
        JDBCHandler handler = new JDBCHandler(authenticator);
        try {
            handler.createJDBCTable(table, this.url_);
        }
        catch (SQLException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }
}

