/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.ColumnIdentifier;
import uk.ac.starlink.ttools.ProcessingFilter;
import uk.ac.starlink.ttools.ProcessingStep;

public class KeepColumnFilter
implements ProcessingFilter {
    public String getName() {
        return "keepcols";
    }

    public String getFilterUsage() {
        return "<colid-list>";
    }

    public ProcessingStep createStep(Iterator argIt) {
        if (argIt.hasNext()) {
            String colIdList = (String)argIt.next();
            argIt.remove();
            final String[] colIds = colIdList.split("\\s+");
            return new ProcessingStep(){

                public StarTable wrap(StarTable base) throws IOException {
                    return KeepColumnFilter.keepColumnTable(base, colIds);
                }
            };
        }
        return null;
    }

    public static StarTable keepColumnTable(StarTable table, String[] colIds) throws IOException {
        ColumnIdentifier identifier = new ColumnIdentifier(table);
        int[] colMap = new int[colIds.length];
        int i = 0;
        while (i < colIds.length) {
            colMap[i] = identifier.getColumnIndex(colIds[i]);
            ++i;
        }
        return new ColumnPermutedStarTable(table, colMap);
    }
}

