/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.ProcessingMode;

public class MetadataMode
extends ProcessingMode {
    private PrintStream out_ = this.getOutputStream();

    public String getName() {
        return "meta";
    }

    public void process(StarTable table) throws IOException {
        long nrow = table.getRowCount();
        int ncol = table.getColumnCount();
        String name = table.getName();
        this.out_.println();
        if (name != null && name.trim().length() > 0) {
            this.out_.println("Name:    " + name.trim());
        }
        this.out_.println("Columns: " + new Integer(ncol));
        this.out_.println("Rows:    " + (nrow >= 0L ? Long.toString(nrow) : "?"));
        List params = table.getParameters();
        if (params.size() > 0) {
            this.out_.println();
            this.out_.println("Parameters");
            this.out_.println("----------");
            Iterator it = table.getParameters().iterator();
            while (it.hasNext()) {
                DescribedValue param = (DescribedValue)it.next();
                this.outMeta(param.getInfo().getName(), param.getValue());
            }
        }
        this.out_.println();
        this.out_.println("Columns");
        this.out_.println("-------");
        ColumnInfo[] cinfos = Tables.getColumnInfos(table);
        int icol = 0;
        while (icol < ncol) {
            String scol = Integer.toString(icol + 1);
            int i = scol.length();
            while (i < 6) {
                this.out_.print(' ');
                ++i;
            }
            this.out_.print(scol + ": ");
            ColumnInfo cinfo = cinfos[icol];
            this.out_.println(cinfo);
            ++icol;
        }
    }

    private void outMeta(String key, Object val) {
        String value;
        String pad = "    ";
        if (val != null && (value = val.toString().trim()).length() > 0) {
            this.out_.println(key + ":");
            value = pad + value.replaceAll("\n", pad + "\n");
            this.out_.println(value);
        }
    }
}

