/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import gnu.jel.CompilationException;
import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.JELSelectorTable;
import uk.ac.starlink.ttools.ProcessingFilter;
import uk.ac.starlink.ttools.ProcessingStep;

public class SelectFilter
implements ProcessingFilter {
    public String getName() {
        return "select";
    }

    public String getFilterUsage() {
        return "<expr>";
    }

    public ProcessingStep createStep(Iterator argIt) {
        if (argIt.hasNext()) {
            String expr = (String)argIt.next();
            argIt.remove();
            return new SelectStep(expr);
        }
        return null;
    }

    private static class SelectStep
    implements ProcessingStep {
        final String expr_;

        public SelectStep(String expr) {
            this.expr_ = expr;
        }

        public StarTable wrap(StarTable base) throws IOException {
            try {
                return new JELSelectorTable(base, this.expr_);
            }
            catch (CompilationException e) {
                String msg = "Bad expression \"" + this.expr_ + "\" (" + e.getMessage() + ")";
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
    }
}

