/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.table.ProgressLineStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.ttools.CopyMode;
import uk.ac.starlink.ttools.ProcessingFilter;
import uk.ac.starlink.ttools.ProcessingMode;
import uk.ac.starlink.ttools.ProcessingStep;
import uk.ac.starlink.ttools.StreamRowStore;
import uk.ac.starlink.ttools.TableTask;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.Loader;

public class TablePipe
extends TableTask {
    private String inLoc_;
    private String inFmt_;
    private boolean stream_;
    private ProcessingMode mode_;
    private List pipeline_ = new ArrayList();
    private final ProcessingMode[] modes_ = Loader.getClassInstances(MODE_NAMES, "tpipe.modes", class$uk$ac$starlink$ttools$ProcessingMode == null ? (class$uk$ac$starlink$ttools$ProcessingMode = TablePipe.class$("uk.ac.starlink.ttools.ProcessingMode")) : class$uk$ac$starlink$ttools$ProcessingMode).toArray(new ProcessingMode[0]);
    private final ProcessingFilter[] filters_ = Loader.getClassInstances(FILTER_NAMES, "tpipe.filters", class$uk$ac$starlink$ttools$ProcessingFilter == null ? (class$uk$ac$starlink$ttools$ProcessingFilter = TablePipe.class$("uk.ac.starlink.ttools.ProcessingFilter")) : class$uk$ac$starlink$ttools$ProcessingFilter).toArray(new ProcessingFilter[0]);
    private static final String[] MODE_NAMES;
    private static final String[] FILTER_NAMES;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$CopyMode;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$JdbcMode;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$MetadataMode;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$StatsMode;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$CountMode;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$SelectFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$ColumnSortFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$ExpressionSortFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$EveryFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$HeadFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$TailFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$AddColumnFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$KeepColumnFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$DeleteColumnFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$ExplodeFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$CacheFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$RandomFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$SequentialFilter;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$ProcessingMode;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$ProcessingFilter;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$TablePipe;

    public String getCommandName() {
        return "tpipe";
    }

    public boolean setArgs(List argList) {
        if (!super.setArgs(argList)) {
            return false;
        }
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.startsWith("-") && arg.length() > 1) {
                if (arg.equals("-ifmt")) {
                    it.remove();
                    if (it.hasNext()) {
                        this.inFmt_ = (String)it.next();
                        it.remove();
                        continue;
                    }
                    return false;
                }
                if (arg.equals("-stream")) {
                    it.remove();
                    this.stream_ = true;
                    continue;
                }
                int i = 0;
                while (i < this.modes_.length) {
                    ProcessingMode mode = this.modes_[i];
                    if (arg.equals("-" + mode.getName())) {
                        it.remove();
                        if (this.mode_ == null) {
                            this.mode_ = mode;
                        } else {
                            return false;
                        }
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.filters_.length) {
                    ProcessingFilter filter = this.filters_[i2];
                    if (arg.equals("-" + filter.getName())) {
                        it.remove();
                        ProcessingStep step = null;
                        try {
                            step = filter.createStep(it);
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e.getMessage());
                        }
                        if (step == null) {
                            String fname = filter.getName();
                            String fusage = filter.getFilterUsage();
                            String msg = fname + " mode usage: \n" + "      -" + fname;
                            if (fusage != null) {
                                msg = msg + " " + fusage;
                            }
                            System.err.println(msg);
                            return false;
                        }
                        this.pipeline_.add(step);
                    }
                    ++i2;
                }
                continue;
            }
            if (this.inLoc_ != null) continue;
            it.remove();
            this.inLoc_ = arg;
        }
        if (this.mode_ == null) {
            this.mode_ = new CopyMode();
        }
        return this.mode_.setArgs(argList);
    }

    public StarTable getInputTable() throws IOException {
        StarTable table;
        if (this.inLoc_ == null) {
            throw new IOException("No input table specified");
        }
        if (this.inLoc_.equals("-") || this.stream_) {
            BufferedInputStream in = new BufferedInputStream(DataSource.getInputStream(this.inLoc_));
            table = this.getStreamedTable(in);
        } else {
            table = this.getTableFactory().makeStarTable(this.inLoc_, this.inFmt_);
        }
        if (this.isVerbose()) {
            table = new ProgressLineStarTable(table, System.err);
        }
        Iterator it = this.pipeline_.iterator();
        while (it.hasNext()) {
            ProcessingStep step = (ProcessingStep)it.next();
            table = step.wrap(table);
        }
        return table;
    }

    public StarTable getStreamedTable(final InputStream in) throws IOException {
        if (this.inFmt_ == null) {
            throw new IOException("Can't stream without named input format");
        }
        final TableBuilder tbuilder = this.getTableFactory().getTableBuilder(this.inFmt_);
        if (!$assertionsDisabled && tbuilder == null) {
            throw new AssertionError();
        }
        final StreamRowStore streamStore = new StreamRowStore(1024);
        new Thread("Table Streamer"){

            public void run() {
                try {
                    tbuilder.streamStarTable(in, streamStore, null);
                }
                catch (IOException e) {
                    streamStore.setError(e);
                }
            }
        }.start();
        return streamStore.getStarTable();
    }

    public void execute() throws IOException {
        this.mode_.process(this.getInputTable());
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer(super.getHelp());
        help.append("\n   Mode flags - Use one of:\n");
        int i = 0;
        while (i < this.modes_.length) {
            ProcessingMode mode = this.modes_[i];
            help.append("      -").append(mode.getName());
            String modeUsage = mode.getModeUsage();
            if (modeUsage != null) {
                help.append(' ').append(modeUsage);
            }
            help.append('\n');
            ++i;
        }
        help.append("\n   Filter flags - Use any sequence of:\n");
        int i2 = 0;
        while (i2 < this.filters_.length) {
            ProcessingFilter filter = this.filters_[i2];
            help.append("      -").append(filter.getName());
            String filterUsage = filter.getFilterUsage();
            if (filterUsage != null) {
                help.append(' ').append(filterUsage);
            }
            help.append('\n');
            ++i2;
        }
        help.append("\n   Auto-detected in-formats:\n");
        Iterator it = this.getTableFactory().getDefaultBuilders().iterator();
        while (it.hasNext()) {
            help.append("      ").append(((TableBuilder)it.next()).getFormatName().toLowerCase()).append('\n');
        }
        help.append("\n   Known in-formats:\n");
        Iterator it2 = this.getTableFactory().getKnownFormats().iterator();
        while (it2.hasNext()) {
            help.append("      ").append(((String)it2.next()).toLowerCase()).append('\n');
        }
        return help.toString();
    }

    public String[] getSpecificOptions() {
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("[-ifmt <in-format> [-stream]]");
        opts.add("<in-table>");
        opts.add("<mode-flags>");
        opts.add("[<filter-flags>]");
        return opts.toArray(new String[0]);
    }

    public static void main(String[] args) {
        if (!new TablePipe().run(args)) {
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$ttools$TablePipe == null ? (class$uk$ac$starlink$ttools$TablePipe = TablePipe.class$("uk.ac.starlink.ttools.TablePipe")) : class$uk$ac$starlink$ttools$TablePipe).desiredAssertionStatus();
        MODE_NAMES = new String[]{(class$uk$ac$starlink$ttools$CopyMode == null ? (class$uk$ac$starlink$ttools$CopyMode = TablePipe.class$("uk.ac.starlink.ttools.CopyMode")) : class$uk$ac$starlink$ttools$CopyMode).getName(), (class$uk$ac$starlink$ttools$JdbcMode == null ? (class$uk$ac$starlink$ttools$JdbcMode = TablePipe.class$("uk.ac.starlink.ttools.JdbcMode")) : class$uk$ac$starlink$ttools$JdbcMode).getName(), (class$uk$ac$starlink$ttools$MetadataMode == null ? (class$uk$ac$starlink$ttools$MetadataMode = TablePipe.class$("uk.ac.starlink.ttools.MetadataMode")) : class$uk$ac$starlink$ttools$MetadataMode).getName(), (class$uk$ac$starlink$ttools$StatsMode == null ? (class$uk$ac$starlink$ttools$StatsMode = TablePipe.class$("uk.ac.starlink.ttools.StatsMode")) : class$uk$ac$starlink$ttools$StatsMode).getName(), (class$uk$ac$starlink$ttools$CountMode == null ? (class$uk$ac$starlink$ttools$CountMode = TablePipe.class$("uk.ac.starlink.ttools.CountMode")) : class$uk$ac$starlink$ttools$CountMode).getName()};
        FILTER_NAMES = new String[]{(class$uk$ac$starlink$ttools$SelectFilter == null ? (class$uk$ac$starlink$ttools$SelectFilter = TablePipe.class$("uk.ac.starlink.ttools.SelectFilter")) : class$uk$ac$starlink$ttools$SelectFilter).getName(), (class$uk$ac$starlink$ttools$ColumnSortFilter == null ? (class$uk$ac$starlink$ttools$ColumnSortFilter = TablePipe.class$("uk.ac.starlink.ttools.ColumnSortFilter")) : class$uk$ac$starlink$ttools$ColumnSortFilter).getName(), (class$uk$ac$starlink$ttools$ExpressionSortFilter == null ? (class$uk$ac$starlink$ttools$ExpressionSortFilter = TablePipe.class$("uk.ac.starlink.ttools.ExpressionSortFilter")) : class$uk$ac$starlink$ttools$ExpressionSortFilter).getName(), (class$uk$ac$starlink$ttools$EveryFilter == null ? (class$uk$ac$starlink$ttools$EveryFilter = TablePipe.class$("uk.ac.starlink.ttools.EveryFilter")) : class$uk$ac$starlink$ttools$EveryFilter).getName(), (class$uk$ac$starlink$ttools$HeadFilter == null ? (class$uk$ac$starlink$ttools$HeadFilter = TablePipe.class$("uk.ac.starlink.ttools.HeadFilter")) : class$uk$ac$starlink$ttools$HeadFilter).getName(), (class$uk$ac$starlink$ttools$TailFilter == null ? (class$uk$ac$starlink$ttools$TailFilter = TablePipe.class$("uk.ac.starlink.ttools.TailFilter")) : class$uk$ac$starlink$ttools$TailFilter).getName(), (class$uk$ac$starlink$ttools$AddColumnFilter == null ? (class$uk$ac$starlink$ttools$AddColumnFilter = TablePipe.class$("uk.ac.starlink.ttools.AddColumnFilter")) : class$uk$ac$starlink$ttools$AddColumnFilter).getName(), (class$uk$ac$starlink$ttools$KeepColumnFilter == null ? (class$uk$ac$starlink$ttools$KeepColumnFilter = TablePipe.class$("uk.ac.starlink.ttools.KeepColumnFilter")) : class$uk$ac$starlink$ttools$KeepColumnFilter).getName(), (class$uk$ac$starlink$ttools$DeleteColumnFilter == null ? (class$uk$ac$starlink$ttools$DeleteColumnFilter = TablePipe.class$("uk.ac.starlink.ttools.DeleteColumnFilter")) : class$uk$ac$starlink$ttools$DeleteColumnFilter).getName(), (class$uk$ac$starlink$ttools$ExplodeFilter == null ? (class$uk$ac$starlink$ttools$ExplodeFilter = TablePipe.class$("uk.ac.starlink.ttools.ExplodeFilter")) : class$uk$ac$starlink$ttools$ExplodeFilter).getName(), (class$uk$ac$starlink$ttools$CacheFilter == null ? (class$uk$ac$starlink$ttools$CacheFilter = TablePipe.class$("uk.ac.starlink.ttools.CacheFilter")) : class$uk$ac$starlink$ttools$CacheFilter).getName(), (class$uk$ac$starlink$ttools$RandomFilter == null ? (class$uk$ac$starlink$ttools$RandomFilter = TablePipe.class$("uk.ac.starlink.ttools.RandomFilter")) : class$uk$ac$starlink$ttools$RandomFilter).getName(), (class$uk$ac$starlink$ttools$SequentialFilter == null ? (class$uk$ac$starlink$ttools$SequentialFilter = TablePipe.class$("uk.ac.starlink.ttools.SequentialFilter")) : class$uk$ac$starlink$ttools$SequentialFilter).getName()};
    }
}

