/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.Loader;

public abstract class TableTask {
    private boolean noAction_;
    private boolean debug_;
    private boolean verbose_;
    private StarTableFactory treader_;

    public TableTask() {
        Loader.loadProperties();
    }

    public abstract String getCommandName();

    public boolean run(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        if (this.setArgs(argList) && argList.isEmpty()) {
            try {
                if (!this.isNoAction()) {
                    this.execute();
                }
                return true;
            }
            catch (IOException e) {
                if (this.debug_) {
                    e.printStackTrace(System.err);
                } else {
                    System.err.println(e.getMessage());
                }
                return false;
            }
        }
        System.err.println(this.getUsage());
        return false;
    }

    public boolean setArgs(List argList) {
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (!arg.startsWith("-") || arg.length() <= 1) continue;
            if (arg.equals("-disk")) {
                it.remove();
                StoragePolicy.setDefaultPolicy(StoragePolicy.PREFER_DISK);
                this.getTableFactory().setStoragePolicy(StoragePolicy.PREFER_DISK);
                continue;
            }
            if (arg.equals("-debug")) {
                it.remove();
                this.debug_ = true;
                continue;
            }
            if (arg.equals("-v") || arg.equals("-verbose")) {
                it.remove();
                this.verbose_ = true;
                continue;
            }
            if (!arg.equals("-h") && !arg.equals("-help")) continue;
            it.remove();
            System.out.println(this.getHelp());
            this.noAction_ = true;
        }
        if (this.verbose_) {
            Logger.getLogger("uk.ac.starlink").setLevel(Level.INFO);
        } else {
            Logger.getLogger("uk.ac.starlink").setLevel(Level.WARNING);
        }
        return true;
    }

    public boolean isVerbose() {
        return this.verbose_;
    }

    public boolean isNoAction() {
        return this.noAction_;
    }

    public abstract void execute() throws IOException;

    public StarTableFactory getTableFactory() {
        if (this.treader_ == null) {
            this.treader_ = new StarTableFactory(false);
        }
        return this.treader_;
    }

    public String getHelp() {
        return this.getUsage();
    }

    public String getUsage() {
        StringBuffer line = new StringBuffer("Usage: " + this.getCommandName());
        String pad = line.toString().replaceAll(".", " ");
        ArrayList<String> uwords = new ArrayList<String>();
        uwords.addAll(Arrays.asList(this.getGenericOptions()));
        uwords.addAll(Arrays.asList(this.getSpecificOptions()));
        StringBuffer ubuf = new StringBuffer();
        Iterator it = uwords.iterator();
        while (it.hasNext()) {
            String word = (String)it.next();
            if (line.length() + word.length() > 75) {
                ubuf.append(line).append("\n");
                line = new StringBuffer(pad);
            }
            line.append(" ").append(word);
        }
        ubuf.append(line);
        return "\n" + ubuf.toString() + "\n";
    }

    public String[] getGenericOptions() {
        return new String[]{"[-disk]", "[-debug]", "[-h[elp]]", "[-v[erbose]]"};
    }

    public abstract String[] getSpecificOptions();
}

