/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.ProcessingFilter;
import uk.ac.starlink.ttools.ProcessingStep;
import uk.ac.starlink.ttools.TailTable;

public class TailFilter
implements ProcessingFilter {
    public String getName() {
        return "tail";
    }

    public String getFilterUsage() {
        return "<nrows>";
    }

    public ProcessingStep createStep(Iterator argIt) {
        if (argIt.hasNext()) {
            long count = Long.parseLong((String)argIt.next());
            if (count < 0L) {
                throw new IllegalArgumentException("Nrows must be >= 0");
            }
            argIt.remove();
            return new TailStep(count);
        }
        return null;
    }

    private static class TailStep
    implements ProcessingStep {
        final long count_;

        TailStep(long count) {
            this.count_ = count;
        }

        public StarTable wrap(StarTable base) {
            return new TailTable(base, this.count_);
        }
    }
}

