/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.filestore.client;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.filestore.client.FileStoreDelegate;
import org.astrogrid.filestore.common.FileStore;
import org.astrogrid.filestore.common.exception.FileStoreException;
import org.astrogrid.filestore.common.exception.FileStoreIdentifierException;
import org.astrogrid.filestore.common.exception.FileStoreNotFoundException;
import org.astrogrid.filestore.common.exception.FileStoreServiceException;
import org.astrogrid.filestore.common.exception.FileStoreTransferException;
import org.astrogrid.filestore.common.file.FileProperty;
import org.astrogrid.filestore.common.transfer.TransferProperties;

public class FileStoreCoreDelegate
implements FileStore,
FileStoreDelegate {
    private static Log log = LogFactory.getLog((Class)FileStoreCoreDelegate.class);
    protected FileStore service;

    public FileStoreCoreDelegate() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"FileStoreCoreDelegate()");
    }

    public String identifier() throws FileStoreServiceException {
        if (null != this.service) {
            try {
                return this.service.identifier();
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public FileProperty[] importString(FileProperty[] properties, String data) throws FileStoreServiceException, FileStoreException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"FileStoreCoreDelegate.importString()");
        log.debug((Object)("  Data : " + data));
        if (null != this.service) {
            try {
                return this.service.importString(properties, data);
            }
            catch (RemoteException ouch) {
                log.debug((Object)"  >>>>");
                log.debug((Object)("  Exception : " + ouch));
                log.debug((Object)("  Type      : " + ouch.getClass()));
                log.debug((Object)("  Cause     : " + ouch.getCause()));
                log.debug((Object)"  >>>>");
                this.serviceException(ouch);
                this.filestoreException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public FileProperty[] importBytes(FileProperty[] properties, byte[] data) throws FileStoreServiceException, FileStoreException {
        if (null != this.service) {
            try {
                return this.service.importBytes(properties, data);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.filestoreException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public FileProperty[] appendString(String ident, String data) throws FileStoreServiceException, FileStoreIdentifierException, FileStoreNotFoundException, FileStoreException {
        if (null != this.service) {
            try {
                return this.service.appendString(ident, data);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.notfoundException(ouch);
                this.filestoreException(ouch);
                this.identifierException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public FileProperty[] appendBytes(String ident, byte[] data) throws FileStoreServiceException, FileStoreIdentifierException, FileStoreNotFoundException, FileStoreException {
        if (null != this.service) {
            try {
                return this.service.appendBytes(ident, data);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.notfoundException(ouch);
                this.filestoreException(ouch);
                this.identifierException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public String exportString(String ident) throws FileStoreServiceException, FileStoreIdentifierException, FileStoreNotFoundException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"FileStoreCoreDelegate.exportString()");
        log.debug((Object)("  Ident : " + ident));
        if (null != this.service) {
            try {
                return this.service.exportString(ident);
            }
            catch (RemoteException ouch) {
                log.debug((Object)"  ---- catch ----");
                log.debug((Object)("  Exception : " + ouch.getClass()));
                this.serviceException(ouch);
                this.notfoundException(ouch);
                this.identifierException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public byte[] exportBytes(String ident) throws FileStoreServiceException, FileStoreIdentifierException, FileStoreNotFoundException {
        if (null != this.service) {
            try {
                return this.service.exportBytes(ident);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.notfoundException(ouch);
                this.identifierException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public FileProperty[] duplicate(String ident, FileProperty[] properties) throws FileStoreServiceException, FileStoreIdentifierException, FileStoreNotFoundException, FileStoreTransferException {
        if (null != this.service) {
            try {
                return this.service.duplicate(ident, properties);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.notfoundException(ouch);
                this.transferException(ouch);
                this.identifierException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public FileProperty[] delete(String ident) throws FileStoreServiceException, FileStoreIdentifierException, FileStoreNotFoundException {
        if (null != this.service) {
            try {
                return this.service.delete(ident);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.notfoundException(ouch);
                this.identifierException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public FileProperty[] properties(String ident) throws FileStoreServiceException, FileStoreIdentifierException, FileStoreNotFoundException {
        if (null != this.service) {
            try {
                return this.service.properties(ident);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.notfoundException(ouch);
                this.identifierException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public TransferProperties importInit(TransferProperties transfer) throws FileStoreServiceException {
        if (null != this.service) {
            try {
                return this.service.importInit(transfer);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public TransferProperties importData(TransferProperties transfer) throws FileStoreTransferException, FileStoreServiceException {
        if (null != this.service) {
            try {
                return this.service.importData(transfer);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.transferException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public TransferProperties exportInit(TransferProperties transfer) throws FileStoreServiceException {
        if (null != this.service) {
            try {
                return this.service.exportInit(transfer);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public TransferProperties exportData(TransferProperties transfer) throws FileStoreServiceException {
        if (null != this.service) {
            try {
                return this.service.exportData(transfer);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new FileStoreServiceException("Service not initialised");
    }

    public void filestoreException(RemoteException ouch) throws FileStoreException {
        log.debug((Object)"----");
        log.debug((Object)"FileStoreCoreDelegate.filestoreException");
        log.debug((Object)("  Exception : " + ouch));
        log.debug((Object)("  Type      : " + ouch.getClass()));
        log.debug((Object)("  Cause     : " + ouch.getCause()));
        if (ouch.getCause() != null) {
            log.debug((Object)"  Got cause");
            if (ouch.getCause() instanceof FileStoreException) {
                throw (FileStoreException)ouch.getCause();
            }
        } else {
            log.debug((Object)"  Null cause");
            String message = ouch.getMessage();
            String template = FileStoreException.class.getName() + ": ";
            log.debug((Object)("  Message  : '" + message + "'"));
            log.debug((Object)("  Template : '" + template + "'"));
            if (null != message && message.startsWith(template)) {
                log.debug((Object)"  Matches template");
                throw new FileStoreException(message.substring(template.length()));
            }
        }
        log.debug((Object)"  Not handled");
    }

    public void notfoundException(RemoteException ouch) throws FileStoreNotFoundException {
        log.debug((Object)"----");
        log.debug((Object)"FileStoreCoreDelegate.notfoundException");
        log.debug((Object)("  Exception : " + ouch));
        log.debug((Object)("  Type      : " + ouch.getClass()));
        log.debug((Object)("  Cause     : " + ouch.getCause()));
        if (ouch.getCause() != null) {
            log.debug((Object)"  Got cause");
            if (ouch.getCause() instanceof FileStoreNotFoundException) {
                throw (FileStoreNotFoundException)ouch.getCause();
            }
        } else {
            log.debug((Object)"  Null cause");
            String message = ouch.getMessage();
            String template = FileStoreNotFoundException.class.getName() + ": ";
            log.debug((Object)("  Message  : '" + message + "'"));
            log.debug((Object)("  Template : '" + template + "'"));
            if (null != message && message.startsWith(template)) {
                log.debug((Object)"  Matches template");
                throw new FileStoreNotFoundException(message.substring(template.length()));
            }
        }
        log.debug((Object)"  Not handled");
    }

    public void identifierException(RemoteException ouch) throws FileStoreIdentifierException {
        log.debug((Object)"----");
        log.debug((Object)"FileStoreCoreDelegate.identifierException");
        log.debug((Object)("  Exception : " + ouch));
        log.debug((Object)("  Type      : " + ouch.getClass()));
        log.debug((Object)("  Cause     : " + ouch.getCause()));
        if (ouch.getCause() != null) {
            log.debug((Object)"  Got cause");
            if (ouch.getCause() instanceof FileStoreIdentifierException) {
                throw (FileStoreIdentifierException)ouch.getCause();
            }
        } else {
            log.debug((Object)"  Null cause");
            String message = ouch.getMessage();
            String template = FileStoreIdentifierException.class.getName() + ": ";
            log.debug((Object)("  Message  : '" + message + "'"));
            log.debug((Object)("  Template : '" + template + "'"));
            if (null != message && message.startsWith(template)) {
                log.debug((Object)"  Matches template");
                throw new FileStoreIdentifierException(message.substring(template.length()));
            }
        }
        log.debug((Object)"  Not handled");
    }

    public void serviceException(RemoteException ouch) throws FileStoreServiceException {
        log.debug((Object)"----");
        log.debug((Object)"FileStoreCoreDelegate.serviceException");
        log.debug((Object)("  Exception : " + ouch));
        log.debug((Object)("  Type      : " + ouch.getClass()));
        log.debug((Object)("  Cause     : " + ouch.getCause()));
        if (ouch.getCause() != null) {
            log.debug((Object)"  Got cause");
            if (ouch.getCause() instanceof FileStoreServiceException) {
                throw (FileStoreServiceException)ouch.getCause();
            }
        } else {
            log.debug((Object)"  Null cause");
            String message = ouch.getMessage();
            String template = FileStoreServiceException.class.getName() + ": ";
            log.debug((Object)("  Message  : '" + message + "'"));
            log.debug((Object)("  Template : '" + template + "'"));
            if (null != message && message.startsWith(template)) {
                log.debug((Object)"  Matches template");
                throw new FileStoreServiceException(message.substring(template.length()));
            }
        }
        log.debug((Object)"  Not handled");
    }

    public void throwIdentifierException() throws FileStoreIdentifierException, FileStoreServiceException {
        if (null != this.service) {
            try {
                this.service.throwIdentifierException();
            }
            catch (RemoteException ouch) {
                this.identifierException(ouch);
                throw new FileStoreServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        } else {
            throw new FileStoreServiceException("Service not initialised");
        }
    }

    public void transferException(RemoteException ouch) throws FileStoreTransferException {
        log.debug((Object)"----");
        log.debug((Object)"FileStoreCoreDelegate.transferException");
        log.debug((Object)("  Exception : " + ouch));
        log.debug((Object)("  Type      : " + ouch.getClass()));
        log.debug((Object)("  Cause     : " + ouch.getCause()));
        if (ouch.getCause() != null) {
            log.debug((Object)"  Got cause");
            if (ouch.getCause() instanceof FileStoreTransferException) {
                throw (FileStoreTransferException)ouch.getCause();
            }
        } else {
            log.debug((Object)"  Null cause");
            String message = ouch.getMessage();
            String template = FileStoreTransferException.class.getName() + ": ";
            log.debug((Object)("  Message  : '" + message + "'"));
            log.debug((Object)("  Template : '" + template + "'"));
            if (null != message && message.startsWith(template)) {
                log.debug((Object)"  Matches template");
                throw new FileStoreTransferException(message.substring(template.length()));
            }
        }
        log.debug((Object)"  Not handled");
    }
}

