/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.filestore.resolver;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.filestore.client.FileStoreDelegate;
import org.astrogrid.filestore.client.FileStoreMockDelegate;
import org.astrogrid.filestore.client.FileStoreSoapDelegate;
import org.astrogrid.filestore.common.exception.FileStoreIdentifierException;
import org.astrogrid.filestore.common.ivorn.FileStoreIvornParser;
import org.astrogrid.filestore.resolver.FileStoreEndpointResolver;
import org.astrogrid.filestore.resolver.FileStoreResolverException;
import org.astrogrid.registry.client.query.RegistryService;
import org.astrogrid.store.Ivorn;

public class FileStoreDelegateResolver {
    private static Log log = LogFactory.getLog((Class)FileStoreDelegateResolver.class);
    private FileStoreEndpointResolver resolver;

    public FileStoreDelegateResolver() {
        this.resolver = new FileStoreEndpointResolver();
    }

    public FileStoreDelegateResolver(URL registry) {
        this.resolver = new FileStoreEndpointResolver(registry);
    }

    public FileStoreDelegateResolver(RegistryService registry) {
        this.resolver = new FileStoreEndpointResolver(registry);
    }

    public FileStoreDelegate resolve(Ivorn ivorn) throws FileStoreIdentifierException, FileStoreResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"FileStoreDelegateResolver.resolve()");
        log.debug((Object)("  Ivorn : " + ivorn));
        FileStoreIvornParser parser = new FileStoreIvornParser(ivorn);
        if (parser.isMock()) {
            return new FileStoreMockDelegate();
        }
        return new FileStoreSoapDelegate(this.resolver.resolve(ivorn));
    }
}

