/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.filestore.resolver;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.filestore.common.exception.FileStoreIdentifierException;
import org.astrogrid.filestore.common.ivorn.FileStoreIvornParser;
import org.astrogrid.filestore.resolver.FileStoreResolverException;
import org.astrogrid.registry.client.RegistryDelegateFactory;
import org.astrogrid.registry.client.query.RegistryService;
import org.astrogrid.store.Ivorn;

public class FileStoreEndpointResolver {
    private static Log log = LogFactory.getLog((Class)FileStoreEndpointResolver.class);
    private RegistryService registry;

    public FileStoreEndpointResolver() {
        this((URL)null);
    }

    public FileStoreEndpointResolver(URL registry) {
        this(registry, new RegistryDelegateFactory());
    }

    public FileStoreEndpointResolver(URL registry, RegistryDelegateFactory factory) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"FileStoreEndpointResolver()");
        log.debug((Object)("  Registry : " + registry));
        if (null == factory) {
            throw new IllegalArgumentException("Null registry delegate factory");
        }
        this.registry = null == registry ? factory.createQuery() : RegistryDelegateFactory.createQuery((URL)registry);
    }

    public FileStoreEndpointResolver(RegistryService registry) {
        if (null == registry) {
            throw new IllegalArgumentException("Null registry delegate");
        }
        this.registry = registry;
    }

    public URL resolve(Ivorn ivorn) throws FileStoreIdentifierException, FileStoreResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"FileStoreEndpointResolver.resolve()");
        log.debug((Object)("  Ivorn : " + ivorn));
        if (null == ivorn) {
            throw new FileStoreIdentifierException("Null identifier");
        }
        return this.resolve(new FileStoreIvornParser(ivorn));
    }

    public URL resolve(FileStoreIvornParser parser) throws FileStoreIdentifierException, FileStoreResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"FileStoreEndpointResolver.resolve()");
        log.debug((Object)("  Ivorn : " + (null != parser ? parser.getIvorn() : null)));
        if (null == parser) {
            throw new FileStoreIdentifierException("Null identifier");
        }
        if (null == parser.getServiceIdent()) {
            throw new FileStoreIdentifierException("Null community identifier");
        }
        Ivorn ivorn = parser.getServiceIvorn();
        String endpoint = null;
        try {
            endpoint = this.registry.getEndPointByIdentifier(ivorn);
        }
        catch (Throwable ouch) {
            log.debug((Object)"FAIL : Registry lookup failed");
            log.debug((Object)("  Exception : " + ouch));
            throw new FileStoreResolverException("Registry lookup failed", ouch);
        }
        if (null != endpoint) {
            log.debug((Object)"PASS : Got service endpoint");
            log.debug((Object)("  Endpoint : " + endpoint));
            try {
                return new URL(endpoint);
            }
            catch (MalformedURLException ouch) {
                throw new FileStoreResolverException("Unable to parse Registry response into endpoint URL", ivorn);
            }
        }
        throw new FileStoreResolverException("Registry returned null endpoint address for ivorn", ivorn);
    }
}

