/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.astrocat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.FieldDesc;
import jsky.catalog.MemoryCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.coords.CoordinateRadius;
import jsky.coords.WorldCoords;

public class AstroCatTable
extends MemoryCatalog {
    public AstroCatTable(AstroCatalog catalog, InputStream in, int maxRows) throws IOException {
        super((Catalog)catalog, in, maxRows);
    }

    public AstroCatTable(AstroCatalog catalog, InputStream in, QueryArgs queryArgs) throws IOException {
        super((Catalog)catalog, in, queryArgs);
    }

    public AstroCatTable(AstroCatalog catalog, InputStream in) throws IOException {
        super((Catalog)catalog, in);
    }

    public AstroCatTable(AstroCatalog catalog, String filename) throws IOException {
        super((Catalog)catalog, filename);
    }

    public AstroCatTable(String filename) throws IOException {
        super((Catalog)null, filename);
    }

    private AstroCatTable(AstroCatTable table, FieldDesc[] fields, Vector dataRows) {
        super(table, fields, dataRows);
    }

    protected AstroCatTable() {
    }

    public Catalog getCatalog() {
        Catalog catalog = super.getCatalog();
        if (catalog != null) {
            return catalog;
        }
        String filename = this.getFilename();
        if (filename == null) {
            filename = "unknown";
        }
        File file = new File(filename);
        String name = file.getName();
        AstroCatalog cat = new AstroCatalog();
        cat.setType("local");
        cat.setName(name);
        cat.setId(name);
        cat.setProtocol("file");
        cat.setHost("localhost");
        cat.setURLPath(file.getPath());
        return cat;
    }

    protected MemoryCatalog makeQueryResult(FieldDesc[] fields, Vector dataRows) {
        AstroCatTable table = new AstroCatTable(this, fields, dataRows);
        table.setProperties(this.getProperties());
        return table;
    }

    public static void main(String[] args) {
        block9: {
            if (args.length != 1) {
                System.out.println("usage: java -classpath ... AstroCatTable filename");
                System.exit(1);
            }
            AstroCatTable cat = null;
            try {
                cat = new AstroCatTable(args[0]);
                cat.saveAs(System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            System.out.println("");
            System.out.println("test row,col access:");
            System.out.println("table(0,0) = " + cat.getValueAt(0, 0));
            System.out.println("table(3,4) = " + cat.getValueAt(3, 4));
            System.out.println("table(3, ra) = " + cat.getValueAt(3, "ra"));
            System.out.println("table(3, RA) = " + cat.getValueAt(3, "RA"));
            System.out.println("table(3, dec) = " + cat.getValueAt(3, "dec"));
            System.out.println("table(3, Dec) = " + cat.getValueAt(3, "Dec"));
            try {
                AstroCatTable table;
                System.out.println("");
                System.out.println("test query: of GSC0285601186");
                BasicQueryArgs q = new BasicQueryArgs(cat);
                q.setId("GSC0285601186");
                QueryResult r = cat.query(q);
                if (r instanceof AstroCatTable) {
                    table = (AstroCatTable)r;
                    System.out.println("Number of result rows: " + table.getRowCount());
                    if (table.getRowCount() != 0) {
                        System.out.println("result: " + ((AstroCatTable)r).toString());
                    }
                } else {
                    System.out.println("Failed search by ID");
                }
                System.out.println("");
                System.out.println("test query: at center position/radius: ");
                q = new BasicQueryArgs(cat);
                q.setRegion(new CoordinateRadius(new WorldCoords("03:19:44.44", "+41:30:58.21"), 1.0));
                r = cat.query(q);
                if (r instanceof AstroCatTable) {
                    table = (AstroCatTable)r;
                    System.out.println("Number of result rows: " + table.getRowCount());
                    if (table.getRowCount() == 0) break block9;
                    System.out.println("result: " + ((AstroCatTable)r).toString());
                    break block9;
                }
                System.out.println("Failed search by position");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

