/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldFormat;
import jsky.catalog.QueryArgs;
import jsky.catalog.TableQueryResult;
import jsky.util.gui.GridBagUtil;

public class CatalogQueryPanel
extends JPanel
implements ActionListener {
    protected static final Insets LABEL_INSETS = new Insets(6, 11, 0, 0);
    protected static final Insets VALUE_INSETS = new Insets(6, 11, 0, 3);
    private Catalog _catalog;
    private JLabel[] _labels;
    private JComponent[] _components;
    private EventListenerList _actionListenerList = new EventListenerList();
    private EventListenerList _changeListenerList = new EventListenerList();
    private NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private GridBagUtil _layout = new GridBagUtil(this);
    private int _numCols;
    private static final Dimension MIN_COMPONENT_SIZE = new Dimension(80, 21);
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public CatalogQueryPanel(Catalog catalog, int numCols) {
        this._catalog = catalog;
        this._numCols = numCols;
        this.nf.setGroupingUsed(false);
        this.makePanelItems();
        this.doGridBagLayout(this._layout);
    }

    public CatalogQueryPanel(Catalog catalog) {
        this(catalog, 2);
    }

    protected CatalogQueryPanel(Catalog catalog, int numCols, boolean doLayout) {
        this._catalog = catalog;
        this._numCols = numCols;
        this.nf.setGroupingUsed(false);
        if (doLayout) {
            this.makePanelItems();
            this.doGridBagLayout(this._layout);
        }
    }

    protected int getNumCols() {
        return this._numCols;
    }

    public void update() {
        QueryArgs queryArgs = this.getQueryArgs();
        this.removePanelItems();
        this.makePanelItems();
        this.doGridBagLayout(this._layout);
        this.setQueryArgs(queryArgs);
        this.revalidate();
        this.repaint();
    }

    public void addActionListener(ActionListener l) {
        this._actionListenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = CatalogQueryPanel.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this._actionListenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = CatalogQueryPanel.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    protected void fireActionEvent() {
        Object[] listeners = this._actionListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$java$awt$event$ActionListener == null ? CatalogQueryPanel.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                ((ActionListener)listeners[i + 1]).actionPerformed(new ActionEvent(this, 0, null));
            }
            i -= 2;
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.fireActionEvent();
    }

    public void addChangeListener(ChangeListener l) {
        this._changeListenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CatalogQueryPanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._changeListenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CatalogQueryPanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    protected void fireChange(JComboBox cb) {
        Object[] listeners = this._changeListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$ChangeListener == null ? CatalogQueryPanel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ((ChangeListener)listeners[i + 1]).stateChanged(new ChangeEvent(cb));
            }
            i -= 2;
        }
    }

    protected JLabel makeLabel(String s) {
        if (s == null) {
            return null;
        }
        JLabel label = new JLabel(s, 2);
        return label;
    }

    public Catalog getCatalog() {
        return this._catalog;
    }

    protected JComponent makeComponent(FieldDesc p) {
        Object o;
        if (p.getNumOptions() > 0) {
            return this.makeComboBox(p);
        }
        JTextField tf = this.makeTextField(10);
        String s = p.getDescription();
        if (s != null) {
            tf.setToolTipText(s);
        }
        if ((o = p.getDefaultValue()) != null) {
            tf.setText(o.toString());
        }
        return tf;
    }

    protected JTextField makeTextField(int width) {
        JTextField tf = new JTextField(width);
        tf.addActionListener(this);
        return tf;
    }

    protected JCheckBox makeCheckBox() {
        JCheckBox cb = new JCheckBox();
        return cb;
    }

    protected JComboBox makeComboBox(FieldDesc p) {
        int def;
        int n = p.getNumOptions();
        final JComboBox<String> cb = new JComboBox<String>();
        String s = p.getDescription();
        if (s != null) {
            cb.setToolTipText(s);
        }
        if ((def = p.getDefaultOptionIndex()) == -1) {
            cb.addItem("");
        }
        int i = 0;
        while (i < n) {
            cb.addItem(p.getOptionName(i));
            ++i;
        }
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CatalogQueryPanel.this.fireChange(cb);
            }
        });
        cb.setPreferredSize(MIN_COMPONENT_SIZE);
        return cb;
    }

    protected void makePanelItems() {
        int n = this._catalog.getNumParams();
        if (n > 0) {
            this._labels = new JLabel[n];
            this._components = new JComponent[n];
            int i = 0;
            while (i < n) {
                FieldDesc p = this._catalog.getParamDesc(i);
                if (p == null || "hidden".equals(p.getType())) {
                    this._labels[i] = null;
                    this._components[i] = null;
                } else {
                    String s = p.getName();
                    if (s == null) {
                        s = "Field" + (i + 1);
                    }
                    this._labels[i] = this.makeLabel(s);
                    this._components[i] = this.makeComponent(p);
                }
                ++i;
            }
        }
    }

    protected void removePanelItems() {
        int i = 0;
        while (i < this._labels.length) {
            if (this._labels[i] != null) {
                this.remove(this._labels[i]);
            }
            if (this._components[i] != null) {
                this.remove(this._components[i]);
            }
            ++i;
        }
    }

    public String getLabelForComponent(JComponent c) {
        int i = 0;
        while (i < this._labels.length) {
            if (this._components[i] == c) {
                return this._labels[i].getText();
            }
            ++i;
        }
        return null;
    }

    public JComponent getComponentForLabel(String s) {
        int i = 0;
        while (i < this._labels.length) {
            if (this._labels[i].getText().equals(s)) {
                return this._components[i];
            }
            ++i;
        }
        return null;
    }

    protected int doGridBagLayout(GridBagUtil layout) {
        String desc;
        int row = 0;
        int col = 0;
        int n = this._catalog.getNumParams();
        int i = 0;
        while (i < n) {
            if (this._labels[i] != null || this._components[i] != null) {
                if (this._labels[i] != null) {
                    layout.add(this._labels[i], col, row, 1, 1, 0.0, 0.0, 0, 18, LABEL_INSETS);
                }
                ++col;
                if (this._components[i] != null) {
                    layout.add(this._components[i], col, row, 1, 1, 1.0, 0.0, 2, 18, VALUE_INSETS);
                }
                if (++col >= this._numCols) {
                    col = 0;
                    ++row;
                }
            }
            ++i;
        }
        if (col != 0) {
            col = 0;
            ++row;
        }
        if ((desc = this._catalog.getDescription()) != null) {
            JLabel label = new JLabel(desc);
            layout.add(label, col, row, this._numCols, 1, 1.0, 0.0, 2, 17, LABEL_INSETS);
            ++row;
        }
        return row;
    }

    public void initQueryArgs(QueryArgs queryArgs) {
        int n = Math.min(this._components.length, this._catalog.getNumParams());
        int i = 0;
        while (i < n) {
            if (this._components[i] != null) {
                queryArgs.setParamValue(i, this.getValue(i));
            }
            ++i;
        }
    }

    public QueryArgs getQueryArgs() {
        BasicQueryArgs queryArgs = new BasicQueryArgs(this._catalog);
        this.initQueryArgs(queryArgs);
        return queryArgs;
    }

    public void setQueryArgs(QueryArgs queryArgs) {
        int n = Math.min(this._components.length, this._catalog.getNumParams());
        int i = 0;
        while (i < n) {
            Object value = queryArgs.getParamValue(i);
            if (value != null) {
                this.setValue(i, value);
            }
            ++i;
        }
    }

    protected Object getValue(FieldDesc p, JComponent c) {
        if (p.getNumOptions() > 0) {
            JComboBox cb = (JComboBox)c;
            String s = (String)cb.getSelectedItem();
            if (s != null && s.length() != 0) {
                int n = p.getNumOptions();
                int j = 0;
                while (j < n) {
                    if (p.getOptionName(j).equals(s)) {
                        return p.getOptionValue(j);
                    }
                    ++j;
                }
            }
            return null;
        }
        String s = ((JTextField)c).getText();
        if (s == null || s.length() == 0) {
            return null;
        }
        if (this._catalog instanceof TableQueryResult) {
            return FieldFormat.getValueRange(p, s);
        }
        return FieldFormat.getValue(p, s);
    }

    protected Object getValue(int i) {
        return this.getValue(this._catalog.getParamDesc(i), this._components[i]);
    }

    protected void setValue(int i, Object value) {
        JComponent c = this._components[i];
        if (c instanceof JTextField) {
            String s = value instanceof Double ? this.nf.format((Double)value) : value.toString();
            ((JTextField)c).setText(s);
        } else if (c instanceof JComboBox) {
            ((JComboBox)c).setSelectedItem(value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

