/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jsky.catalog.Catalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.gui.CatalogQueryPanel;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.util.I18N;
import jsky.util.Interruptable;
import jsky.util.SwingWorker;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.GridBagUtil;
import jsky.util.gui.ProgressException;

public class CatalogQueryTool
extends JPanel
implements ActionListener,
Interruptable {
    private static final I18N _I18N = I18N.getInstance(class$jsky$catalog$gui$CatalogQueryTool == null ? (class$jsky$catalog$gui$CatalogQueryTool = CatalogQueryTool.class$("jsky.catalog.gui.CatalogQueryTool")) : class$jsky$catalog$gui$CatalogQueryTool);
    private Catalog _catalog;
    private JLabel _catalogTitleLabel;
    private CatalogQueryPanel _catalogQueryPanel;
    private JFileChooser _fileChooser;
    private QueryResultDisplay _queryResultDisplay;
    private JScrollPane _scrollPane;
    private SwingWorker _worker;
    static /* synthetic */ Class class$jsky$catalog$gui$CatalogQueryTool;

    public CatalogQueryTool(Catalog catalog) {
        this._catalog = catalog;
        this._catalogTitleLabel = this.makeCatalogPanelLabel(catalog);
        this._catalogQueryPanel = this.makeCatalogQueryPanel(catalog);
        this._catalogQueryPanel.addActionListener(this);
        this._scrollPane = new JScrollPane(this._catalogQueryPanel);
        GridBagUtil layout = new GridBagUtil(this);
        layout.add(this._catalogTitleLabel, 0, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(3, 0, 3, 0));
        layout.add(this._scrollPane, 0, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
        layout.add(this.makeButtonPanel(), 0, 2, 1, 1, 0.0, 0.0, 2, 10, new Insets(5, 0, 0, 5));
    }

    public CatalogQueryTool(Catalog catalog, QueryResultDisplay queryResultDisplay) {
        this(catalog);
        this._queryResultDisplay = queryResultDisplay;
    }

    protected JLabel makeCatalogPanelLabel(Catalog catalog) {
        String title = catalog.toString();
        this.setName(title);
        return new JLabel(title, 0);
    }

    protected CatalogQueryPanel makeCatalogQueryPanel(Catalog catalog) {
        return new CatalogQueryPanel(catalog, 2);
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton goButton = new JButton(_I18N.getString("query"));
        goButton.setToolTipText(_I18N.getString("startQuery"));
        goButton.addActionListener(this);
        buttonPanel.add(goButton);
        return buttonPanel;
    }

    public void setQueryResultDisplay(QueryResultDisplay q) {
        this._queryResultDisplay = q;
    }

    public QueryResultDisplay getQueryResultDisplay() {
        return this._queryResultDisplay;
    }

    public void interrupt() {
        if (this._worker != null) {
            this._worker.interrupt();
        }
        this._worker = null;
    }

    public String getName() {
        if (this._catalog != null) {
            return this._catalog.getName();
        }
        return _I18N.getString("catalog");
    }

    public Catalog getCatalog() {
        return this._catalog;
    }

    public CatalogQueryPanel getCatalogQueryPanel() {
        return this._catalogQueryPanel;
    }

    public void actionPerformed(ActionEvent ev) {
        this.search();
    }

    public void search() {
        if (this._queryResultDisplay == null) {
            return;
        }
        this._worker = new SwingWorker(){

            public Object construct() {
                try {
                    QueryArgs queryArgs = CatalogQueryTool.this._catalogQueryPanel.getQueryArgs();
                    QueryResult queryResult = CatalogQueryTool.this._catalog.query(queryArgs);
                    return queryResult;
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                CatalogQueryTool.this._worker = null;
                Object o = this.getValue();
                if (o instanceof ProgressException) {
                    return;
                }
                if (o instanceof Exception) {
                    DialogUtil.error((Exception)o);
                    return;
                }
                CatalogQueryTool.this._queryResultDisplay.setQueryResult((QueryResult)o);
            }
        };
        this._worker.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

