/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.irsa;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import jsky.catalog.AbstractCatalogDirectory;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.irsa.IRSAXML;
import jsky.util.FileUtil;
import jsky.util.Resources;
import jsky.util.StringUtil;
import jsky.util.gui.DialogUtil;

public class IRSAConfig
extends AbstractCatalogDirectory {
    private static IRSAConfig _configFile;
    private static URL _defaultURL;

    public IRSAConfig(String name, URL url) {
        super(name);
        this.setURL(url);
        this._load();
    }

    public IRSAConfig(String name, String configFileOrURL) {
        this(name, FileUtil.makeURL(null, configFileOrURL));
    }

    public IRSAConfig(String configFileOrURL) {
        this(configFileOrURL, FileUtil.makeURL(null, configFileOrURL));
    }

    public IRSAConfig(URL url, HTMLQueryResultHandler handler) {
        super(new File(url.toString()).getPath());
        this.setURL(url);
        this.setHTMLQueryResultHandler(handler);
        this._load();
    }

    private void _load() {
        URL url = this.getURL();
        if (url == null) {
            return;
        }
        IRSAXML irsaXML = new IRSAXML();
        irsaXML.parse(url);
        this.setCatalogs(irsaXML.getCatalogs());
    }

    public static CatalogDirectory getDirectory() {
        return IRSAConfig.getConfigFile();
    }

    public static IRSAConfig getConfigFile() {
        if (_configFile != null) {
            return _configFile;
        }
        String[] urls = new String[4];
        int index = 0;
        String urlStr = System.getProperty("jsky.catalog.irsa.config");
        if (urlStr != null && urlStr.length() != 0) {
            urls[index++] = urlStr;
        }
        String home = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        String filename = home + sep + ".jsky" + sep + "irsa" + sep + "nph-catlist.xml";
        if (new File(filename).exists()) {
            urlStr = "file:" + filename;
            if (!sep.equals("/")) {
                urlStr = StringUtil.replace(urlStr, sep, "/");
            }
            urls[index++] = urlStr;
        }
        if (_defaultURL == null) {
            _defaultURL = Resources.getResource("conf/nph-catlist.xml");
        }
        if (_defaultURL == null) {
            throw new RuntimeException("Can't find the default catalog config file resource (nph-catlist.xml).");
        }
        urls[index++] = _defaultURL.toString();
        _configFile = new IRSAConfig(urls[0]);
        int i = 1;
        while (i < index) {
            if (urls[i] != null) {
                _configFile.addCatalogDirectory(urls[i]);
            }
            ++i;
        }
        return _configFile;
    }

    public CatalogDirectory reload() {
        _configFile = null;
        IRSAConfig.getConfigFile();
        return _configFile;
    }

    public CatalogDirectory loadSubDir(URL url) {
        String filename = url.getFile();
        IRSAConfig cf = new IRSAConfig(url, this.getHTMLQueryResultHandler());
        return cf;
    }

    public static void setConfigFile(URL url) {
        _defaultURL = url;
    }

    public void addCatalogDirectory(String urlStr) {
        if (this.getCatalog(urlStr) != null) {
            return;
        }
        IRSAConfig catDir = new IRSAConfig(urlStr);
        this.addCatalog(catDir);
    }

    public void save() {
        String home = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        String filename = home + sep + ".jsky" + sep + "irsa" + sep;
        try {
            this.save(filename);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    public void save(String dirName) throws IOException {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        IRSAXML irsaXML = new IRSAXML();
        irsaXML.save(dir, this.getCatalogs());
    }

    public static void main(String[] args) {
        String catalogName;
        IRSAConfig configFile = IRSAConfig.getConfigFile();
        Catalog cat = configFile.getCatalog(catalogName = "2MASS Second Incremental Release Point Source Catalog (PSC)");
        if (cat == null) {
            System.out.println("Can't find entry for catalog: " + catalogName);
            System.exit(1);
        } else {
            System.out.println("Test passed");
        }
    }

    static {
        _defaultURL = null;
    }
}

