/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.irsa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import jsky.catalog.Catalog;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.MemoryCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.RowCoordinates;
import jsky.catalog.irsa.IRSACatalog;
import jsky.util.StringTokenizerUtil;

public class IRSATable
extends MemoryCatalog {
    private Vector _columnTypes;
    private Vector _columnUnits;
    private Vector _columnNulls;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public IRSATable(IRSACatalog catalog, InputStream in, int maxRows) throws IOException {
        super((Catalog)catalog, in, maxRows);
    }

    public IRSATable(IRSACatalog catalog, InputStream in, QueryArgs queryArgs) throws IOException {
        super((Catalog)catalog, in, queryArgs);
    }

    public IRSATable(IRSACatalog catalog, InputStream in) throws IOException {
        super((Catalog)catalog, in);
    }

    public IRSATable(IRSACatalog catalog, String filename) throws IOException {
        super((Catalog)catalog, filename);
    }

    public IRSATable(String filename) throws IOException {
        super(filename);
    }

    private IRSATable(IRSATable table, FieldDesc[] fields, Vector dataRows) {
        super(fields, dataRows);
        this.setName(table.getName());
        this.setId(table.getId());
        this.setTitle("Query Results from: " + table.getTitle());
        this.setColumnClasses(table.getColumnClasses());
    }

    protected IRSATable() {
    }

    public Catalog getCatalog() {
        Catalog catalog = super.getCatalog();
        if (catalog != null) {
            return catalog;
        }
        String filename = this.getFilename();
        if (filename == null) {
            filename = "unknown";
        }
        File file = new File(filename);
        return new IRSACatalog(file, this);
    }

    protected void _init(InputStream in, int maxRows) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("EOF reading table data");
        }
        if (!line.equals("\\fixlen = T")) {
            if (line.equals("ERROR")) {
                String line2 = reader.readLine();
                String line3 = reader.readLine();
                if (line2 != null) {
                    line = line + ", " + line2;
                }
                if (line3 != null) {
                    line = line + ", " + line3;
                }
                throw new IOException(line);
            }
            throw new IOException("Unknown table format: expected first line to be: '\\fixlen = T', not: " + line);
        }
        line = reader.readLine();
        line = reader.readLine();
        int rowsRetreived = Integer.parseInt(line.substring(17).trim());
        if (maxRows > 0 && rowsRetreived > maxRows) {
            rowsRetreived = maxRows;
        }
        line = reader.readLine();
        line = reader.readLine();
        this.setColumnIdentifiers(this._parseHeading(line));
        line = reader.readLine();
        this._columnTypes = this._parseHeading(line);
        this.setColumnClasses(this._getColumnClasses(this._columnTypes));
        line = reader.readLine();
        this._columnUnits = this._parseHeading(line);
        line = reader.readLine();
        this._columnNulls = this._parseHeading(line);
        this._initFields();
        this.dataVector = new Vector(rowsRetreived, 256);
        int nrows = 1;
        while ((line = reader.readLine()) != null) {
            this.dataVector.add(this._parseRow(line));
            if (maxRows <= 0 || nrows++ < maxRows) continue;
            break;
        }
    }

    protected MemoryCatalog makeQueryResult(FieldDesc[] fields, Vector dataRows) {
        IRSATable table = new IRSATable(this, fields, dataRows);
        return table;
    }

    protected Vector _parseHeading(String s) {
        if (s == null || s.length() == 0) {
            throw new RuntimeException("Missing header line in catalog table");
        }
        StringTokenizerUtil st = new StringTokenizerUtil(s.substring(1), "|");
        Vector<String> v = new Vector<String>(st.countTokens(), 1);
        while (st.hasMoreTokens()) {
            v.add(st.nextToken().trim());
        }
        return v;
    }

    protected void _initFields() {
        Vector colNames = this.getColumnIdentifiers();
        int n = colNames.size();
        FieldDesc[] fields = new FieldDescAdapter[n];
        int raCol = -1;
        int decCol = -1;
        double equinox = 2000.0;
        int i = 0;
        while (i < n) {
            String name = (String)colNames.get(i);
            fields[i] = new FieldDescAdapter(name);
            ((FieldDescAdapter)fields[i]).setUnits((String)this._columnUnits.get(i));
            if (name.equalsIgnoreCase("ra")) {
                ((FieldDescAdapter)fields[i]).setIsRA(true);
                raCol = i;
            } else if (name.equalsIgnoreCase("dec")) {
                ((FieldDescAdapter)fields[i]).setIsDec(true);
                decCol = i;
            }
            ++i;
        }
        if (raCol >= 0 && decCol >= 0) {
            this.setRowCoordinates(new RowCoordinates(raCol, decCol, equinox));
        }
        this.setFields(fields);
    }

    protected Vector _parseRow(String lineStr) {
        StringTokenizer st = new StringTokenizer(lineStr, " ");
        int numCols = this.getColumnIdentifiers().size();
        int i = 0;
        Vector<Object> row = new Vector<Object>(numCols, 1);
        while (st.hasMoreTokens()) {
            if (i++ >= numCols) break;
            String s = st.nextToken().trim();
            if (s.length() != 0) {
                Object o = this._parseItem(i - 1, s);
                row.add(o);
                continue;
            }
            row.add(null);
        }
        while (i++ < numCols) {
            row.add(null);
        }
        return row;
    }

    private Vector _getColumnClasses(Vector typeNames) {
        int n = typeNames.size();
        Vector<Class> columnClasses = new Vector<Class>(n);
        int i = 0;
        while (i < n) {
            String type = (String)typeNames.get(i);
            if (type.equals("double")) {
                columnClasses.add(class$java$lang$Double == null ? IRSATable.class$("java.lang.Double") : class$java$lang$Double);
            } else if (type.equals("int")) {
                columnClasses.add(class$java$lang$Integer == null ? IRSATable.class$("java.lang.Integer") : class$java$lang$Integer);
            } else {
                columnClasses.add(class$java$lang$String == null ? IRSATable.class$("java.lang.String") : class$java$lang$String);
            }
            ++i;
        }
        return columnClasses;
    }

    private Object _parseItem(int colIndex, String s) {
        String nullStr = (String)this._columnNulls.get(colIndex);
        if (s == null || s.equals(nullStr)) {
            return null;
        }
        Class c = this.getColumnClass(colIndex);
        try {
            if (c == (class$java$lang$Double == null ? (class$java$lang$Double = IRSATable.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(s);
            }
            if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = IRSATable.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer(s);
            }
        }
        catch (NumberFormatException e) {}
        return s;
    }

    public void saveAsIRSA(String filename) throws IOException {
        this.saveAs(new FileOutputStream(filename));
    }

    public void saveAsIRSA(OutputStream os) {
        int numCols = this.getColumnIdentifiers().size();
        int numRows = this.dataVector.size();
        int n = numCols - 1;
        if (numCols == 0) {
            return;
        }
        String newline = System.getProperty("line.separator");
        PrintStream out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        out.println("\\fixlen = T");
        out.println("\\primary    = 0");
        out.println("\\RowsRetreived =                 " + numRows);
        out.println("\\QueryTime     =   00:00:00.04173");
        out.print("|");
        int col = 0;
        while (col < numCols) {
            out.print(this.getColumnIdentifiers().get(col));
            out.print("|");
            ++col;
        }
        out.print(newline);
        out.print("|");
        int col2 = 0;
        while (col2 < numCols) {
            out.print(this._columnTypes.get(col2));
            out.print("|");
            ++col2;
        }
        out.print(newline);
        out.print("|");
        int col3 = 0;
        while (col3 < numCols) {
            out.print(this._columnUnits.get(col3));
            out.print("|");
            ++col3;
        }
        out.print(newline);
        out.print("|");
        int col4 = 0;
        while (col4 < numCols) {
            out.print(this._columnNulls.get(col4));
            out.print("|");
            ++col4;
        }
        out.print(newline);
        int row = 0;
        while (row < numRows) {
            Vector rowVec = (Vector)this.dataVector.get(row);
            int col5 = 0;
            while (col5 < numCols) {
                out.print(rowVec.get(col5));
                out.print(" ");
                ++col5;
            }
            out.print(newline);
            ++row;
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java -classpath ... IRSATable filename");
            System.exit(1);
        }
        IRSATable cat = null;
        try {
            cat = new IRSATable(args[0]);
            cat.saveAs(System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("");
        System.out.println("test row,col access:");
        System.out.println("table(0,0) = " + cat.getValueAt(0, 0));
        System.out.println("table(3, ra) = " + cat.getValueAt(3, "ra"));
        System.out.println("table(3, RA) = " + cat.getValueAt(3, "RA"));
        System.out.println("table(3, dec) = " + cat.getValueAt(3, "dec"));
        System.out.println("table(3, Dec) = " + cat.getValueAt(3, "Dec"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

