/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

import java.io.Serializable;
import jsky.coords.Coordinates;

public class ImageCoords
implements Coordinates,
Serializable {
    protected double x;
    protected double y;

    public ImageCoords() {
    }

    public ImageCoords(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public ImageCoords(Double x, Double y) {
        this.x = x;
        this.y = y;
    }

    public ImageCoords(String x, String y) {
        this.x = Double.parseDouble(x);
        this.y = Double.parseDouble(y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        return Double.toString(this.x) + " " + Double.toString(this.y);
    }

    public static double dist(double x0, double y0, double x1, double y1) {
        double x = Math.abs(x1 - x0);
        double y = Math.abs(y1 - y0);
        return Math.sqrt(x * x + y * y);
    }

    public double dist(ImageCoords pos) {
        return ImageCoords.dist(this.x, this.y, pos.x, pos.y);
    }

    public double dist(Coordinates pos) {
        return this.dist((ImageCoords)pos);
    }

    public ImageCoords[] box(double radius) {
        ImageCoords[] ar = new ImageCoords[2];
        double w = Math.sqrt(radius * radius / 2.0);
        double x0 = this.x - w;
        double y0 = this.y - w;
        double x1 = this.x + w;
        double y1 = this.y + w;
        ar[0] = new ImageCoords(x0, y0);
        ar[1] = new ImageCoords(x1, y1);
        return ar;
    }

    public double[] center(ImageCoords pos1, ImageCoords pos2) {
        double[] ar = new double[5];
        double x1 = pos1.x;
        double y1 = pos1.y;
        double x2 = pos2.x;
        double y2 = pos2.y;
        ar[0] = (x1 + x2) / 2.0;
        ar[1] = (y1 + y2) / 2.0;
        ar[2] = ImageCoords.dist(x1, y1, x2, y1);
        ar[3] = ImageCoords.dist(x1, y1, x1, y2);
        ar[4] = ImageCoords.dist(x1, y1, x2, y2) / 2.0;
        return ar;
    }

    public String getCoordinateSystemName() {
        return "image";
    }

    public static void main(String[] args) {
        ImageCoords c1 = new ImageCoords(100.0, 200.0);
        ImageCoords c2 = new ImageCoords("100.", "200.");
        System.out.println("these coords should each be the same:");
        System.out.println(c1);
        System.out.println(c2);
        ImageCoords c3 = new ImageCoords(100.0, 100.0);
        ImageCoords[] ar1 = c3.box(10.0);
        ImageCoords c4 = ar1[0];
        ImageCoords c5 = ar1[1];
        System.out.println("box of radius 10 with center at (100, 100):");
        System.out.println(c4);
        System.out.println(c5);
    }
}

