/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

import java.awt.geom.Point2D;
import java.io.Serializable;
import jsky.coords.Coordinates;
import jsky.coords.DMS;
import jsky.coords.HMS;
import jsky.coords.JPrec;
import jsky.coords.WorldCoordinates;

public class WorldCoords
implements WorldCoordinates,
Serializable {
    protected HMS ra;
    protected DMS dec;

    public WorldCoords() {
        this.ra = new HMS();
        this.dec = new DMS();
    }

    public WorldCoords(HMS ra, DMS dec, double equinox) {
        this.ra = ra;
        this.dec = dec;
        this.init(equinox);
    }

    public WorldCoords(HMS ra, DMS dec) {
        this(ra, dec, 2000.0);
    }

    public WorldCoords(double ra, double dec, double equinox) {
        this.ra = new HMS(ra / 15.0);
        this.dec = new DMS(dec);
        this.init(equinox);
    }

    public WorldCoords(Double ra, Double dec, double equinox) {
        this.ra = new HMS(ra / 15.0);
        this.dec = new DMS(dec);
        this.init(equinox);
    }

    public WorldCoords(double ra, double dec) {
        this(ra, dec, 2000.0);
    }

    public WorldCoords(Point2D.Double p, double equinox) {
        this(p.getX(), p.getY(), equinox);
    }

    public WorldCoords(Point2D.Double p) {
        this(p.getX(), p.getY(), 2000.0);
    }

    public WorldCoords(Double ra, Double dec) {
        this((double)ra, (double)dec, 2000.0);
    }

    public WorldCoords(double rh, int rm, double rs, double dd, int dm, double ds, double equinox) {
        this.ra = new HMS(rh, rm, rs);
        this.dec = new DMS(dd, dm, ds);
        this.init(equinox);
    }

    public WorldCoords(double rh, int rm, double rs, double dd, int dm, double ds) {
        this(rh, rm, rs, dd, dm, ds, 2000.0);
    }

    public WorldCoords(String ra, String dec, double equinox) {
        this.ra = new HMS(ra);
        this.dec = new DMS(dec);
        this.init(equinox);
    }

    public WorldCoords(String ra, String dec, double equinox, boolean hflag) {
        this.ra = new HMS(ra, hflag);
        this.dec = new DMS(dec);
        this.init(equinox);
    }

    public WorldCoords(String ra, String dec) {
        this(ra, dec, 2000.0);
    }

    public WorldCoords(String ra, String dec, boolean hflag) {
        this(ra, dec, 2000.0, hflag);
    }

    public HMS getRA() {
        return this.ra;
    }

    public DMS getDec() {
        return this.dec;
    }

    public double getRaDeg() {
        return this.ra.getVal() * 15.0;
    }

    public double getDecDeg() {
        return this.dec.getVal();
    }

    public double getX() {
        return this.ra.getVal() * 15.0;
    }

    public double getY() {
        return this.dec.getVal();
    }

    public String toString() {
        return this.ra.toString() + ", " + this.dec.toString() + " J2000";
    }

    public String[] format(double equinox) {
        String[] ar = new String[2];
        if (equinox == 2000.0) {
            ar[0] = this.ra.toString();
            ar[1] = this.dec.toString();
        } else {
            WorldCoords tmp = new WorldCoords(this.ra, this.dec);
            tmp.convertEquinox(2000.0, equinox);
            ar[0] = tmp.ra.toString();
            ar[1] = tmp.dec.toString();
        }
        return ar;
    }

    public String[] format() {
        return this.format(2000.0);
    }

    public double[] getRaDec(double equinox) {
        double[] ar = new double[2];
        if (equinox == 2000.0) {
            ar[0] = this.getRaDeg();
            ar[1] = this.getDecDeg();
        } else {
            WorldCoords tmp = new WorldCoords(this.ra, this.dec);
            tmp.convertEquinox(2000.0, equinox);
            ar[0] = tmp.getRaDeg();
            ar[1] = tmp.getDecDeg();
        }
        return ar;
    }

    public static double[] dispos(double dra0, double decd0, double dra, double decd) {
        double[] ar = new double[2];
        double radian = 57.29577951308232;
        double alf = dra / radian;
        double alf0 = dra0 / radian;
        double del = decd / radian;
        double del0 = decd0 / radian;
        double sd0 = Math.sin(del0);
        double sd = Math.sin(del);
        double cd0 = Math.cos(del0);
        double cd = Math.cos(del);
        double cosda = Math.cos(alf - alf0);
        double cosd = sd0 * sd + cd0 * cd * cosda;
        double dist = Math.acos(cosd);
        double phi = 0.0;
        if (dist > 4.0E-7) {
            double sind = Math.sin(dist);
            double cospa = (sd * cd0 - cd * sd0 * cosda) / sind;
            if (cospa > 1.0) {
                cospa = 1.0;
            }
            double sinpa = cd * Math.sin(alf - alf0) / sind;
            phi = Math.acos(cospa) * radian;
            if (sinpa < 0.0) {
                phi = 360.0 - phi;
            }
        }
        dist *= radian;
        dist *= 60.0;
        if (decd0 == 90.0) {
            phi = 180.0;
        }
        if (decd0 == -90.0) {
            phi = 0.0;
        }
        ar[0] = dist;
        ar[1] = phi;
        return ar;
    }

    public double[] dispos(WorldCoordinates pos) {
        return WorldCoords.dispos(this.getRaDeg(), this.getDecDeg(), pos.getRaDeg(), pos.getDecDeg());
    }

    public static double wcsdist(double x1, double y1, double x2, double y2) {
        double[] pos1 = new double[3];
        double[] pos2 = new double[3];
        double deg = Math.PI / 180;
        double xr1 = x1 * deg;
        double yr1 = y1 * deg;
        double cosb = Math.cos(yr1);
        pos1[0] = Math.cos(xr1) * cosb;
        pos1[1] = Math.sin(xr1) * cosb;
        pos1[2] = Math.sin(yr1);
        double xr2 = x2 * deg;
        double yr2 = y2 * deg;
        cosb = Math.cos(yr2);
        pos2[0] = Math.cos(xr2) * cosb;
        pos2[1] = Math.sin(xr2) * cosb;
        pos2[2] = Math.sin(yr2);
        double w = 0.0;
        int i = 0;
        while (i < 3) {
            w += (pos1[i] - pos2[i]) * (pos1[i] - pos2[i]);
            ++i;
        }
        if ((w /= 4.0) > 1.0) {
            w = 1.0;
        }
        double diff = 2.0 * Math.atan2(Math.sqrt(w), Math.sqrt(1.0 - w));
        return diff * 180.0 / Math.PI;
    }

    public double dist(WorldCoords pos) {
        double[] ar = WorldCoords.dispos(this.getRaDeg(), this.getDecDeg(), pos.getRaDeg(), pos.getDecDeg());
        return ar[0];
    }

    public double dist(Coordinates pos) {
        return this.dist((WorldCoords)pos);
    }

    public static double dist(double ra0, double dec0, double ra1, double dec1) {
        double[] ar = WorldCoords.dispos(ra0, dec0, ra1, dec1);
        return ar[0];
    }

    public WorldCoordinates[] box(double radius) {
        double r2;
        double r1;
        double d2;
        double width;
        WorldCoordinates[] ar = new WorldCoordinates[2];
        double ra = this.ra.getVal();
        double dec = this.dec.getVal();
        double d1 = dec - (width = Math.sqrt(2.0 * (radius /= 60.0) * radius)) / 2.0;
        if (d1 <= -90.0) {
            d1 = -90.0;
            d2 = dec + width / 2.0;
            r1 = 0.0;
            r2 = 24.0;
        } else {
            d2 = dec + width / 2.0;
            if (d2 >= 90.0) {
                d1 = dec - width / 2.0;
                d2 = 90.0;
                r1 = 0.0;
                r2 = 24.0;
            } else {
                double cosdec = dec > 0.0 ? Math.abs(Math.cos(d1 * Math.PI / 180.0)) : Math.abs(Math.cos(d2 * Math.PI / 180.0));
                r1 = ra - width / 15.0 / 2.0 / cosdec;
                r2 = ra + width / 15.0 / 2.0 / cosdec;
                if (r1 < 0.0) {
                    r1 += 24.0;
                }
                if (r2 > 24.0) {
                    r2 -= 24.0;
                }
            }
        }
        ar[0] = new WorldCoords(r1 * 15.0, d1);
        ar[1] = new WorldCoords(r2 * 15.0, d2);
        return ar;
    }

    public double[] center(WorldCoordinates pos1, WorldCoordinates pos2) {
        double[] ar = new double[5];
        double ra1 = pos1.getRaDeg();
        double dec1 = pos1.getDecDeg();
        double ra2 = pos2.getRaDeg();
        double dec2 = pos2.getDecDeg();
        ar[0] = (ra1 + ra2) / 2.0;
        ar[1] = (dec1 + dec2) / 2.0;
        ar[2] = WorldCoords.wcsdist(ra1, dec1, ra2, dec1) * 60.0;
        ar[3] = WorldCoords.wcsdist(ra1, dec1, ra1, dec2) * 60.0;
        ar[4] = WorldCoords.wcsdist(ra1, dec1, ra2, dec2) * 60.0 / 2.0;
        return ar;
    }

    public String getCoordinateSystemName() {
        return "wcs";
    }

    private void init(double equinox) {
        this.checkRange();
        this.convertEquinox(equinox, 2000.0);
    }

    private void convertEquinox(double fromEquinox, double toEquinox) {
        if (fromEquinox == toEquinox) {
            return;
        }
        double[] q0 = new double[2];
        double[] q1 = new double[2];
        q0[0] = this.ra.getVal() * 15.0;
        q0[1] = this.dec.getVal();
        JPrec.prej_q(q0, q1, fromEquinox, toEquinox);
        this.ra = new HMS(q1[0] / 15.0);
        this.dec = new DMS(q1[1]);
    }

    private void checkRange() {
        double ra = this.ra.getVal();
        double dec = this.dec.getVal();
        if (ra < -0.001 || ra >= 25.0) {
            // empty if block
        }
        if (dec < -90.0 || dec > 90.0) {
            // empty if block
        }
    }

    public static void main(String[] args) {
        WorldCoords c1 = new WorldCoords(49.95096, 41.51173);
        WorldCoords c2 = new WorldCoords(3.0, 19, 48.2304, 41.0, 30, 42.228);
        WorldCoords c3 = new WorldCoords(new HMS(3.0, 19, 48.2304), new DMS(41.0, 30, 42.228));
        WorldCoords c4 = new WorldCoords(new HMS(c1.getRA()), new DMS(c1.getDec()));
        WorldCoords c5 = new WorldCoords("3 19 48.2304", "+41 30 42.228", 2000.0);
        WorldCoords c6 = new WorldCoords("3:19:48.2304", "+41:30:42.228", 2000.0);
        WorldCoords c7 = new WorldCoords(Double.toString(3.330064), "41.51173", 2000.0);
        System.out.println("these coords should all be the same (or very close):");
        System.out.println(c1);
        System.out.println(c2);
        System.out.println(c3);
        System.out.println(c4);
        System.out.println(c5);
        System.out.println(c6);
        System.out.println(c7);
        c1 = new WorldCoords(49.95096, -41.51173);
        c2 = new WorldCoords(3.0, 19, 48.2304, -41.0, 30, 42.228);
        c3 = new WorldCoords(new HMS(3.0, 19, 48.2304), new DMS(-41.0, 30, 42.228));
        c4 = new WorldCoords(new HMS(c1.getRA()), new DMS(c1.getDec()));
        c5 = new WorldCoords("3 19 48.2304", "-41 30 42.228", 2000.0);
        c6 = new WorldCoords("3:19:48.2304", "-41:30:42.228", 2000.0);
        c7 = new WorldCoords(Double.toString(3.330064), "-41.51173", 2000.0);
        System.out.println("Here is the same with negative dec:");
        System.out.println(c1);
        System.out.println(c2);
        System.out.println(c3);
        System.out.println(c4);
        System.out.println(c5);
        System.out.println(c6);
        System.out.println(c7);
        WorldCoords c8 = new WorldCoords("3:19", "+41:30", 2000.0);
        WorldCoords c9 = new WorldCoords("3", "+41", 2000.0);
        System.out.println("And with missing minutes, ... seconds, ...:");
        System.out.println(c8);
        System.out.println(c9);
        WorldCoords c10 = new WorldCoords("03:19:48.243", "+41:30:40.31");
        WorldCoordinates[] ar1 = c10.box(7.05);
        WorldCoordinates c11 = ar1[0];
        WorldCoordinates c12 = ar1[1];
        System.out.println("box of radius 7.05 with center at (03:19:48.243, +41:30:40.31):");
        System.out.println(c11);
        System.out.println(c12);
        WorldCoords c13 = new WorldCoords("0", "+41:30:40.31");
        System.out.println("With ra = 0.0: " + c13 + " (" + c13.getRA().getVal() + ", " + c13.getDec().getVal() + ")");
        WorldCoords c14 = new WorldCoords("0.0", "-0.0");
        System.out.println("With ra = 0.0, dec = -0.0: " + c14 + " (" + c14.getRA().getVal() + ", " + c14.getDec().getVal() + ")");
        WorldCoords c15 = new WorldCoords("0:0:1", "-0:1:1");
        System.out.println("With ra = 0:0:1, dec = -0:1:1: " + c15 + " (" + c15.getRA().getVal() + ", " + c15.getDec().getVal() + ")");
        WorldCoords c16 = new WorldCoords("22:45:22.74", "-39:34:14.63");
        System.out.println("test conversion between h:m:s and deg and back");
        System.out.println("22:45:22.74 -39:34:14.63 == " + c16 + " == " + c16.toString());
        String[] ar2 = c16.format();
        System.out.println(" == " + ar2[0] + " " + ar2[1]);
        WorldCoords c17 = new WorldCoords(ar2[0], ar2[1]);
        System.out.println(" == " + c17);
        WorldCoords c18 = new WorldCoords(0.0, 0.0, 1950.0);
        String[] ar3 = c18.format(1950.0);
        System.out.println("00:00:00 B1950 == " + c18 + " J2000 == " + ar3[0] + " " + ar3[1] + " B1950");
    }
}

