/*
 * Decompiled with CFR 0.152.
 */
package jsky.html;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import jsky.html.HTMLViewerHistoryItem;
import jsky.html.HTMLViewerMenuBar;
import jsky.util.FileUtil;
import jsky.util.Preferences;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.GenericToolBarTarget;

public class HTMLViewer
extends JPanel
implements GenericToolBarTarget {
    protected Component parent;
    protected JEditorPane html;
    protected URL url;
    protected static JFileChooser fileChooser;
    protected EventListenerList listenerList = new EventListenerList();
    protected Stack backStack = new Stack();
    protected Stack forwStack = new Stack();
    protected boolean noStack = false;
    protected LinkedList historyList;
    protected static final String HISTORY_LIST_NAME = "htmlViewerHistoryList";
    protected int maxHistoryItems = 20;
    protected AbstractAction openAction = new AbstractAction("Open"){

        public void actionPerformed(ActionEvent evt) {
            HTMLViewer.this.open();
        }
    };
    protected AbstractAction backAction = new AbstractAction("Back"){

        public void actionPerformed(ActionEvent evt) {
            HTMLViewer.this.back();
        }
    };
    protected AbstractAction forwAction = new AbstractAction("Forward"){

        public void actionPerformed(ActionEvent evt) {
            HTMLViewer.this.forward();
        }
    };
    protected AbstractAction saveAsAction = new AbstractAction("Save As"){

        public void actionPerformed(ActionEvent evt) {
            HTMLViewer.this.saveAs();
        }
    };
    protected AbstractAction printAction = new AbstractAction("Print..."){

        public void actionPerformed(ActionEvent evt) {
            HTMLViewer.this.print();
        }
    };
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public HTMLViewer() {
        this.html = new JEditorPane();
        this.html.setEditable(false);
        this.html.setContentType("text/html");
        this.html.addHyperlinkListener(this.createHyperLinkListener());
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        vp.add(this.html);
        this.setLayout(new BorderLayout());
        this.add((Component)scroller, "Center");
        this.loadHistory();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                HTMLViewer.this.saveHistory(true);
            }
        });
        this.backAction.setEnabled(false);
        this.forwAction.setEnabled(false);
    }

    public HTMLViewer(Component parent) {
        this();
        this.parent = parent;
    }

    public HTMLViewer(Component parent, URL url) {
        this(parent);
        this.setPage(url);
    }

    public JEditorPane getEditorPane() {
        return this.html;
    }

    public void setPage(final URL url) {
        if (url == null) {
            return;
        }
        this.addToHistory();
        this.url = url;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    HTMLViewer.this.html.setPage(url);
                    HTMLViewer.this.fireChange(new ChangeEvent(this));
                }
                catch (Exception ex) {
                    DialogUtil.error(ex);
                }
            }
        });
    }

    public void setText(String text) {
        try {
            this.addToHistory();
            this.html.setText(text);
            this.url = null;
            this.fireChange(new ChangeEvent(this));
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    protected HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)HTMLViewer.this.html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        HTMLViewer.this.setPage(e.getURL());
                    }
                }
            }
        };
    }

    public void open() {
        int option;
        if (fileChooser == null) {
            fileChooser = this.makeFileChooser();
        }
        if ((option = fileChooser.showOpenDialog(this)) == 0 && fileChooser.getSelectedFile() != null) {
            this.open(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    protected JFileChooser makeFileChooser() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        return fileChooser;
    }

    public void open(String fileOrUrl) {
        URL url = FileUtil.makeURL(null, fileOrUrl);
        this.setPage(url);
    }

    public void openURL() {
        String urlStr = DialogUtil.input("Enter the World Wide Web location (URL) to display:");
        if (urlStr != null) {
            URL url = null;
            try {
                url = new URL(urlStr);
            }
            catch (Exception e) {
                DialogUtil.error(e);
                return;
            }
            this.setPage(url);
        }
    }

    public void close() {
        if (this.parent != null) {
            this.parent.setVisible(false);
        }
    }

    public void back() {
        if (this.backStack.size() == 0) {
            return;
        }
        if (this.url != null) {
            this.forwStack.push(this.makeHTMLViewerHistoryItem());
            this.forwAction.setEnabled(true);
        }
        HTMLViewerHistoryItem historyItem = (HTMLViewerHistoryItem)this.backStack.pop();
        if (this.backStack.size() == 0) {
            this.backAction.setEnabled(false);
        }
        HTMLViewerMenuBar.setCurrentHTMLViewer(this);
        this.noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this.noStack = false;
    }

    public void forward() {
        if (this.forwStack.size() == 0) {
            return;
        }
        if (this.url != null) {
            this.backStack.push(this.makeHTMLViewerHistoryItem());
            this.backAction.setEnabled(true);
        }
        HTMLViewerHistoryItem historyItem = (HTMLViewerHistoryItem)this.forwStack.pop();
        if (this.forwStack.size() == 0) {
            this.forwAction.setEnabled(false);
        }
        HTMLViewerMenuBar.setCurrentHTMLViewer(this);
        this.noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this.noStack = false;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = HTMLViewer.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = HTMLViewer.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    protected void fireChange(ChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$ChangeListener == null ? HTMLViewer.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
            i -= 2;
        }
    }

    protected void addToHistory() {
        if (this.url == null) {
            return;
        }
        HTMLViewerHistoryItem historyItem = this.makeHTMLViewerHistoryItem();
        if (historyItem == null) {
            return;
        }
        if (!this.noStack) {
            this.backStack.push(historyItem);
            this.backAction.setEnabled(true);
            if (this.forwStack.size() != 0) {
                this.forwStack.clear();
                this.forwAction.setEnabled(false);
            }
        }
        this.addToHistory(historyItem);
    }

    protected void addToHistory(HTMLViewerHistoryItem historyItem) {
        ListIterator it = ((LinkedList)this.historyList.clone()).listIterator(0);
        int i = 0;
        while (it.hasNext()) {
            HTMLViewerHistoryItem item = (HTMLViewerHistoryItem)it.next();
            if (item.title.equals(historyItem.title)) {
                this.historyList.remove(i);
            }
            ++i;
        }
        this.historyList.addFirst(historyItem);
        if (this.historyList.size() > this.maxHistoryItems) {
            this.historyList.removeLast();
        }
    }

    protected HTMLViewerHistoryItem makeHTMLViewerHistoryItem() {
        String title = this.url.toString();
        if (title != null) {
            return new HTMLViewerHistoryItem(title, this.url);
        }
        return null;
    }

    public int getMaxHistoryItems() {
        return this.maxHistoryItems;
    }

    public void setMaxHistoryItems(int n) {
        this.maxHistoryItems = n;
    }

    public void addHistoryMenuItems(JMenu menu) {
        ListIterator it = this.historyList.listIterator(0);
        while (it.hasNext()) {
            menu.add((HTMLViewerHistoryItem)it.next());
        }
    }

    protected void cleanupHistoryList() {
        ListIterator it = this.historyList.listIterator(0);
        while (it.hasNext()) {
            HTMLViewerHistoryItem item = (HTMLViewerHistoryItem)it.next();
            if (item.getURLStr() != null) continue;
            it.remove();
        }
    }

    protected LinkedList mergeHistoryList() {
        LinkedList savedHistory = this.historyList;
        this.loadHistory();
        ListIterator it = savedHistory.listIterator(savedHistory.size() - 1);
        while (it.hasPrevious()) {
            this.addToHistory((HTMLViewerHistoryItem)it.previous());
        }
        return this.historyList;
    }

    protected void clearHistory() {
        this.historyList = new LinkedList();
        this.backAction.setEnabled(false);
        this.backStack.clear();
        this.forwAction.setEnabled(false);
        this.forwStack.clear();
        this.saveHistory(false);
    }

    protected void saveHistory(boolean merge) {
        try {
            LinkedList l = merge ? this.mergeHistoryList() : this.historyList;
            Preferences.getPreferences().serialize(HISTORY_LIST_NAME, l);
        }
        catch (Exception e) {}
    }

    protected void loadHistory() {
        try {
            this.historyList = (LinkedList)Preferences.getPreferences().deserialize(HISTORY_LIST_NAME);
            this.cleanupHistoryList();
        }
        catch (Exception e) {
            this.historyList = new LinkedList();
        }
    }

    public void saveAs() {
    }

    public void print() {
    }

    public AbstractAction getOpenAction() {
        return this.openAction;
    }

    public AbstractAction getSaveAsAction() {
        return this.saveAsAction;
    }

    public AbstractAction getPrintAction() {
        return this.printAction;
    }

    public AbstractAction getBackAction() {
        return this.backAction;
    }

    public AbstractAction getForwAction() {
        return this.forwAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

