/*
 * Decompiled with CFR 0.152.
 */
package jsky.image;

import java.awt.image.ColorModel;
import java.awt.image.RGBImageFilter;

public class GreyscaleFilter
extends RGBImageFilter {
    public GreyscaleFilter() {
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        return rgb;
    }

    public void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int off, int scansize) {
        int index = off;
        int cy = 0;
        while (cy < h) {
            int cx = 0;
            while (cx < w) {
                int red = (pixels[index] & 0xFF0000) >> 16;
                int green = (pixels[index] & 0xFF00) >> 8;
                int blue = pixels[index] & 0xFF;
                if (red != green || green != blue) {
                    int grey = (int)Math.round((double)(red + green + blue) / 3.0);
                    pixels[index] = pixels[index] & 0xFF000000 | grey << 16 | grey << 8 | grey;
                }
                ++index;
                ++cx;
            }
            index += scansize - w;
            ++cy;
        }
        this.consumer.setPixels(x, y, w, h, ColorModel.getRGBdefault(), pixels, off, scansize);
    }
}

