/*
 * Decompiled with CFR 0.152.
 */
package jsky.image;

import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.SampleModel;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;

public class ImageUtil {
    public static double getImageProperty(PlanarImage im, String name, double defaultValue) {
        Object o = im.getProperty(name);
        if (o != null && o != Image.UndefinedProperty) {
            return Double.parseDouble(o.toString());
        }
        return defaultValue;
    }

    public static int getImageProperty(PlanarImage im, String name, int defaultValue) {
        Object o = im.getProperty(name);
        if (o != null && o != Image.UndefinedProperty) {
            return Integer.parseInt(o.toString());
        }
        return defaultValue;
    }

    public static String getImageProperty(PlanarImage im, String name, String defaultValue) {
        Object o = im.getProperty(name);
        if (o != null && o != Image.UndefinedProperty) {
            return o.toString();
        }
        return defaultValue;
    }

    public static RenderingHints getTileCacheHint(int numTiles, int tileWidth, int tileHeight) {
        ImageLayout layout = new ImageLayout();
        layout.setTileWidth(tileWidth);
        layout.setTileHeight(tileHeight);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        TileCache tileCache = JAI.createTileCache((long)(numTiles * tileWidth * tileHeight));
        hints.put(JAI.KEY_TILE_CACHE, tileCache);
        return hints;
    }

    public static RenderingHints getSampleModelHint(int tileWidth, int tileHeight, int dataType) {
        int[] bandOffsets = new int[]{0};
        int pixelStride = 1;
        int scanlineStride = tileWidth;
        SampleModel sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)dataType, (int)tileWidth, (int)tileHeight, (int)pixelStride, (int)scanlineStride, (int[])bandOffsets);
        ImageLayout layout = new ImageLayout();
        layout.setTileWidth(tileWidth);
        layout.setTileHeight(tileHeight);
        layout.setSampleModel(sampleModel);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return hints;
    }
}

