/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits.codec;

import java.awt.image.Raster;
import java.io.IOException;
import jsky.image.fits.codec.FITSImage;
import nom.tam.image.ImageTiler;

public abstract class FITSData {
    protected FITSImage _fitsImage;
    private ImageTiler _tiler;
    protected int _naxis;
    protected int _width;
    protected int _height;

    public FITSData(FITSImage fitsImage) {
        this._fitsImage = fitsImage;
        this._tiler = this._fitsImage.getImageTiler();
        this._naxis = this._fitsImage.getNAXIS();
        this._width = this._fitsImage.getRealWidth();
        this._height = this._fitsImage.getRealHeight();
    }

    protected void fillTile(Object destArray, int x, int y, int w, int h) throws IOException {
        int[] lengths;
        int[] corners;
        switch (this._naxis) {
            case 2: {
                corners = new int[]{y, x};
                lengths = new int[]{h, w};
                break;
            }
            case 3: {
                corners = new int[]{0, y, x};
                lengths = new int[]{0, h, w};
                break;
            }
            case 4: {
                corners = new int[]{0, 0, y, x};
                lengths = new int[]{0, 0, h, w};
                break;
            }
            default: {
                throw new RuntimeException("Unsupported number of axes");
            }
        }
        this._tiler.getTile(destArray, corners, lengths);
    }

    public abstract Raster getTile(Raster var1, int var2, int var3, int var4) throws IOException;

    public abstract Raster getPreviewImage(Raster var1, int var2) throws IOException;
}

