/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits.codec;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.Raster;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.MappedByteBuffer;
import jsky.image.fits.codec.FITSData;
import jsky.image.fits.codec.FITSImage;

public class FITSDataDouble
extends FITSData {
    private DoubleBuffer _mappedBuffer;

    public FITSDataDouble(FITSImage fitsImage) {
        super(fitsImage);
        MappedByteBuffer byteBuffer = fitsImage.getByteBuffer();
        if (byteBuffer != null) {
            this._mappedBuffer = byteBuffer.asDoubleBuffer();
        }
    }

    public Raster getTile(Raster tile, int subsample, int scaledWidth, int scaledHeight) throws IOException {
        double[] destArray = FITSDataDouble.getRasterArray(tile);
        int tw = tile.getWidth();
        int th = tile.getHeight();
        int x0 = tile.getMinX();
        int y0 = tile.getMinY();
        int x1 = Math.min(x0 + tw - 1, scaledWidth - 1);
        int y1 = Math.min(y0 + th - 1, scaledHeight - 1);
        int xWidth = x1 - x0 + 1;
        if (this._mappedBuffer != null) {
            int tmpY0 = y0;
            y0 = scaledHeight - y1 - 1;
            y1 = scaledHeight - tmpY0 - 1;
            if (subsample == 1) {
                int j = y1;
                while (j >= y0) {
                    this._mappedBuffer.position(j * this._width + x0);
                    this._mappedBuffer.get(destArray, (y1 - j) * tw, xWidth);
                    --j;
                }
            } else {
                int j = y1;
                while (j >= y0) {
                    int dst = (y1 - j) * tw;
                    int src = (j * this._width + x0) * subsample;
                    int i = x0;
                    while (i <= x1) {
                        destArray[dst++] = this._mappedBuffer.get(src);
                        src += subsample;
                        ++i;
                    }
                    --j;
                }
            }
        } else {
            this.fillTile(destArray, x0, y0, tw, th);
        }
        return tile;
    }

    public Raster getPreviewImage(Raster tile, int factor) throws IOException {
        if (this._mappedBuffer != null) {
            return this.getTile(tile, factor, tile.getWidth(), tile.getHeight());
        }
        double[] destArray = FITSDataDouble.getRasterArray(tile);
        int tw = tile.getWidth();
        int th = tile.getHeight();
        int w = tw * factor;
        int h = th * factor;
        int n = 0;
        int m = 0;
        double[] line = new double[this._width];
        int j = 0;
        while (j < h) {
            n = m++ * tw;
            this.fillTile(line, 0, j, this._width, 1);
            int i = 0;
            while (i < w) {
                destArray[n++] = line[i];
                i += factor;
            }
            j += factor;
        }
        return tile;
    }

    private static double[] getRasterArray(Raster tile) {
        DataBuffer dataBuffer = tile.getDataBuffer();
        if (dataBuffer instanceof javax.media.jai.DataBufferDouble) {
            return ((javax.media.jai.DataBufferDouble)dataBuffer).getData();
        }
        return ((DataBufferDouble)dataBuffer).getData();
    }
}

