/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasLayer;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.FigureLayer;
import diva.canvas.GraphicsPane;
import diva.canvas.event.LayerAdapter;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerListener;
import diva.canvas.interactor.BoundsManipulator;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.PathManipulator;
import diva.canvas.interactor.SelectionEvent;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionListener;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.toolbox.BasicHighlighter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jsky.coords.CoordinateConverter;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureGroup;
import jsky.graphics.CanvasGraphics;
import jsky.graphics.SelectedAreaListener;
import jsky.image.graphics.ImageFigure;
import jsky.image.graphics.ImageFigureGroup;
import jsky.image.graphics.ImageLabel;
import jsky.image.graphics.ImageLayer;
import jsky.image.graphics.LabeledImageFigure;
import jsky.image.graphics.SelectionDragger;
import jsky.image.gui.DivaGraphicsImageDisplay;
import jsky.image.gui.GraphicsImageDisplay;
import jsky.util.gui.BasicWindowMonitor;

public class DivaImageGraphics
implements CanvasGraphics {
    private GraphicsImageDisplay _imageDisplay;
    private GraphicsPane _graphicsPane;
    private FigureLayer _figureLayer;
    private ImageLayer _imageLayer;
    private SelectionInteractor _selectionInteractor;
    private SelectionInteractor _lineInteractor;
    private DragInteractor _dragInteractor;
    private SelectionInteractor _fixedSelectionInteractor;
    private SelectionListener _selectionListener;
    private SelectionDragger _selectionDragger;

    public DivaImageGraphics(DivaGraphicsImageDisplay imageDisplay) {
        this._imageDisplay = imageDisplay;
        this._graphicsPane = (GraphicsPane)imageDisplay.getCanvasPane();
        this._graphicsPane.setAntialiasing(false);
        this._imageLayer = this._makeImageLayer();
        this._graphicsPane.setBackgroundLayer((CanvasLayer)this._imageLayer);
        this._figureLayer = this._graphicsPane.getForegroundLayer();
        this._graphicsPane.getBackgroundEventLayer().addLayerListener((LayerListener)new LayerAdapter(){

            public void mousePressed(LayerEvent e) {
                DivaImageGraphics.this.clearSelection();
            }
        });
        this._makeSelectionListener();
        this._makeSelectionInteractor();
        this._makeLineInteractor();
        this._makeDragInteractor();
        this._makeFixedSelectionInteractor();
        this._makeSelectionDragger();
    }

    public GraphicsPane getGraphicsPane() {
        return this._graphicsPane;
    }

    private ImageLayer _makeImageLayer() {
        return new ImageLayer((DivaGraphicsImageDisplay)this._imageDisplay);
    }

    public ImageLayer getImageLayer() {
        return this._imageLayer;
    }

    private void _makeSelectionInteractor() {
        BoundsManipulator boundsManipulator = new BoundsManipulator();
        boundsManipulator.getHandleInteractor().addLayerListener((LayerListener)new LayerAdapter(){

            public void mouseReleased(LayerEvent e) {
                Figure fig = e.getFigureSource();
                if (fig instanceof CanvasFigure) {
                    ((CanvasFigure)fig).fireCanvasFigureEvent(2);
                }
            }
        });
        this._selectionInteractor = new SelectionInteractor();
        this._selectionInteractor.setPrototypeDecorator((FigureDecorator)boundsManipulator);
        this._selectionInteractor.getSelectionModel().addSelectionListener(this._selectionListener);
    }

    private void _makeLineInteractor() {
        PathManipulator pathManipulator = new PathManipulator();
        pathManipulator.getHandleInteractor().addLayerListener((LayerListener)new LayerAdapter(){

            public void mouseReleased(LayerEvent e) {
                Figure fig = e.getFigureSource();
                if (fig instanceof CanvasFigure) {
                    ((CanvasFigure)fig).fireCanvasFigureEvent(2);
                }
            }
        });
        this._lineInteractor = new SelectionInteractor(this._selectionInteractor.getSelectionModel());
        this._lineInteractor.setPrototypeDecorator((FigureDecorator)pathManipulator);
        this._lineInteractor.getSelectionModel().addSelectionListener(this._selectionListener);
    }

    private void _makeSelectionListener() {
        this._selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                Object o;
                Iterator it;
                try {
                    it = e.getSelectionAdditions();
                    while (it.hasNext()) {
                        o = it.next();
                        if (!(o instanceof CanvasFigure)) continue;
                        ((CanvasFigure)o).fireCanvasFigureEvent(0);
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    it = e.getSelectionRemovals();
                    while (it.hasNext()) {
                        o = it.next();
                        if (!(o instanceof CanvasFigure)) continue;
                        ((CanvasFigure)o).fireCanvasFigureEvent(1);
                    }
                }
                catch (Exception e3) {}
            }
        };
    }

    private void _makeDragInteractor() {
        this._dragInteractor = new DragInteractor();
        this._selectionInteractor.addInteractor((Interactor)this._dragInteractor);
        this._dragInteractor.addLayerListener((LayerListener)new LayerAdapter(){

            public void mouseReleased(LayerEvent e) {
                Figure fig = e.getFigureSource();
                if (fig instanceof CanvasFigure) {
                    ((CanvasFigure)fig).fireCanvasFigureEvent(3);
                }
            }
        });
    }

    private void _makeFixedSelectionInteractor() {
        SelectionModel model = this._selectionInteractor.getSelectionModel();
        this._fixedSelectionInteractor = new SelectionInteractor(model);
        AlphaComposite composite = AlphaComposite.getInstance(3, 0.75f);
        BasicHighlighter h = new BasicHighlighter((Paint)new Color(204, 204, 255), 1.0f, (Composite)composite);
        this._fixedSelectionInteractor.setPrototypeDecorator((FigureDecorator)h);
    }

    private void _makeSelectionDragger() {
        this._selectionDragger = new SelectionDragger(this._graphicsPane){

            public void mouseReleased(LayerEvent e) {
                super.mouseReleased(e);
                this.setEnabled(false);
            }
        };
        this._selectionDragger.addSelectionInteractor(this._selectionInteractor);
        this._selectionDragger.addSelectionInteractor(this._lineInteractor);
        this._selectionDragger.addSelectionInteractor(this._fixedSelectionInteractor);
        this._selectionDragger.setEnabled(false);
    }

    public SelectionDragger getSelectionDragger() {
        return this._selectionDragger;
    }

    public DragInteractor getDragInteractor() {
        return this._dragInteractor;
    }

    public SelectionInteractor getSelectionInteractor() {
        return this._selectionInteractor;
    }

    public SelectionInteractor getLineInteractor() {
        return this._lineInteractor;
    }

    public SelectionInteractor getFixedSelectionInteractor() {
        return this._fixedSelectionInteractor;
    }

    public CanvasFigure makeLabeledFigure(Shape shape, Paint fill, Paint outline, float lineWidth, String label, int anchor, Paint labelColor, Font font, Interactor interactor) {
        if (label == null || label.length() == 0) {
            return new ImageFigure(shape, fill, outline, lineWidth, interactor);
        }
        return new LabeledImageFigure((Figure)new ImageFigure(shape, fill, outline, lineWidth, null), label, anchor, labelColor, font, interactor);
    }

    public CanvasFigure makeFigure(Shape shape, Paint fill, Paint outline, float lineWidth, Interactor interactor) {
        return new ImageFigure(shape, fill, outline, lineWidth, interactor);
    }

    public CanvasFigure makeLabeledFigure(Shape shape, Paint fill, Paint outline, float lineWidth, String label, int anchor, Paint labelColor, Font font) {
        return this.makeLabeledFigure(shape, fill, outline, lineWidth, label, anchor, labelColor, font, (Interactor)this._fixedSelectionInteractor);
    }

    public CanvasFigure makeFigure(Shape shape, Paint fill, Paint outline, float lineWidth) {
        return this.makeFigure(shape, fill, outline, lineWidth, (Interactor)this._fixedSelectionInteractor);
    }

    public CanvasFigure makeLabeledRectangle(Rectangle2D.Double rect, int coordType, Paint fill, Paint outline, float lineWidth, String label, int anchor, Paint labelColor, Font font, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(rect.x, rect.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        Point2D.Double size = new Point2D.Double(rect.width, rect.height);
        coordinateConverter.convertCoords(size, coordType, 1, true);
        Rectangle2D.Double r = new Rectangle2D.Double(p.x, p.y, size.x, size.y);
        return this.makeLabeledFigure(r, fill, outline, lineWidth, label, anchor, labelColor, font, interactor);
    }

    public CanvasFigure makeRectangle(Rectangle2D.Double rect, int coordType, Paint fill, Paint outline, float lineWidth, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(rect.x, rect.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        Point2D.Double size = new Point2D.Double(rect.width, rect.height);
        coordinateConverter.convertCoords(size, coordType, 1, true);
        Rectangle2D.Double r = new Rectangle2D.Double(p.x, p.y, size.x, size.y);
        return this.makeFigure(r, fill, outline, lineWidth, interactor);
    }

    public CanvasFigure makeLabeledEllipse(Ellipse2D.Double ellipse, int coordType, Paint fill, Paint outline, float lineWidth, String label, int anchor, Paint labelColor, Font font, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(ellipse.x, ellipse.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        Point2D.Double size = new Point2D.Double(ellipse.width, ellipse.height);
        coordinateConverter.convertCoords(size, coordType, 1, true);
        Ellipse2D.Double r = new Ellipse2D.Double(p.x, p.y, size.x, size.y);
        return this.makeLabeledFigure(r, fill, outline, lineWidth, label, anchor, labelColor, font, interactor);
    }

    public CanvasFigure makeEllipse(Ellipse2D.Double ellipse, int coordType, Paint fill, Paint outline, float lineWidth, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double(ellipse.x, ellipse.y);
        coordinateConverter.convertCoords(p, coordType, 1, false);
        Point2D.Double size = new Point2D.Double(ellipse.width, ellipse.height);
        coordinateConverter.convertCoords(size, coordType, 1, true);
        Ellipse2D.Double r = new Ellipse2D.Double(p.x, p.y, size.x, size.y);
        return this.makeFigure(r, fill, outline, lineWidth, interactor);
    }

    public CanvasFigure makeLabel(Point2D.Double pos, String text, Paint color, Font font, Interactor interactor) {
        ImageLabel imageLabel = new ImageLabel(text, pos, color, font, interactor);
        return imageLabel;
    }

    public CanvasFigure makeLabel(Point2D.Double pos, String text, Paint color, Font font) {
        ImageLabel imageLabel = new ImageLabel(text, pos, color, font, null);
        return imageLabel;
    }

    public CanvasFigureGroup makeFigureGroup(Interactor interactor) {
        return new ImageFigureGroup(interactor);
    }

    public CanvasFigureGroup makeFigureGroup() {
        return new ImageFigureGroup((Interactor)this._fixedSelectionInteractor);
    }

    public void add(CanvasFigure fig) {
        this._figureLayer.add((Figure)fig);
    }

    public void remove(CanvasFigure fig) {
        SelectionModel model;
        Figure f = (Figure)fig;
        Interactor interactor = f.getInteractor();
        if (interactor instanceof SelectionInteractor && (model = ((SelectionInteractor)interactor).getSelectionModel()).containsSelection((Object)f)) {
            model.removeSelection((Object)f);
        }
        this._figureLayer.remove(f);
    }

    public void select(CanvasFigure fig) {
        Interactor i = ((AbstractFigure)fig).getInteractor();
        if (i instanceof SelectionInteractor) {
            ((SelectionInteractor)i).getSelectionModel().addSelection((Object)fig);
        }
    }

    public void deselect(CanvasFigure fig) {
        Interactor i = ((AbstractFigure)fig).getInteractor();
        if (i instanceof SelectionInteractor) {
            ((SelectionInteractor)i).getSelectionModel().removeSelection((Object)fig);
        }
    }

    public void clearSelection() {
        this._selectionInteractor.getSelectionModel().clearSelection();
    }

    public void scheduleRemoval(CanvasFigure fig) {
        SwingUtilities.invokeLater(new FigureRemover(fig));
    }

    public int getFigureCount() {
        return this._figureLayer.getFigureCount();
    }

    public void transform(AffineTransform trans) {
        Iterator it = this._figureLayer.figures();
        while (it.hasNext()) {
            Figure fig = (Figure)it.next();
            fig.transform(trans);
        }
    }

    public void setInteractionMode(CanvasFigure fig, int mode) {
        Figure figure = (Figure)fig;
        SelectionInteractor interactor = null;
        if ((mode & 0xE) != 0) {
            mode |= 1;
        }
        if (mode == 1) {
            interactor = this._fixedSelectionInteractor;
        } else if (mode == 3) {
            interactor = this._dragInteractor;
        } else if (mode == 7) {
            interactor = this._selectionInteractor;
        }
        figure.setInteractor((Interactor)interactor);
    }

    public void selectArea(final SelectedAreaListener l) {
        SelectionDragger sd = new SelectionDragger(this._graphicsPane){

            public void mouseReleased(LayerEvent e) {
                super.mouseReleased(e);
                this.setEnabled(false);
                Rectangle2D r = this.getSelectedArea();
                if (r != null) {
                    l.setSelectedArea(r);
                }
            }
        };
        sd.setEnabled(true);
    }

    public void repaint() {
        this._figureLayer.repaint();
    }

    public void repaint(Rectangle2D region) {
        this._figureLayer.repaint(region);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("GraphicsImageDisplay");
        DivaGraphicsImageDisplay imageDisplay = new DivaGraphicsImageDisplay();
        if (args.length > 0) {
            try {
                imageDisplay.setImage((PlanarImage)JAI.create((String)"fileload", (Object)args[0]));
            }
            catch (Exception e) {
                System.out.println("error: " + e.toString());
                System.exit(1);
            }
        }
        DivaImageGraphics g = new DivaImageGraphics(imageDisplay);
        CoordinateConverter coordinateConverter = imageDisplay.getCoordinateConverter();
        SelectionInteractor si = g.getSelectionInteractor();
        SelectionInteractor fsi = g.getFixedSelectionInteractor();
        DragInteractor di = g.getDragInteractor();
        int anchor = 0;
        Font font = new Font("Dialog", 0, 10);
        Rectangle2D.Double r1 = new Rectangle2D.Double(50.0, 50.0, 50.0, 50.0);
        g.add(g.makeLabeledRectangle(r1, 3, null, Color.blue, 2.0f, "Test1", anchor, Color.blue, font, (Interactor)fsi));
        Rectangle2D.Double r2 = new Rectangle2D.Double(70.0, 70.0, 50.0, 50.0);
        g.add(g.makeLabeledRectangle(r2, 3, null, Color.white, 2.0f, "Test2", anchor, Color.blue, font, (Interactor)fsi));
        Ellipse2D.Double e1 = new Ellipse2D.Double(150.0, 150.0, 50.0, 50.0);
        g.add(g.makeEllipse(e1, 3, Color.red, Color.white, 2.0f, (Interactor)si));
        Ellipse2D.Double e2 = new Ellipse2D.Double(120.0, 120.0, 20.0, 60.0);
        g.add(g.makeEllipse(e2, 3, Color.green, Color.yellow, 2.0f, (Interactor)si));
        Ellipse2D.Double e3 = new Ellipse2D.Double(20.0, 220.0, 50.0, 20.0);
        g.add(g.makeEllipse(e3, 3, null, Color.white, 2.0f, (Interactor)si));
        Ellipse2D.Double e4 = new Ellipse2D.Double(55.0, 200.0, 10.0, 40.0);
        g.add(g.makeEllipse(e4, 3, Color.white, Color.yellow, 2.0f, (Interactor)di));
        Point2D.Double pos = new Point2D.Double(10.0, 50.0);
        g.add(g.makeLabel(pos, "Test Label", Color.yellow, font));
        Rectangle2D.Double r3 = new Rectangle2D.Double(150.0, 50.0, 50.0, 50.0);
        CanvasFigure f1 = g.makeRectangle(r3, 3, null, Color.yellow, 2.0f, (Interactor)fsi);
        pos = new Point2D.Double(r3.x + 20.0, r3.y + 20.0);
        CanvasFigure f2 = g.makeLabel(pos, "Group", Color.yellow, new JLabel().getFont());
        CanvasFigureGroup group = g.makeFigureGroup();
        group.add(f1);
        group.add(f2);
        g.add(group);
        g.selectArea(new SelectedAreaListener(){

            public void setSelectedArea(Rectangle2D r) {
                System.out.println("Selected area: " + r);
            }
        });
        frame.getContentPane().add((Component)((Object)imageDisplay), "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }

    private class FigureRemover
    implements Runnable {
        CanvasFigure fig;

        public FigureRemover(CanvasFigure fig) {
            this.fig = fig;
        }

        public void run() {
            DivaImageGraphics.this.remove(this.fig);
        }
    }
}

