/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.ListIterator;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureGroup;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerManager;

public class ImageFigureGroup
extends CompositeFigure
implements CanvasFigureGroup {
    protected Object clientData;
    protected CanvasFigureListenerManager listenerManager = new CanvasFigureListenerManager(this);
    protected LinkedList slaves;

    public ImageFigureGroup(Interactor interactor) {
        if (interactor != null) {
            this.setInteractor(interactor);
        }
    }

    public void add(CanvasFigure fig) {
        super.add((Figure)fig);
    }

    public void remove(CanvasFigure fig) {
        super.remove((Figure)fig);
    }

    public void setClientData(Object o) {
        this.clientData = o;
    }

    public Object getClientData() {
        return this.clientData;
    }

    public Rectangle2D getBoundsWithoutLabel() {
        return this.getBounds();
    }

    public boolean isSelected() {
        return this.getInteractor() instanceof SelectionInteractor;
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        this.repaint();
    }

    public void addCanvasFigureListener(CanvasFigureListener listener) {
        this.listenerManager.addCanvasFigureListener(listener);
    }

    public void removeCanvasFigureListener(CanvasFigureListener listener) {
        this.listenerManager.removeCanvasFigureListener(listener);
    }

    public void fireCanvasFigureEvent(int eventType) {
        this.listenerManager.fireCanvasFigureEvent(eventType);
    }

    public void addSlave(CanvasFigure fig) {
        if (this.slaves == null) {
            this.slaves = new LinkedList();
        }
        this.slaves.add(fig);
    }

    public void translate(double x, double y) {
        super.translate(x, y);
        if (this.slaves != null) {
            ListIterator it = this.slaves.listIterator(0);
            while (it.hasNext()) {
                Figure fig = (Figure)it.next();
                fig.translate(x, y);
            }
        }
    }
}

