/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics.gui;

import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import diva.util.java2d.Polygon2D;
import diva.util.java2d.Polyline2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.LinkedList;
import java.util.ListIterator;
import jsky.coords.CoordinateConverter;
import jsky.graphics.CanvasFigure;
import jsky.image.fits.codec.FITSImage;
import jsky.image.graphics.DivaImageGraphics;
import jsky.image.graphics.ImageFigure;
import jsky.image.graphics.ImageLabel;
import jsky.image.graphics.gui.CanvasDraw;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.util.TclUtil;
import jsky.util.gui.DialogUtil;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.TableHDU;

public class FITSGraphics {
    protected DivaMainImageDisplay imageDisplay;
    protected DivaImageGraphics graphics;
    protected CanvasDraw canvasDraw;
    protected SelectionInteractor interactor;
    protected static final int[] PATTERNS = new int[]{10, 9, 8, 6, 4, 2, 1, 0, 9, 8, 7, 6, 5, 4, 3, 1};

    public FITSGraphics(DivaMainImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
        this.graphics = (DivaImageGraphics)imageDisplay.getCanvasGraphics();
        this.canvasDraw = imageDisplay.getCanvasDraw();
        this.interactor = this.graphics.getSelectionInteractor();
    }

    public void saveGraphicsWithImage(String extName) throws FitsException {
        FITSImage fitsImage = this.imageDisplay.getFitsImage();
        if (fitsImage == null) {
            DialogUtil.error("Graphics can only be saved in a FITS image");
            return;
        }
        LinkedList figureList = this.canvasDraw.getFigureList();
        if (figureList.size() == 0) {
            return;
        }
        int n = figureList.size();
        String[] type = new String[n];
        String[] coords = new String[n];
        String[] config = new String[n];
        ListIterator it = figureList.listIterator(0);
        int i = 0;
        while (it.hasNext()) {
            CanvasFigure fig;
            CanvasFigure cfig = (CanvasFigure)it.next();
            if (cfig instanceof ImageFigure) {
                fig = (ImageFigure)cfig;
                Shape shape = fig.getShape();
                Paint fill = fig.getFillPaint();
                Paint outline = fig.getStrokePaint();
                float lineWidth = fig.getLineWidth();
                Composite composite = fig.getComposite();
                type[i] = this.getType(shape);
                coords[i] = this.getCoords(shape);
                config[i] = this.getConfig(fill, outline, (int)lineWidth, composite);
            } else if (cfig instanceof ImageLabel) {
                fig = (ImageLabel)cfig;
                Font font = fig.getFont();
                String text = fig.getString();
                Paint fill = fig.getFillPaint();
                type[i] = "text";
                coords[i] = this.getCoords((Point2D.Double)((ImageLabel)fig).getAnchorPoint());
                config[i] = this.getConfig(text, font, fill);
            }
            ++i;
        }
        Fits fits = fitsImage.getFits();
        BinaryTable table = new BinaryTable();
        FitsFactory.setUseAsciiTables((boolean)false);
        table.addColumn((Object)type);
        table.addColumn((Object)coords);
        table.addColumn((Object)config);
        BinaryTableHDU hdu = (BinaryTableHDU)Fits.makeHDU((Data)table);
        hdu.getHeader().addValue("EXTNAME", extName, "Contains saved JSkyCat graphics");
        hdu.setColumnName(0, "type", null);
        hdu.setColumnName(1, "coords", null);
        hdu.setColumnName(2, "config", null);
        this.deleteHDU(extName);
        fits.addHDU((BasicHDU)hdu);
        this.imageDisplay.checkExtensions(true);
    }

    public void loadGraphicsFromImage(String extName) {
        FITSImage fitsImage = this.imageDisplay.getFitsImage();
        if (fitsImage == null) {
            return;
        }
        int n = fitsImage.getNumHDUs();
        if (n <= 1) {
            return;
        }
        int i = 0;
        while (i < n) {
            Header header;
            String name;
            BasicHDU hdu = fitsImage.getHDU(i);
            if (hdu instanceof TableHDU && (name = (header = hdu.getHeader()).getStringValue("EXTNAME")) != null && name.equals(extName)) {
                try {
                    this.loadGraphicsFromImage((TableHDU)hdu);
                }
                catch (Exception e) {
                    DialogUtil.error(e);
                }
                return;
            }
            ++i;
        }
    }

    public void loadGraphicsFromImage(TableHDU hdu) throws FitsException {
        int nrows = hdu.getNRows();
        int ncols = hdu.getNCols();
        if (nrows <= 0) {
            return;
        }
        if (ncols != 3) {
            return;
        }
        int rowNum = 0;
        while (rowNum < nrows) {
            Object[] row = hdu.getRow(rowNum);
            String type = (String)row[0];
            double[] c = this.getCoords(TclUtil.splitList((String)row[1]));
            String[] config = TclUtil.splitList((String)row[2]);
            Object shape = null;
            Color fill = null;
            Color outline = Color.white;
            float lineWidth = 1.0f;
            Composite composite = null;
            Font font = CanvasDraw.FONTS[3];
            String text = null;
            int i = 0;
            while (i < config.length) {
                String[] optArg = TclUtil.splitList(config[i]);
                if (optArg.length == 2) {
                    if (optArg[0].equals("-fill")) {
                        fill = this.getColor(optArg[1]);
                    } else if (optArg[0].equals("-outline")) {
                        outline = this.getColor(optArg[1]);
                    } else if (optArg[0].equals("-width")) {
                        lineWidth = Float.parseFloat(optArg[1]);
                    } else if (optArg[0].equals("-font")) {
                        font = this.getFont(optArg[1]);
                    } else if (optArg[0].equals("-text")) {
                        text = optArg[1];
                    } else if (optArg[0].equals("-stipple")) {
                        composite = this.getStipple(optArg[1]);
                    } else if (optArg[0].equals("-composite")) {
                        composite = this.getComposite(optArg[1]);
                    }
                }
                ++i;
            }
            if (type.equals("rectangle")) {
                shape = new Rectangle2D.Double(c[0], c[1], c[2] - c[0], c[3] - c[1]);
            } else if (type.equals("oval")) {
                shape = new Ellipse2D.Double(c[0], c[1], c[2] - c[0], c[3] - c[1]);
            } else if (type.equals("line")) {
                if (outline == null) {
                    outline = fill;
                }
                fill = null;
                if (c.length == 4) {
                    shape = new Polyline2D.Double(c[0], c[1], c[2], c[3]);
                } else if (c.length > 4) {
                    Polyline2D.Double p = new Polyline2D.Double(c.length);
                    p.moveTo(c[0], c[1]);
                    int i2 = 2;
                    while (i2 < c.length) {
                        p.lineTo(c[i2], c[i2 + 1]);
                        i2 += 2;
                    }
                    shape = p;
                }
            } else if (type.equals("polygon")) {
                shape = new Polygon2D.Double(c);
            } else if (type.equals("text") && text != null) {
                Point2D.Double pos = new Point2D.Double(c[0], c[1]);
                ImageLabel fig = new ImageLabel(text, pos, fill, font, (Interactor)this.interactor);
                this.canvasDraw.addFigure(fig);
            }
            if (shape != null) {
                ImageFigure fig = new ImageFigure((Shape)shape, fill, outline, lineWidth, (Interactor)this.interactor);
                if (composite != null) {
                    fig.setComposite((AlphaComposite)composite);
                }
                this.canvasDraw.addFigure(fig);
            }
            ++rowNum;
        }
    }

    public void deleteHDU(String extName) {
        FITSImage fitsImage = this.imageDisplay.getFitsImage();
        int n = fitsImage.getNumHDUs();
        int i = 0;
        while (i < n) {
            Header header;
            String name;
            BasicHDU hdu = fitsImage.getHDU(i);
            if (hdu instanceof TableHDU && (name = (header = hdu.getHeader()).getStringValue("EXTNAME")) != null && name.equals(extName)) {
                try {
                    fitsImage.getFits().deleteHDU(i);
                }
                catch (Exception e) {
                    DialogUtil.error(e);
                }
                return;
            }
            ++i;
        }
    }

    protected double[] getCoords(String[] coords) {
        double[] c = new double[coords.length];
        CoordinateConverter coordinateConverter = this.imageDisplay.getCoordinateConverter();
        Point2D.Double p = new Point2D.Double();
        int i = 0;
        while (i < c.length) {
            p.x = Double.parseDouble(coords[i]);
            p.y = Double.parseDouble(coords[i + 1]);
            coordinateConverter.imageToScreenCoords(p, false);
            c[i] = p.x;
            c[i + 1] = p.y;
            i += 2;
        }
        return c;
    }

    protected Color getColor(String s) {
        String[] ar = CanvasDraw.COLOR_NAMES;
        int n = ar.length - 1;
        int i = 0;
        while (i < n) {
            if (ar[i].equals(s)) {
                return CanvasDraw.COLORS[i];
            }
            ++i;
        }
        if (s.startsWith("grey")) {
            try {
                int i2 = Integer.parseInt(s.substring(4));
                if (i2 > 50) {
                    return Color.lightGray;
                }
                return Color.darkGray;
            }
            catch (Exception e) {
            }
        }
        return Color.white;
    }

    protected String getColorName(Color c) {
        Color[] ar = CanvasDraw.COLORS;
        int n = ar.length - 1;
        int i = 0;
        while (i < n) {
            if (ar[i] == c) {
                return CanvasDraw.COLOR_NAMES[i];
            }
            ++i;
        }
        return "white";
    }

    protected Font getFont(String s) {
        return Font.decode(s);
    }

    protected Composite getStipple(String s) {
        if (s.startsWith("pat")) {
            try {
                int i = Integer.parseInt(s.substring(3));
                return CanvasDraw.COMPOSITES[PATTERNS[i]];
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    protected Composite getComposite(String s) {
        if (s.endsWith("%")) {
            int i = 0;
            while (i < CanvasDraw.COMPOSITE_NAMES.length) {
                if (s.equals(CanvasDraw.COMPOSITE_NAMES[i])) {
                    return CanvasDraw.COMPOSITES[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected String getCompositeName(Composite composite) {
        Composite[] ar = CanvasDraw.COMPOSITES;
        int n = ar.length;
        int i = 0;
        while (i < n) {
            if (ar[i] == composite) {
                return CanvasDraw.COMPOSITE_NAMES[i];
            }
            ++i;
        }
        return CanvasDraw.COMPOSITE_NAMES[0];
    }

    protected String getType(Shape shape) {
        if (shape instanceof Rectangle2D) {
            return "rectangle";
        }
        if (shape instanceof Polyline2D) {
            return "line";
        }
        if (shape instanceof Ellipse2D) {
            return "oval";
        }
        if (shape instanceof Polygon2D) {
            return "polygon";
        }
        throw new RuntimeException("Unsupported shape for saved graphics: " + shape);
    }

    protected String getCoords(Shape shape) {
        int i;
        int n;
        Polyline2D p;
        double[] c = null;
        if (shape instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)shape;
            c = new double[]{r.getX(), r.getY(), c[0] + r.getWidth(), c[1] + r.getHeight()};
        } else if (shape instanceof Polyline2D) {
            p = (Polyline2D)shape;
            n = p.getVertexCount();
            c = new double[n * 2];
            i = 0;
            while (i < n) {
                c[i * 2] = p.getX(i);
                c[i * 2 + 1] = p.getY(i);
                ++i;
            }
        } else if (shape instanceof Polygon2D.Double) {
            p = (Polygon2D)shape;
            n = p.getVertexCount();
            c = new double[n * 2];
            i = 0;
            while (i < n) {
                c[i * 2] = p.getX(i);
                c[i * 2 + 1] = p.getY(i);
                ++i;
            }
        } else {
            throw new RuntimeException("Unsupported shape for saved graphics: " + shape);
        }
        CoordinateConverter coordinateConverter = this.imageDisplay.getCoordinateConverter();
        Point2D.Double p2 = new Point2D.Double();
        i = 0;
        while (i < c.length) {
            p2.x = c[i];
            p2.y = c[i + 1];
            coordinateConverter.screenToImageCoords(p2, false);
            c[i] = p2.x;
            c[i + 1] = p2.y;
            i += 2;
        }
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < c.length) {
            buf.append(Double.toString(c[i2]));
            buf.append(' ');
            ++i2;
        }
        return buf.toString();
    }

    protected String getCoords(Point2D.Double p) {
        CoordinateConverter coordinateConverter = this.imageDisplay.getCoordinateConverter();
        coordinateConverter.screenToImageCoords(p, false);
        return Double.toString(p.getX()) + " " + Double.toString(p.getY());
    }

    protected String getConfig(Paint fill, Paint outline, int lineWidth, Composite composite) {
        StringBuffer buf = new StringBuffer();
        if (fill != null) {
            buf.append("{-fill ");
            buf.append(this.getColorName((Color)fill));
            buf.append("} ");
        }
        if (outline != null) {
            buf.append("{-outline ");
            buf.append(this.getColorName((Color)outline));
            buf.append("} ");
        }
        if (lineWidth != 1) {
            buf.append("{-width ");
            buf.append(Integer.toString(lineWidth));
            buf.append("} ");
        }
        if (composite != null) {
            buf.append("{-composite ");
            buf.append(this.getCompositeName(composite));
            buf.append("} ");
        }
        return buf.toString();
    }

    protected String getConfig(String text, Font font, Paint fill) {
        StringBuffer buf = new StringBuffer();
        if (text != null) {
            buf.append("{-text {");
            buf.append(text);
            buf.append("}} ");
        }
        if (font != null) {
            buf.append("{-font {");
            String style = font.isItalic() ? "italic" : (font.isBold() ? "bold" : "plain");
            buf.append(font.getFontName() + "-" + style + "-" + font.getSize());
            buf.append("}} ");
        }
        if (fill != null) {
            buf.append("{-fill ");
            buf.append(this.getColorName((Color)fill));
            buf.append("} ");
        }
        return buf.toString();
    }
}

