/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsky.image.BasicImageReadableProcessor;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageColorITTs;
import jsky.image.ImageColorLUTs;
import jsky.image.ImageProcessor;
import jsky.util.I18N;

public class ImageColors
extends JPanel {
    private static final I18N _I18N = I18N.getInstance(class$jsky$image$gui$ImageColors == null ? (class$jsky$image$gui$ImageColors = ImageColors.class$("jsky.image.gui.ImageColors")) : class$jsky$image$gui$ImageColors);
    protected Component parent;
    protected BasicImageReadableProcessor imageDisplay;
    protected ImageProcessor imageProcessor;
    String[] colormaps = ImageColorLUTs.getLUTNames();
    JList colormapList = new JList<String>(this.colormaps);
    String[] itts = ImageColorITTs.getITTNames();
    JList intensityList = new JList<String>(this.itts);
    protected JRadioButton linearScale = new JRadioButton(_I18N.getString("linearScale"));
    JRadioButton logScale = new JRadioButton(_I18N.getString("logarithmic"));
    JRadioButton sqrtScale = new JRadioButton(_I18N.getString("squareRoot"));
    JRadioButton histeqScale = new JRadioButton(_I18N.getString("histogram"));
    protected boolean ignoreEvents = false;
    static /* synthetic */ Class class$jsky$image$gui$ImageColors;

    public ImageColors(Component parent, BasicImageReadableProcessor imageDisplay) {
        this.parent = parent;
        this.imageDisplay = imageDisplay;
        this.imageProcessor = imageDisplay.getImageProcessor();
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeMainPanel(), "Center");
        this.add((Component)this.makeButtonPanel(), "South");
        this.imageProcessor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewColormap()) {
                    ImageColors.this.updateDisplay();
                }
            }
        });
        this.updateDisplay();
    }

    protected JPanel makeMainPanel() {
        JPanel panel = new JPanel();
        panel.add(this.makeColorScalePanel());
        panel.add(this.makeColormapListPanel());
        panel.add(this.makeIntensityListPanel());
        return panel;
    }

    protected JPanel makeColorScalePanel() {
        JPanel panel = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        panel.setBorder(BorderFactory.createTitledBorder(border, _I18N.getString("colorScaleAlgorithm"), 2, 2));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.linearScale);
        panel.add(this.logScale);
        panel.add(this.sqrtScale);
        panel.add(this.histeqScale);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.linearScale);
        grp.add(this.logScale);
        grp.add(this.sqrtScale);
        grp.add(this.histeqScale);
        this.linearScale.setSelected(true);
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!ImageColors.this.ignoreEvents) {
                    ImageColors.this.setScaleAlgorithm(e.getActionCommand());
                }
            }
        };
        this.linearScale.addActionListener(l);
        this.logScale.addActionListener(l);
        this.sqrtScale.addActionListener(l);
        this.histeqScale.addActionListener(l);
        return panel;
    }

    protected void setScaleAlgorithm(String name) {
        if (name.equals(_I18N.getString("linearScale"))) {
            this.imageProcessor.setScaleAlgorithm(0);
        } else if (name.equals(_I18N.getString("logarithmic"))) {
            this.imageProcessor.setScaleAlgorithm(2);
        } else if (name.equals(_I18N.getString("squareRoot"))) {
            this.imageProcessor.setScaleAlgorithm(1);
        } else if (name.equals(_I18N.getString("histogram"))) {
            this.imageProcessor.setScaleAlgorithm(3);
        }
        this.imageProcessor.update();
    }

    protected JPanel makeColormapListPanel() {
        JPanel panel = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        panel.setBorder(BorderFactory.createTitledBorder(border, _I18N.getString("colormap"), 2, 2));
        JScrollPane scrollPane = new JScrollPane(this.colormapList);
        panel.add(scrollPane);
        this.colormapList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (!ImageColors.this.ignoreEvents) {
                    Object[] selectedValues;
                    JList src = (JList)evt.getSource();
                    if (!evt.getValueIsAdjusting() && (selectedValues = src.getSelectedValues()).length >= 1) {
                        ImageColors.this.setColormap((String)selectedValues[0]);
                    }
                }
            }
        });
        return panel;
    }

    protected void setColormap(String name) {
        this.imageProcessor.setColorLookupTable(name);
        this.imageProcessor.update();
    }

    protected JPanel makeIntensityListPanel() {
        JPanel panel = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        panel.setBorder(BorderFactory.createTitledBorder(border, _I18N.getString("intensity"), 2, 2));
        JScrollPane scrollPane = new JScrollPane(this.intensityList);
        panel.add(scrollPane);
        this.intensityList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (!ImageColors.this.ignoreEvents) {
                    Object[] selectedValues;
                    JList src = (JList)evt.getSource();
                    if (!evt.getValueIsAdjusting() && (selectedValues = src.getSelectedValues()).length >= 1) {
                        ImageColors.this.setIntensityLookupTable((String)selectedValues[0]);
                    }
                }
            }
        });
        return panel;
    }

    protected void setIntensityLookupTable(String name) {
        this.imageProcessor.setIntensityLookupTable(name);
        this.imageProcessor.update();
    }

    protected JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        JButton resetButton = new JButton(_I18N.getString("reset"));
        resetButton.setToolTipText(_I18N.getString("resetTip"));
        panel.add(resetButton);
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageColors.this.reset();
            }
        });
        JButton closeButton = new JButton(_I18N.getString("close"));
        closeButton.setToolTipText(_I18N.getString("closeTip"));
        panel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageColors.this.close();
            }
        });
        return panel;
    }

    protected void reset() {
        this.imageProcessor.setDefaultColormap();
        this.imageProcessor.update();
        this.linearScale.setSelected(true);
        this.colormapList.setSelectedValue("Real", true);
        this.intensityList.setSelectedValue("Ramp", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDisplay() {
        this.ignoreEvents = true;
        try {
            int scaleAlg = this.imageProcessor.getScaleAlgorithm();
            switch (scaleAlg) {
                case 0: {
                    this.linearScale.setSelected(true);
                    break;
                }
                case 1: {
                    this.sqrtScale.setSelected(true);
                    break;
                }
                case 2: {
                    this.logScale.setSelected(true);
                    break;
                }
                case 3: {
                    this.histeqScale.setSelected(true);
                }
            }
            this.colormapList.setSelectedValue(this.imageProcessor.getColorLookupTableName(), true);
            this.intensityList.setSelectedValue(this.imageProcessor.getIntensityLookupTableName(), true);
            Object var3_2 = null;
            this.ignoreEvents = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.ignoreEvents = false;
            throw throwable;
        }
    }

    protected void close() {
        if (this.parent != null) {
            this.parent.setVisible(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

