/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Properties;
import java.util.Vector;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.TableQueryResult;
import jsky.catalog.skycat.SkycatConfigEntry;
import jsky.catalog.skycat.SkycatTable;
import jsky.navigator.Navigator;
import jsky.util.gui.DialogUtil;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.TableHDU;

public class NavigatorFITSTable
extends SkycatTable {
    protected static final String CATINFO = "CATINFO";
    protected static final String[] CATINFO_COLUMNS = new String[]{"SHORT_NAME", "ID_COL", "RA_COL", "DEC_COL", "X_COL", "Y_COL", "EQUINOX", "SYMBOL", "SEARCH_COLS", "SORT_COLS", "SORT_ORDER", "SHOW_COLS", "HELP", "COPYRIGHT"};
    protected static final int NUM_CATINFO_COLUMNS = CATINFO_COLUMNS.length;

    public NavigatorFITSTable(String filename, Fits fits, TableHDU hdu) throws IOException, FitsException {
        this.setFilename(filename);
        int ncols = hdu.getNCols();
        int nrows = hdu.getNRows();
        this.dataVector = new Vector(nrows);
        this.columnIdentifiers = new Vector(ncols);
        Vector<Object> columnClasses = new Vector<Object>(ncols, 1);
        FieldDesc[] fields = new FieldDescAdapter[ncols];
        Header header = hdu.getHeader();
        String name = header.getStringValue("EXTNAME");
        if (name == null) {
            name = "FITS Table";
        }
        this.setName(name);
        this.setTitle(name);
        this.setId(name);
        int i = 0;
        while (i < ncols) {
            String colName = hdu.getColumnName(i);
            this.columnIdentifiers.add(colName);
            fields[i] = new FieldDescAdapter(colName);
            columnClasses.add(null);
            ++i;
        }
        this.setColumnClasses(columnClasses);
        this.setFields(fields);
        if (nrows > 0) {
            int i2 = 0;
            while (i2 < nrows) {
                Object[] row = hdu.getRow(i2);
                Vector<Object> v = new Vector<Object>(ncols);
                int j = 0;
                while (j < ncols) {
                    Object o = row[j];
                    if (o instanceof String) {
                        o = this._parseItem((String)o);
                    }
                    if (o.getClass().isArray()) {
                        o = Array.get(o, 0);
                    }
                    this._checkColumnClass(j, o);
                    v.add(o);
                    ++j;
                }
                this.dataVector.add(v);
                ++i2;
            }
        }
        try {
            SkycatConfigEntry entry = this.findConfigEntry(fits);
            if (entry != null) {
                this.setConfigEntry(entry);
            }
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    public NavigatorFITSTable(String filename, Fits fits, int hduIndex) throws IOException, FitsException {
        this(filename, fits, NavigatorFITSTable.getTableHDU(fits, hduIndex));
    }

    protected static TableHDU getTableHDU(Fits fits, int hduIndex) throws IOException, FitsException {
        BasicHDU basicHDU = fits.getHDU(hduIndex);
        if (!(basicHDU instanceof TableHDU)) {
            throw new RuntimeException("HDU type not supported: " + basicHDU.getClass());
        }
        return (TableHDU)basicHDU;
    }

    protected SkycatConfigEntry findConfigEntry(Fits fits) throws FitsException, IOException {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        BinaryTableHDU hdu = NavigatorFITSTable.findBinaryTableHDU(fits, CATINFO);
        if (hdu == null) {
            return null;
        }
        int ncols = hdu.getNCols();
        int rowIndex = NavigatorFITSTable.findConfigEntryRow(hdu, name);
        if (rowIndex == -1) {
            return null;
        }
        Object[] row = hdu.getRow(rowIndex);
        Properties properties = new Properties();
        properties.setProperty("serv_type", "local");
        properties.setProperty("long_name", name);
        properties.setProperty("url", this.getFilename());
        int colIndex = 0;
        while (colIndex < ncols) {
            String value = (String)row[colIndex];
            if (value.length() != 0) {
                properties.setProperty(hdu.getColumnName(colIndex).toLowerCase(), value);
            }
            ++colIndex;
        }
        return new SkycatConfigEntry(properties);
    }

    protected static int findConfigEntryRow(BinaryTableHDU hdu, String name) throws FitsException, IOException {
        int nrows = hdu.getNRows();
        int rowIndex = 0;
        while (rowIndex < nrows) {
            String extName = (String)hdu.getElement(rowIndex, 0);
            if (extName.equals(name)) {
                return rowIndex;
            }
            ++rowIndex;
        }
        return -1;
    }

    protected static BinaryTableHDU findBinaryTableHDU(Fits fits, String name) throws FitsException, IOException {
        if (name == null) {
            return null;
        }
        int n = fits.getNumberOfHDUs();
        int hduIndex = 0;
        while (hduIndex < n) {
            BinaryTableHDU hdu;
            Header header;
            String extName;
            BasicHDU basicHDU = fits.getHDU(hduIndex);
            if (basicHDU instanceof BinaryTableHDU && (extName = (header = (hdu = (BinaryTableHDU)basicHDU).getHeader()).getStringValue("EXTNAME")) != null && extName.equals(name)) {
                return hdu;
            }
            ++hduIndex;
        }
        return null;
    }

    public static NavigatorFITSTable saveWithImage(String filename, Fits fits, TableQueryResult table) throws FitsException, IOException {
        String suffix;
        String name = table.getId();
        if (name == null) {
            name = "";
        }
        if (!name.endsWith(suffix = " (FITS Table)")) {
            name = name + suffix;
        }
        int nrows = table.getRowCount();
        int ncols = table.getColumnCount();
        if (nrows == 0 || ncols == 0) {
            return null;
        }
        BinaryTable binTable = new BinaryTable();
        FitsFactory.setUseAsciiTables((boolean)false);
        int col = 0;
        while (col < ncols) {
            String[] data = new String[nrows];
            int row = 0;
            while (row < nrows) {
                Object o = table.getValueAt(row, col);
                String s = o == null ? "" : o.toString();
                data[row] = s;
                ++row;
            }
            binTable.addColumn((Object)data);
            ++col;
        }
        BinaryTableHDU hdu = (BinaryTableHDU)Fits.makeHDU((Data)binTable);
        hdu.getHeader().addValue("EXTNAME", name, "Contains saved query results");
        int col2 = 0;
        while (col2 < ncols) {
            hdu.setColumnName(col2, table.getColumnName(col2), null);
            ++col2;
        }
        NavigatorFITSTable.deleteTable(fits, name);
        fits.addHDU((BasicHDU)hdu);
        NavigatorFITSTable.updateCatInfo(fits, table, name);
        return new NavigatorFITSTable(filename, fits, (TableHDU)hdu);
    }

    protected static void deleteTable(Fits fits, String name) throws FitsException, IOException {
        int numHDUs = fits.getNumberOfHDUs();
        int hduIndex = 0;
        while (hduIndex < numHDUs) {
            BinaryTableHDU hdu;
            Header header;
            String extName;
            BasicHDU basicHDU = fits.getHDU(hduIndex);
            if (basicHDU instanceof BinaryTableHDU && (extName = (header = (hdu = (BinaryTableHDU)basicHDU).getHeader()).getStringValue("EXTNAME")) != null && extName.equals(name)) {
                fits.deleteHDU(hduIndex);
                return;
            }
            ++hduIndex;
        }
    }

    protected static void updateCatInfo(Fits fits, TableQueryResult table, String name) throws FitsException, IOException {
        Object[][] data;
        if (!(table instanceof SkycatTable)) {
            return;
        }
        SkycatConfigEntry entry = ((SkycatTable)table).getConfigEntry();
        if (entry == null) {
            return;
        }
        int ncols = NUM_CATINFO_COLUMNS;
        BinaryTableHDU hdu = NavigatorFITSTable.findBinaryTableHDU(fits, CATINFO);
        int newRowIndex = 0;
        if (hdu != null) {
            int nrows = hdu.getNRows();
            int entryIndex = NavigatorFITSTable.findConfigEntryRow(hdu, name);
            int dummyIndex = NavigatorFITSTable.findConfigEntryRow(hdu, "-");
            int n = nrows;
            if (entryIndex == -1) {
                ++n;
            }
            if (dummyIndex == -1) {
                ++n;
            }
            data = new Object[n][];
            int rowIndex = 0;
            while (rowIndex < nrows) {
                if (rowIndex != entryIndex && rowIndex != dummyIndex) {
                    data[newRowIndex++] = hdu.getRow(rowIndex);
                }
                ++rowIndex;
            }
            NavigatorFITSTable.deleteTable(fits, CATINFO);
        } else {
            data = new Object[2][];
        }
        Properties properties = entry.getProperties();
        Object[] row = new Object[ncols];
        row[0] = name;
        int colIndex = 1;
        while (colIndex < ncols) {
            String value = properties.getProperty(CATINFO_COLUMNS[colIndex].toLowerCase());
            row[colIndex] = value != null ? value : "";
            ++colIndex;
        }
        data[newRowIndex++] = row;
        row = new Object[ncols];
        int colIndex2 = 0;
        while (colIndex2 < ncols) {
            row[colIndex2] = "-";
            ++colIndex2;
        }
        data[newRowIndex++] = row;
        BinaryTable binTable = new BinaryTable(data);
        FitsFactory.setUseAsciiTables((boolean)false);
        hdu = (BinaryTableHDU)Fits.makeHDU((Data)binTable);
        hdu.getHeader().addValue("EXTNAME", CATINFO, "Contains catalog config info");
        int i = 0;
        while (i < ncols) {
            hdu.setColumnName(i, CATINFO_COLUMNS[i], null);
            ++i;
        }
        fits.addHDU((BasicHDU)hdu);
    }

    public static void plotTables(String filename, Fits fits, Navigator navigator) throws FitsException, IOException {
        BinaryTableHDU hdu = NavigatorFITSTable.findBinaryTableHDU(fits, CATINFO);
        if (hdu == null) {
            return;
        }
        int nrows = hdu.getNRows();
        int rowIndex = 0;
        while (rowIndex < nrows) {
            Object[] row = hdu.getRow(rowIndex);
            String name = (String)row[0];
            NavigatorFITSTable.plotTable(filename, fits, navigator, name);
            ++rowIndex;
        }
    }

    protected static void plotTable(String filename, Fits fits, Navigator navigator, String name) throws FitsException, IOException {
        NavigatorFITSTable table = NavigatorFITSTable.findTable(filename, fits, name);
        if (table != null) {
            navigator.setQueryResult(table.getCatalog());
        }
    }

    protected static NavigatorFITSTable findTable(String filename, Fits fits, String name) throws FitsException, IOException {
        BinaryTableHDU hdu = NavigatorFITSTable.findBinaryTableHDU(fits, name);
        if (hdu == null) {
            return null;
        }
        return new NavigatorFITSTable(filename, fits, (TableHDU)hdu);
    }
}

