/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import diva.canvas.GraphicsPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.CatalogNavigatorOpener;
import jsky.catalog.gui.TablePlotter;
import jsky.image.ImageProcessor;
import jsky.image.fits.codec.FITSImage;
import jsky.image.fits.gui.FITSKeywordsFrame;
import jsky.image.fits.gui.FITSKeywordsInternalFrame;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.PickObjectStatistics;
import jsky.navigator.Navigator;
import jsky.navigator.NavigatorFITSTable;
import jsky.navigator.NavigatorFrame;
import jsky.navigator.NavigatorImageDisplayFrame;
import jsky.navigator.NavigatorImageDisplayInternalFrame;
import jsky.navigator.NavigatorInternalFrame;
import jsky.navigator.NavigatorPane;
import jsky.util.I18N;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.SwingUtil;

public class NavigatorImageDisplay
extends DivaMainImageDisplay
implements CatalogNavigatorOpener {
    private static final I18N _I18N = I18N.getInstance(class$jsky$navigator$NavigatorImageDisplay == null ? (class$jsky$navigator$NavigatorImageDisplay = NavigatorImageDisplay.class$("jsky.navigator.NavigatorImageDisplay")) : class$jsky$navigator$NavigatorImageDisplay);
    private Navigator _navigator;
    private NavigatorPane _navigatorPane;
    private Component _navigatorFrame;
    private HashSet _filesVisited = new HashSet();
    private AbstractAction _catalogBrowseAction = new AbstractAction(_I18N.getString("browse") + "..."){

        public void actionPerformed(ActionEvent evt) {
            try {
                NavigatorImageDisplay.this.openCatalogWindow();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    static /* synthetic */ Class class$jsky$navigator$NavigatorImageDisplay;

    public NavigatorImageDisplay(Component parent, ImageProcessor processor) {
        super((GraphicsPane)new NavigatorPane(), parent, processor);
        this._navigatorPane = (NavigatorPane)this.getCanvasPane();
    }

    public NavigatorImageDisplay(Component parent) {
        super((GraphicsPane)new NavigatorPane(), parent);
        this._navigatorPane = (NavigatorPane)this.getCanvasPane();
    }

    public NavigatorPane getNavigatorPane() {
        return this._navigatorPane;
    }

    public Component newWindow() {
        JDesktopPane desktop = this.getDesktop();
        if (desktop != null) {
            NavigatorImageDisplayInternalFrame f = new NavigatorImageDisplayInternalFrame(desktop);
            f.getImageDisplayControl().getImageDisplay().setTitle(this.getTitle());
            f.setVisible(true);
            desktop.add((Component)f, JLayeredPane.DEFAULT_LAYER);
            desktop.moveToFront(f);
            f.setVisible(true);
            return f;
        }
        NavigatorImageDisplayFrame f = new NavigatorImageDisplayFrame();
        f.getImageDisplayControl().getImageDisplay().setTitle(this.getTitle());
        f.setVisible(true);
        return f;
    }

    public void setNavigator(Navigator navigator) {
        this._navigator = navigator;
        this._navigatorFrame = navigator.getRootComponent();
    }

    public Navigator getNavigator() {
        return this._navigator;
    }

    public void openCatalogWindow() {
        if (this._navigatorFrame == null) {
            this.makeNavigatorFrame();
        }
        this.showNavigatorFrame(null);
    }

    public void openCatalogWindow(Catalog cat) {
        if (this._navigatorFrame == null) {
            this.makeNavigatorFrame();
        }
        this.showNavigatorFrame(cat);
    }

    public void openCatalogWindow(String name) {
        CatalogDirectory dir = null;
        try {
            dir = Navigator.getCatalogDirectory();
        }
        catch (Exception e) {
            DialogUtil.error(e);
            return;
        }
        Catalog cat = dir.getCatalog(name);
        if (cat != null) {
            this.openCatalogWindow(cat);
        }
    }

    public void openLocalCatalog() {
        this.openCatalogWindow();
        this._navigator.open();
    }

    public void displayFITSTable(int hdu) {
        block5: {
            try {
                FITSImage fitsImage = this.getFitsImage();
                NavigatorFITSTable table = new NavigatorFITSTable(this.getFilename(), fitsImage.getFits(), hdu);
                this.openCatalogWindow(table.getCatalog());
                Component fitsKeywordsFrame = this.getFitsKeywordsFrame();
                if (fitsKeywordsFrame == null) break block5;
                if (fitsKeywordsFrame instanceof FITSKeywordsFrame) {
                    ((FITSKeywordsFrame)fitsKeywordsFrame).getFITSKeywords().updateDisplay(hdu);
                } else if (fitsKeywordsFrame instanceof FITSKeywordsInternalFrame) {
                    ((FITSKeywordsInternalFrame)fitsKeywordsFrame).getFITSKeywords().updateDisplay(hdu);
                }
            }
            catch (Exception e) {
                DialogUtil.error((Component)((Object)this), e);
            }
        }
    }

    public void saveFITSTable(TableQueryResult table) {
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage == null) {
            DialogUtil.error((Component)((Object)this), "This operation is only supported on FITS files.");
            return;
        }
        try {
            NavigatorFITSTable newTable = NavigatorFITSTable.saveWithImage(this.getFilename(), fitsImage.getFits(), table);
            if (newTable == null) {
                return;
            }
            this.setSaveNeeded(true);
            this.checkExtensions(true);
            TablePlotter plotter = this._navigator.getPlotter();
            if (plotter != null) {
                plotter.unplot(table);
                this._navigator.setQueryResult(newTable.getCatalog());
            }
        }
        catch (Exception e) {
            DialogUtil.error((Component)((Object)this), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showNavigatorFrame(Catalog cat) {
        if (cat != null) {
            try {
                this._navigator.setAutoQuery(true);
                this._navigator.setQueryResult(cat);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        } else {
            this._navigator.setAutoQuery(false);
            SwingUtil.showFrame(this._navigatorFrame);
        }
    }

    protected void makeNavigatorFrame() {
        CatalogDirectory dir = null;
        try {
            dir = Navigator.getCatalogDirectory();
        }
        catch (Exception e) {
            DialogUtil.error(e);
            return;
        }
        JDesktopPane desktop = this.getDesktop();
        Component parent = this.getParentFrame();
        if (parent instanceof JFrame) {
            this._navigatorFrame = new NavigatorFrame(dir, this);
            this._navigator = ((NavigatorFrame)this._navigatorFrame).getNavigator();
        } else if (parent instanceof JInternalFrame) {
            this._navigatorFrame = new NavigatorInternalFrame(desktop, dir, this);
            this._navigator = ((NavigatorInternalFrame)this._navigatorFrame).getNavigator();
            desktop.add(this._navigatorFrame, JLayeredPane.DEFAULT_LAYER);
            desktop.moveToFront(this._navigatorFrame);
        }
    }

    protected void newImage(boolean before) {
        block5: {
            TablePlotter plotter;
            super.newImage(before);
            if (before) break block5;
            if (this._navigatorFrame == null) {
                this.makeNavigatorFrame();
            }
            if ((plotter = this._navigator.getPlotter()) != null) {
                plotter.replotAll();
            }
            String filename = this.getFilename();
            FITSImage fitsImage = this.getFitsImage();
            if (fitsImage != null && filename != null && !this._filesVisited.contains(filename)) {
                this._filesVisited.add(filename);
                try {
                    NavigatorFITSTable.plotTables(filename, fitsImage.getFits(), this._navigator);
                }
                catch (Exception e) {
                    DialogUtil.error((Component)((Object)this), e);
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this._navigatorFrame != null) {
            if (this._navigatorFrame instanceof JFrame) {
                ((JFrame)this._navigatorFrame).dispose();
            } else {
                ((JInternalFrame)this._navigatorFrame).dispose();
            }
        }
    }

    protected void transformGraphics(AffineTransform trans) {
        TablePlotter plotter;
        super.transformGraphics(trans);
        if (this._navigator != null && (plotter = this._navigator.getPlotter()) != null) {
            plotter.transformGraphics(trans);
        }
    }

    public void saveCatalogOverlaysWithImage() {
        TableQueryResult[] tables;
        TablePlotter plotter;
        if (this._navigator != null && (plotter = this._navigator.getPlotter()) != null && (tables = plotter.getTables()) != null) {
            int i = 0;
            while (i < tables.length) {
                this.saveFITSTable(tables[i]);
                ++i;
            }
        }
    }

    protected void pickedObject() {
        if (this._navigatorFrame == null) {
            this.makeNavigatorFrame();
        }
        if (this._navigator == null) {
            return;
        }
        PickObjectStatistics stats = this.getPickObjectPanel().getStatistics();
        if (stats == null) {
            DialogUtil.error("No object was selected");
            return;
        }
        this._navigator.addPickedObjectToTable(stats, this.getPickObjectPanel().isUpdate());
    }

    public AbstractAction getCatalogBrowseAction() {
        return this._catalogBrowseAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

