/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.HashMap;
import jsky.science.ScienceObjectModel;
import jsky.science.ScienceObjectNodeModel;
import jsky.util.ReplaceablePropertyChangeListener;
import jsky.util.ReplaceablePropertyVetoException;
import jsky.util.ReplacementEvent;
import jsky.util.ReplacementVetoException;

public abstract class AbstractScienceObject
implements ScienceObjectModel,
Cloneable,
Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private String fName;
    private boolean fTracing = false;
    private transient ScienceObjectNodeModel fParent;
    private transient ReplaceablePropertyChangeListener[] fListeners;
    private static transient EventMonitor[] sMonitors;
    private static transient Object[] sTracers;
    private static transient HashMap sClassIndices;
    private Exception fException;
    private static boolean sTraceAll;
    private static String debugIndent;
    private static String replaceIndent;
    private static boolean showDebug;

    public AbstractScienceObject() {
        this(null);
    }

    public AbstractScienceObject(String inName) {
        this.setParent(null);
        this.fName = inName;
    }

    public String toString() {
        if (this.fName == null || this.fName.length() == 0) {
            return super.toString();
        }
        return this.fName;
    }

    public ScienceObjectNodeModel getParent() {
        return this.fParent;
    }

    public void setParent(ScienceObjectNodeModel model) {
        this.fParent = model;
    }

    public boolean isPending() {
        return false;
    }

    public Exception getException() {
        return this.fException;
    }

    public void setException(Exception e) {
        this.fException = e;
    }

    public boolean isValid() {
        return this.fException == null;
    }

    public boolean isHolding() {
        return false;
    }

    public void setHolding(boolean hold) {
    }

    public Object clone() {
        AbstractScienceObject cl = null;
        try {
            cl = (AbstractScienceObject)super.clone();
            cl.setName(this.getName());
        }
        catch (CloneNotSupportedException e) {}
        return cl;
    }

    public int compareTo(Object o) {
        try {
            return this.getName().compareTo(((ScienceObjectModel)o).getName());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractScienceObject)) {
            return false;
        }
        AbstractScienceObject that = (AbstractScienceObject)obj;
        return this.areNamesEqual(that);
    }

    public String getName() {
        if (this.fName == null) {
            this.fName = this.createDefaultName();
        }
        return this.fName == null ? "" : this.fName;
    }

    protected boolean areNamesEqual(ScienceObjectModel target) {
        String targName = target.getName();
        if (this.fName == null && targName != null) {
            return false;
        }
        if (this.fName != null && targName == null) {
            return false;
        }
        return this.fName == null || targName == null || this.fName.equals(targName);
    }

    protected String createDefaultName() {
        if (sClassIndices == null) {
            sClassIndices = new HashMap();
        }
        String cName = this.getClass().toString();
        Integer index = (Integer)sClassIndices.get(cName = cName.substring(cName.lastIndexOf(".") + 1));
        index = index == null ? new Integer(1) : new Integer(index + 1);
        sClassIndices.put(cName, index);
        return cName + index;
    }

    public void setName(String inName) {
        String oldName = this.fName;
        this.fName = inName;
        this.firePropertyChange(ScienceObjectModel.NAME_PROPERTY, oldName, inName);
    }

    public String getLabel() {
        return this.toString();
    }

    public boolean isTracing() {
        return this.fTracing || sTraceAll;
    }

    public static void setTraceAll(boolean t) {
        sTraceAll = t;
    }

    public void setTracing(boolean onOff) {
        if (!sTraceAll) {
            this.writeDebug(this.getObjectIdString(), "tracing has been turned " + (onOff ? "ON" : "OFF"));
            this.fTracing = onOff;
        }
    }

    public void clearAllListeners() {
        this.fListeners = null;
        sTracers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(ReplaceablePropertyChangeListener listener) {
        AbstractScienceObject abstractScienceObject = this;
        synchronized (abstractScienceObject) {
            ReplaceablePropertyChangeListener[] els = null;
            if (this.fListeners != null) {
                int i = 0;
                while (i < this.fListeners.length) {
                    if (this.fListeners[i] == listener) {
                        return;
                    }
                    ++i;
                }
                int length = this.fListeners.length;
                els = new ReplaceablePropertyChangeListener[length + 1];
                System.arraycopy(this.fListeners, 0, els, 0, length);
            } else {
                els = new ReplaceablePropertyChangeListener[1];
            }
            els[els.length - 1] = listener;
            this.fListeners = els;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(ReplaceablePropertyChangeListener listener) {
        if (this.fListeners == null) {
            return;
        }
        AbstractScienceObject abstractScienceObject = this;
        synchronized (abstractScienceObject) {
            int length = this.fListeners.length;
            int i = 0;
            while (i < this.fListeners.length) {
                if (this.fListeners[i] == listener) {
                    --length;
                }
                ++i;
            }
            if (length == 0) {
                this.fListeners = null;
                return;
            }
            ReplaceablePropertyChangeListener[] els = new ReplaceablePropertyChangeListener[length];
            int nexti = 0;
            int i2 = 0;
            while (i2 < this.fListeners.length) {
                if (this.fListeners[i2] != listener) {
                    els[nexti++] = this.fListeners[i2];
                }
                ++i2;
            }
            this.fListeners = els;
        }
    }

    public static void addEventMonitor(EventMonitor listener) {
        EventMonitor[] els = null;
        if (sMonitors != null) {
            int i = 0;
            while (i < sMonitors.length) {
                if (sMonitors[i] == listener) {
                    return;
                }
                ++i;
            }
            int length = sMonitors.length;
            els = new EventMonitor[length + 1];
            System.arraycopy(sMonitors, 0, els, 0, length);
        } else {
            els = new EventMonitor[1];
        }
        els[els.length - 1] = listener;
        sMonitors = els;
    }

    public static void removeEventMonitor(EventMonitor listener) {
        if (sMonitors == null) {
            return;
        }
        int length = sMonitors.length;
        int i = 0;
        while (i < sMonitors.length) {
            if (sMonitors[i] == listener) {
                --length;
            }
            ++i;
        }
        if (length == 0) {
            sMonitors = null;
            return;
        }
        EventMonitor[] els = new EventMonitor[length];
        int nexti = 0;
        int i2 = 0;
        while (i2 < sMonitors.length) {
            if (sMonitors[i2] != listener) {
                els[nexti++] = sMonitors[i2];
            }
            ++i2;
        }
        sMonitors = els;
    }

    public void notifyEventMonitors(Object target, EventObject event) {
        if (sMonitors != null) {
            int i = 0;
            while (i < sMonitors.length) {
                sMonitors[i].eventFired(this, target, event);
                ++i;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (!ev.getPropertyName().equals(ScienceObjectModel.NAME_PROPERTY)) {
            this.firePropertyChange(this.getName() + "." + ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
        }
    }

    public static void replaceObjectNYI(Object source, ReplacementEvent event) {
        System.err.println("[ERROR] " + source + ": Unimplemented replaceObject call, oldv=" + AbstractScienceObject.getObjectIdString(event.getOldValue()) + " newv=" + AbstractScienceObject.getObjectIdString(event.getNewValue()));
    }

    public void replaceObject(ReplacementEvent ev) throws ReplacementVetoException {
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(propertyName, oldValue, newValue, this.isTracing());
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue, boolean trace) {
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (oldValue == null && newValue == null) {
            return;
        }
        ReplaceablePropertyChangeListener[] localListeners = this.fListeners;
        if (localListeners == null) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        if (trace) {
            this.writeDebug(debugIndent + AbstractScienceObject.getObjectIdString(this) + ".firepropertyChange", propertyName);
            debugIndent = debugIndent + "  ";
        }
        int i = 0;
        while (i < localListeners.length) {
            ReplaceablePropertyChangeListener target = localListeners[i];
            if (trace) {
                this.writeDebug(debugIndent, AbstractScienceObject.getObjectIdString(target));
            }
            try {
                this.notifyEventMonitors(target, evt);
                target.propertyChange(evt);
            }
            catch (ReplaceablePropertyVetoException ex) {
                this.writeError(this, "Unexpected ReplaceablePropertyVetoException returned and ignored, " + ex.toString());
            }
            ++i;
        }
        if (trace) {
            debugIndent = debugIndent.substring(2);
        }
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws ReplaceablePropertyVetoException {
        this.fireVetoableChange(propertyName, oldValue, newValue, this.isTracing());
    }

    /*
     * Unable to fully structure code
     */
    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue, boolean trace) throws ReplaceablePropertyVetoException {
        eSource = this;
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (oldValue == null && newValue == null) {
            return;
        }
        localListeners = this.fListeners;
        if (localListeners == null) {
            return;
        }
        evt = new PropertyChangeEvent(eSource, propertyName, oldValue, newValue);
        i = 0;
        while (i < localListeners.length) {
            block11: {
                target = localListeners[i];
                if (trace) {
                    this.writeDebug("    calling", AbstractScienceObject.getObjectIdString(target) + ".propertyChange");
                }
                try {
                    target.propertyChange(evt);
                    break block11;
                }
                catch (ReplaceablePropertyVetoException ex) {
                    reverseEvent = new PropertyChangeEvent(eSource, propertyName, newValue, oldValue);
                    i2 = i - 1;
                    ** while (i2 >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    reverseTarget = localListeners[i2];
                    if (trace) {
                        this.writeDebug("    reversing", AbstractScienceObject.getObjectIdString(reverseTarget) + ".propertyChange");
                    }
                    try {
                        reverseTarget.propertyChange(reverseEvent);
                    }
                    catch (ReplaceablePropertyVetoException ex2) {
                        this.writeError(this, "Unexpected ReplaceablePropertyVetoException returned and ignored, " + ex2.toString());
                    }
                    --i2;
                    continue;
                }
lbl32:
                // 1 sources

                throw ex;
            }
            ++i;
        }
    }

    public void fireReplaceObject(Object oldObject, Object newObject) throws ReplacementVetoException {
        this.fireReplaceObject(oldObject, newObject, this.isTracing());
    }

    public void fireReplaceObject(ReplaceablePropertyChangeListener newObject) throws ReplacementVetoException {
        this.fireReplaceObject(this, newObject, this.isTracing());
    }

    public void fireReplaceObject(Object oldObject, Object newObject, boolean trace) throws ReplacementVetoException {
        block13: {
            if (oldObject == newObject) {
                return;
            }
            if (oldObject == null && newObject == null) {
                return;
            }
            ReplaceablePropertyChangeListener[] localListeners = this.fListeners;
            if (localListeners == null) {
                return;
            }
            Object target = null;
            int i = 0;
            if (trace) {
                this.writeDebug(replaceIndent + AbstractScienceObject.getObjectIdString(this) + ".fireReplaceObject", "old=" + AbstractScienceObject.getObjectIdString(oldObject) + ",new=" + AbstractScienceObject.getObjectIdString(newObject));
                replaceIndent = replaceIndent + "  ";
            }
            try {
                ReplacementEvent evt = new ReplacementEvent(oldObject, newObject);
                i = 0;
                while (i < localListeners.length) {
                    target = localListeners[i];
                    if (trace) {
                        this.writeDebug(replaceIndent, AbstractScienceObject.getObjectIdString(target));
                    }
                    this.notifyEventMonitors(target, evt);
                    target.replaceObject(evt);
                    ++i;
                }
                break block13;
            }
            catch (ReplacementVetoException ex) {
                this.writeDebug(this, "ReplacementVetoException trapped in replaceObject, from " + target.toString());
                try {
                    ReplacementEvent reverseEvt = new ReplacementEvent(newObject, oldObject);
                    int j = i - 1;
                    while (j >= 0) {
                        target = localListeners[j];
                        if (target instanceof ReplaceablePropertyChangeListener) {
                            this.notifyEventMonitors(target, reverseEvt);
                            target.replaceObject(reverseEvt);
                        }
                        --j;
                    }
                }
                catch (ReplacementVetoException ex2) {
                    // empty catch block
                }
            }
            throw ex;
        }
        if (trace) {
            replaceIndent = replaceIndent.substring(2);
        }
    }

    protected void writeDebug(Object source, Object message) {
        if (showDebug) {
            System.err.println("[DEBUG] " + source + ": " + message);
        }
    }

    protected void writeError(Object source, Object message) {
        System.err.println("[ERROR] " + source + ": " + message);
    }

    public String getObjectIdString() {
        return AbstractScienceObject.getObjectIdString(this);
    }

    public static String getObjectIdString(Object obj) {
        String retval;
        if (obj == null) {
            retval = "<null>";
        } else {
            retval = obj.getClass().toString() + "@" + Integer.toHexString(obj.hashCode());
            String gov = "class ";
            int idx = gov.length();
            if (retval.indexOf(gov) >= 0) {
                retval = retval.substring(idx, retval.length());
            }
        }
        return retval;
    }

    static {
        sTracers = null;
        sClassIndices = null;
        sTraceAll = false;
        debugIndent = "";
        replaceIndent = "";
        showDebug = false;
    }

    public static interface EventMonitor {
        public void eventFired(Object var1, Object var2, EventObject var3);
    }
}

