/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jsky.science.MathUtilities;
import jsky.science.Quantity;
import jsky.science.UnitsNotSupportedException;
import jsky.science.Wavelength;
import jsky.science.Wavelength1DArray;
import jsky.science.Wavelength1DModel;

public class Flux
extends Quantity {
    private static final long serialVersionUID = 42L;
    public static final String DEFAULTUNITS_PROPERTY = "defaultFluxUnit".intern();
    public static final String FNU = "fnu (ergs/s/cm^2/hz)";
    public static final String FNUABBREV = "fnu";
    public static final String FLAM = "flam (ergs/s/cm^2/" + Wavelength.ANGSTROMABBREV + ")";
    public static final String FLAMABBREV = "flam";
    public static final String PHOTNU = "photnu (photons/s/cm^2/hz)";
    public static final String PHOTNUABBREV = "photnu";
    public static final String PHOTLAM = "photlam (ergs/s/cm^2/" + Wavelength.ANGSTROMABBREV + ")";
    public static final String PHOTLAMABBREV = "photlam";
    public static final String ABMAG = "abmag";
    public static final String ABMAGABBREV = "abmag";
    public static final String STMAG = "stmag";
    public static final String STMAGABBREV = "stmag";
    public static final String JY = "jy (10^23 ergs/s/cm^2/Hz";
    public static final String JYABBREV = "jy";
    public static final String MJY = "mjy (10^26 ergs/s/cm^2/Hz";
    public static final String MJYABBREV = "mjy";
    public static final String COUNTS = "counts (detected counts/s/arcsec/dlambda)";
    public static final String COUNTSABBREV = "counts";
    public static final String OBMAG = "obmag";
    public static final String OBMAGABBREV = "obmag";
    public static final String VEGAMAG = "vegamag";
    public static final String VEGAMAGABBREV = "vegamag";
    static /* synthetic */ Class class$jsky$science$Flux;
    static /* synthetic */ Class class$jsky$science$Wavelength;

    public Flux() {
        this(0.0);
    }

    public Flux(double inValue) {
        this(inValue, Quantity.getDefaultUnits(class$jsky$science$Flux == null ? (class$jsky$science$Flux = Flux.class$("jsky.science.Flux")) : class$jsky$science$Flux));
    }

    public Quantity newInstance(double inValue) {
        return new Flux(inValue);
    }

    public Flux(double inValue, String inUnits) {
    }

    public double getValue(String unitsName) {
        throw new UnsupportedOperationException();
    }

    protected void setValue(double inValue, String unitsName) {
        throw new UnsupportedOperationException();
    }

    public static Wavelength1DArray convertWavelength1DModel(Wavelength1DModel inArray, String fromUnits, String toUnits) throws UnitsNotSupportedException {
        return Flux.convertWavelength1DModel(inArray, fromUnits, toUnits, Double.NaN);
    }

    public static Wavelength1DArray convertWavelength1DModel(Wavelength1DModel inArray, String fromUnits, String toUnits, double mirrorArea) throws UnitsNotSupportedException {
        double[] waves = inArray.toArrayWavelengths(null, null, 0, Wavelength.ANGSTROM);
        double[] invalues = inArray.toArrayData(waves);
        double[] tmpvalues = Flux.convertArray(waves, invalues, fromUnits, PHOTLAM, mirrorArea);
        double[] outvalues = Flux.convertArray(waves, invalues, PHOTLAM, toUnits, mirrorArea);
        Wavelength1DArray returnArray = new Wavelength1DArray(new Wavelength(waves[0], Wavelength.ANGSTROM), new Wavelength(waves[waves.length - 1], Wavelength.ANGSTROM), waves.length);
        if (Wavelength.getDefaultUnits(class$jsky$science$Wavelength == null ? (class$jsky$science$Wavelength = Flux.class$("jsky.science.Wavelength")) : class$jsky$science$Wavelength).equals(Wavelength.ANGSTROM)) {
            int i = 0;
            while (i < waves.length) {
                returnArray.setWavelengthAtIndex(i, waves[i]);
                returnArray.setValueAtIndex(i, outvalues[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < waves.length) {
                returnArray.setWavelengthAtIndex(i, new Wavelength(waves[i], Wavelength.ANGSTROM));
                returnArray.setValueAtIndex(i, outvalues[i]);
                ++i;
            }
        }
        return returnArray;
    }

    private static double[] convertArray(double[] wave, double[] inval, String fromUnits, String toUnits, double mirrorArea) throws UnitsNotSupportedException {
        if (fromUnits.equalsIgnoreCase(PHOTLAM) && toUnits.equalsIgnoreCase(PHOTLAM)) {
            return inval;
        }
        double[] outval = new double[wave.length];
        double ABZERO = -48.6;
        double STZERO = -21.1;
        int i = 0;
        while (i < wave.length) {
            double dwave;
            if (toUnits.equalsIgnoreCase(PHOTLAM)) {
                if (fromUnits.equalsIgnoreCase(COUNTS)) {
                    dwave = 0.0;
                    dwave = i == 0 ? Math.abs(wave[i + 1] - wave[i]) : (i == wave.length - 1 ? Math.abs(wave[i] - wave[i - 1]) : Math.abs(wave[i + 1] - wave[i - 1]) / 2.0);
                    outval[i] = inval[i] / (dwave * mirrorArea);
                } else if (fromUnits.equalsIgnoreCase(FLAM)) {
                    outval[i] = wave[i] * inval[i] / 1.986447461038579E-25;
                } else if (fromUnits.equalsIgnoreCase(FNU)) {
                    outval[i] = inval[i] / wave[i] / 6.6260755E-34;
                } else if (fromUnits.equalsIgnoreCase(PHOTNU)) {
                    outval[i] = 2.99792458E8 * inval[i] / wave[i] * wave[i];
                } else if (fromUnits.equalsIgnoreCase(JY)) {
                    outval[i] = 1.5091889610977116E10 * inval[i] / wave[i];
                } else if (fromUnits.equalsIgnoreCase(MJY)) {
                    outval[i] = 1.5091889610977117E7 * inval[i] / wave[i];
                } else if (fromUnits.equalsIgnoreCase("abmag")) {
                    outval[i] = 1.5091889610977116E33 / wave[i] * Math.pow(10.0, -0.4 * (inval[i] - ABZERO));
                } else if (fromUnits.equalsIgnoreCase("stmag")) {
                    outval[i] = 3.3356409519815204E-9 * wave[i] * Math.pow(10.0, -0.4 * (inval[i] - STZERO));
                } else {
                    if (fromUnits.equalsIgnoreCase("vegamag")) {
                        throw new UnitsNotSupportedException(toUnits);
                    }
                    if (fromUnits.equalsIgnoreCase("obmag")) {
                        dwave = 0.0;
                        dwave = i == 0 ? Math.abs(wave[i + 1] - wave[i]) : (i == wave.length - 1 ? Math.abs(wave[i] - wave[i - 1]) : Math.abs(wave[i + 1] - wave[i - 1]) / 2.0);
                        outval[i] = Math.pow(10.0, -0.4 * inval[i] / (dwave * mirrorArea));
                    }
                }
            } else if (fromUnits.equalsIgnoreCase(PHOTLAM)) {
                if (toUnits.equalsIgnoreCase(COUNTS)) {
                    dwave = 0.0;
                    dwave = i == 0 ? Math.abs(wave[i + 1] - wave[i]) : (i == wave.length - 1 ? Math.abs(wave[i] - wave[i - 1]) : Math.abs(wave[i + 1] - wave[i - 1]) / 2.0);
                    outval[i] = inval[i] * dwave * mirrorArea;
                } else if (toUnits.equalsIgnoreCase(FLAM)) {
                    outval[i] = 1.986447461038579E-25 * inval[i] / wave[i];
                } else if (toUnits.equalsIgnoreCase(FNU)) {
                    outval[i] = 6.6260755E-34 * inval[i] * wave[i];
                } else if (toUnits.equalsIgnoreCase(PHOTNU)) {
                    outval[i] = inval[i] * wave[i] * wave[i] / 2.99792458E8;
                } else if (toUnits.equalsIgnoreCase(JY)) {
                    outval[i] = 6.626075499999999E-11 * inval[i] * wave[i];
                } else if (toUnits.equalsIgnoreCase(MJY)) {
                    outval[i] = 6.6260755E-8 * inval[i] * wave[i];
                } else if (toUnits.equalsIgnoreCase("abmag")) {
                    outval[i] = inval[i] <= 0.0 ? 100.0 : -2.5 * MathUtilities.antilog10(inval[i]) + ABZERO;
                } else if (toUnits.equalsIgnoreCase("stmag")) {
                    outval[i] = inval[i] <= 0.0 ? 100.0 : -2.5 * MathUtilities.antilog10(inval[i]) + STZERO;
                } else {
                    if (toUnits.equalsIgnoreCase("vegamag")) {
                        throw new UnitsNotSupportedException(toUnits);
                    }
                    if (toUnits.equalsIgnoreCase("obmag")) {
                        dwave = 0.0;
                        if (inval[i] <= 0.0) {
                            outval[i] = 100.0;
                        } else {
                            dwave = i == 0 ? Math.abs(wave[i + 1] - wave[i]) : (i == wave.length - 1 ? Math.abs(wave[i] - wave[i - 1]) : Math.abs(wave[i + 1] - wave[i - 1]) / 2.0);
                            outval[i] = -2.5 * MathUtilities.antilog10(inval[i] + dwave * mirrorArea);
                        }
                    }
                }
            }
            ++i;
        }
        return outval;
    }

    public static void addDefaultUnitsChangeListener(PropertyChangeListener listener) {
        Quantity.addDefaultUnitsChangeListener(class$jsky$science$Flux == null ? (class$jsky$science$Flux = Flux.class$("jsky.science.Flux")) : class$jsky$science$Flux, listener);
    }

    public static void removeDefaultUnitsChangeListener(PropertyChangeListener listener) {
        Quantity.removeDefaultUnitsChangeListener(class$jsky$science$Flux == null ? (class$jsky$science$Flux = Flux.class$("jsky.science.Flux")) : class$jsky$science$Flux, listener);
    }

    public static String getDefaultUnitsAbbrev() {
        return Quantity.getDefaultUnitsAbbrev(class$jsky$science$Flux == null ? (class$jsky$science$Flux = Flux.class$("jsky.science.Flux")) : class$jsky$science$Flux);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ArrayList<String> unitNames = new ArrayList<String>();
        unitNames.add(FLAM);
        unitNames.add(FNU);
        unitNames.add(PHOTNU);
        unitNames.add(PHOTLAM);
        unitNames.add(COUNTS);
        unitNames.add("abmag");
        unitNames.add("stmag");
        unitNames.add("obmag");
        unitNames.add("vegamag");
        unitNames.add(JY);
        unitNames.add(MJY);
        ArrayList<String> unitAbbrev = new ArrayList<String>();
        unitAbbrev.add(FLAMABBREV);
        unitAbbrev.add(FNUABBREV);
        unitAbbrev.add(PHOTNUABBREV);
        unitAbbrev.add(PHOTLAMABBREV);
        unitAbbrev.add(COUNTSABBREV);
        unitAbbrev.add("abmag");
        unitAbbrev.add("stmag");
        unitAbbrev.add("obmag");
        unitAbbrev.add("vegamag");
        unitAbbrev.add(JYABBREV);
        unitAbbrev.add(MJYABBREV);
        Quantity.initializeSubClass(class$jsky$science$Flux == null ? (class$jsky$science$Flux = Flux.class$("jsky.science.Flux")) : class$jsky$science$Flux, unitNames, unitAbbrev, PHOTLAM, DEFAULTUNITS_PROPERTY);
    }
}

