/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

public class MrqFit {
    private static final int _MMA = 16;
    static float[] atry = new float[16];
    static double[] da = new double[16];
    static double[] oneda = new double[16];
    static double[] beta = new double[16];
    static double[] cv = new double[256];
    static double ochisq;

    public static int mrqmin(int ndata, float[] a, int ma, int[] lista, int mfit, double[] covar, double[] alpha, double[] chisq, MrqFunc funcs, double[] alamda) {
        int k;
        int j;
        if (alamda[0] < 0.0) {
            if (16 < ma || ma < mfit) {
                return -3;
            }
            int kk = mfit;
            j = 0;
            while (j < ma) {
                int ihit = 0;
                k = 0;
                while (k < mfit) {
                    if (lista[k] == j) {
                        ++ihit;
                    }
                    ++k;
                }
                if (ihit == 0) {
                    lista[kk++] = j;
                } else if (ihit > 1) {
                    return -1;
                }
                ++j;
            }
            if (kk != ma) {
                return -2;
            }
            alamda[0] = 0.001;
            MrqFit._mrqcof(ndata, a, ma, lista, mfit, alpha, beta, chisq, funcs);
            if (chisq[0] <= 0.0) {
                return -4;
            }
            ochisq = chisq[0];
        }
        j = 0;
        while (j < mfit) {
            k = 0;
            while (k < mfit) {
                double d = alpha[j + k * ma];
                MrqFit.cv[j + k * mfit] = d;
                covar[j + k * ma] = d;
                ++k;
            }
            double d = alpha[j + j * ma] * (1.0 + alamda[0]);
            MrqFit.cv[j + j * mfit] = d;
            covar[j + j * ma] = d;
            MrqFit.oneda[j] = beta[j];
            ++j;
        }
        if (MrqFit._gaussj(cv, mfit, oneda, 1) != 0) {
            return -5;
        }
        j = 0;
        while (j < mfit) {
            MrqFit.da[j] = oneda[j];
            ++j;
        }
        if (alamda[0] == 0.0) {
            j = 0;
            while (j < mfit) {
                k = 0;
                while (k < mfit) {
                    covar[j + k * ma] = cv[j + k * mfit];
                    ++k;
                }
                ++j;
            }
            MrqFit._covsrt(covar, ma, lista, mfit);
            return 0;
        }
        j = 0;
        while (j < ma) {
            MrqFit.atry[j] = a[j];
            ++j;
        }
        j = 0;
        while (j < mfit) {
            MrqFit.atry[lista[j]] = (float)((double)a[lista[j]] + da[j]);
            ++j;
        }
        MrqFit._mrqcof(ndata, atry, ma, lista, mfit, covar, da, chisq, funcs);
        if (0.0 < chisq[0] && chisq[0] < ochisq) {
            alamda[0] = alamda[0] * 0.1;
            ochisq = chisq[0];
            j = 0;
            while (j < mfit) {
                k = 0;
                while (k < mfit) {
                    alpha[j + k * ma] = covar[j + k * ma];
                    ++k;
                }
                MrqFit.beta[j] = da[j];
                a[lista[j]] = atry[lista[j]];
                ++j;
            }
        } else {
            alamda[0] = alamda[0] * 10.0;
            chisq[0] = ochisq;
        }
        return 0;
    }

    private static void _mrqcof(int ndata, float[] a, int ma, int[] lista, int mfit, double[] alpha, double[] veta, double[] chisq, MrqFunc funcs) {
        int k;
        float[] y = new float[1];
        float[] ymod = new float[1];
        float[] sig2i = new float[1];
        float[] dyda = new float[16];
        int j = 0;
        while (j < mfit) {
            k = 0;
            while (k <= j) {
                alpha[j + k * ma] = 0.0;
                ++k;
            }
            veta[j] = 0.0;
            ++j;
        }
        chisq[0] = 0.0;
        int i = 0;
        while (i < ndata) {
            if (funcs.mrqFunc(i, y, ymod, sig2i, a, dyda, ma) == 0) {
                float dy = y[0] - ymod[0];
                j = 0;
                while (j < mfit) {
                    float wt = dyda[lista[j]] * sig2i[0];
                    k = 0;
                    while (k <= j) {
                        int n = j + k * ma;
                        alpha[n] = alpha[n] + (double)(wt * dyda[lista[k]]);
                        ++k;
                    }
                    int n = j++;
                    veta[n] = veta[n] + (double)(dy * wt);
                }
                chisq[0] = chisq[0] + (double)(dy * dy * sig2i[0]);
            }
            ++i;
        }
        j = 1;
        while (j < mfit) {
            k = 0;
            while (k < j) {
                alpha[k + j * ma] = alpha[j + k * ma];
                ++k;
            }
            ++j;
        }
    }

    private static void _covsrt(double[] covar, int ma, int[] lista, int mfit) {
        int i;
        int j = 0;
        while (j < ma - 1) {
            i = j + 1;
            while (i < ma) {
                covar[i + j * ma] = 0.0;
                ++i;
            }
            ++j;
        }
        i = 0;
        while (i < mfit - 1) {
            j = i + 1;
            while (j < mfit) {
                if (lista[j] > lista[i]) {
                    covar[lista[j] + lista[i] * ma] = covar[i + j * ma];
                } else {
                    covar[lista[i] + lista[j] * ma] = covar[i + j * ma];
                }
                ++j;
            }
            ++i;
        }
        double swap = covar[0];
        j = 0;
        while (j < ma) {
            covar[j * ma] = covar[j + j * ma];
            covar[j + j * ma] = 0.0;
            ++j;
        }
        covar[lista[0] + lista[0] * ma] = swap;
        j = 1;
        while (j < mfit) {
            covar[lista[j] + lista[j] * ma] = covar[j * ma];
            ++j;
        }
        j = 1;
        while (j < ma) {
            i = 0;
            while (i < j) {
                covar[i + j * ma] = covar[j + i * ma];
                ++i;
            }
            ++j;
        }
    }

    private static void _swap(double[] ar, int a, int b) {
        double temp = ar[a];
        ar[a] = ar[b];
        ar[b] = temp;
    }

    private static int _gaussj(double[] a, int n, double[] b, int m) {
        int l;
        int k;
        int icol = 0;
        int irow = 0;
        int[] indxc = new int[16];
        int[] indxr = new int[16];
        int[] ipiv = new int[16];
        if (16 < n) {
            return -3;
        }
        int j = 0;
        while (j < n) {
            ipiv[j] = 0;
            ++j;
        }
        int i = 0;
        while (i < n) {
            double dum;
            double big = 0.0;
            j = 0;
            while (j < n) {
                if (ipiv[j] != 1) {
                    k = 0;
                    while (k < n) {
                        if (ipiv[k] == 0) {
                            dum = Math.abs(a[j + k * n]);
                            if (dum >= big) {
                                big = dum;
                                irow = j;
                                icol = k;
                            }
                        } else if (ipiv[k] > 1) {
                            return -1;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                l = 0;
                while (l < n) {
                    MrqFit._swap(a, irow + l * n, icol + l * n);
                    ++l;
                }
                l = 0;
                while (l < m) {
                    MrqFit._swap(b, irow + l * n, icol + l * n);
                    ++l;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a[icol + icol * n] == 0.0) {
                return -2;
            }
            double pivinv = 1.0 / a[icol + icol * n];
            a[icol + icol * n] = 1.0;
            l = 0;
            while (l < n) {
                int n3 = icol + l * n;
                a[n3] = a[n3] * pivinv;
                ++l;
            }
            l = 0;
            while (l < m) {
                int n4 = icol + l * n;
                b[n4] = b[n4] * pivinv;
                ++l;
            }
            int ll = 0;
            while (ll < n) {
                if (ll != icol) {
                    dum = a[ll + icol * n];
                    a[ll + icol * n] = 0.0;
                    l = 0;
                    while (l < n) {
                        int n5 = ll + l * n;
                        a[n5] = a[n5] - a[icol + l * n] * dum;
                        ++l;
                    }
                    l = 0;
                    while (l < m) {
                        int n6 = ll + l * n;
                        b[n6] = b[n6] - b[icol + l * n] * dum;
                        ++l;
                    }
                }
                ++ll;
            }
            ++i;
        }
        l = n - 1;
        while (l >= 0) {
            if (indxr[l] != indxc[l]) {
                k = 0;
                while (k < n) {
                    MrqFit._swap(a, k + indxr[l] * n, k + indxc[l] * n);
                    ++k;
                }
            }
            --l;
        }
        return 0;
    }

    public static interface MrqFunc {
        public int mrqFunc(int var1, float[] var2, float[] var3, float[] var4, float[] var5, float[] var6, int var7);
    }
}

