/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jsky.science.Quantity;
import jsky.science.UnitsNotSupportedException;

public class Redshift
extends Quantity {
    private static final long serialVersionUID = 662600968082910788L;
    public static final String DEFAULTUNITS_PROPERTY = "defaultRedshiftUnit".intern();
    public static final String Z = "Z".intern();
    public static final String RADIALVELOCITY = "RadialVelocity".intern();
    public static final String PARSEC = "Parsec".intern();
    public static final String ASTRONOMICALUNIT = "AstronomicalUnit".intern();
    public static final String DISTANCEMODULUS = "DistanceModulus".intern();
    public static final String ZABBREV = "z".intern();
    public static final String RADIALVELOCITYABBREV = "km/s".intern();
    public static final String PARSECABBREV = "pc".intern();
    public static final String ASTRONOMICALUNITABBREV = "au".intern();
    public static final String DISTANCEMODULUSABBREV = "dm".intern();
    private static final double ParsecMeters = 3.0857E16;
    private static final double AUMeters = 1.496E11;
    static /* synthetic */ Class class$jsky$science$Redshift;

    public static void main(String[] args) {
        System.out.println("z=.0033412 to RadV: " + new Redshift(0.0033412, Z).getValue(RADIALVELOCITY));
        System.out.println("1000 radV to z: " + new Redshift(1000.0, RADIALVELOCITY).getValue(Z));
        System.out.println("1 here and back, z: " + new Redshift(1.0, Z).getValue(Z));
        System.out.println("1 here and back, rv: " + new Redshift(1.0, RADIALVELOCITY).getValue(RADIALVELOCITY));
        System.exit(0);
    }

    public Redshift() {
        this(0.0);
    }

    public Redshift(double inValue) {
        this(inValue, Quantity.getDefaultUnits(class$jsky$science$Redshift == null ? (class$jsky$science$Redshift = Redshift.class$("jsky.science.Redshift")) : class$jsky$science$Redshift));
    }

    public Quantity newInstance(double inValue) {
        return new Redshift(inValue);
    }

    public Redshift(double inValue, String inUnits) {
        this.setValue(inValue, inUnits);
    }

    public double getValue(String unitsName) {
        try {
            return Redshift.convert(this.fValue, Z, unitsName);
        }
        catch (UnitsNotSupportedException e) {
            this.writeError(this, e.toString());
            return Double.NaN;
        }
    }

    protected void setValue(double inValue, String unitsName) {
        try {
            this.fValue = Redshift.convert(inValue, unitsName, Z);
        }
        catch (UnitsNotSupportedException e) {
            this.writeError(this, e.toString());
            this.fValue = Double.NaN;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double convert(double inVal, String fromUnits, String toUnits) throws UnitsNotSupportedException {
        double outVal = Double.NaN;
        if (fromUnits.equalsIgnoreCase(Z)) {
            if (toUnits.equalsIgnoreCase(Z)) {
                return inVal;
            }
            if (!toUnits.equalsIgnoreCase(RADIALVELOCITY)) throw new UnitsNotSupportedException(toUnits);
            double zplus1sq = Math.pow(inVal + 1.0, 2.0);
            double mps = 2.99792458E8 * (zplus1sq - 1.0) / (zplus1sq + 1.0);
            return mps / 1000.0;
        }
        if (toUnits.equalsIgnoreCase(Z)) {
            if (fromUnits.equalsIgnoreCase(Z)) {
                return inVal;
            }
            if (!fromUnits.equalsIgnoreCase(RADIALVELOCITY)) throw new UnitsNotSupportedException(fromUnits);
            double vdivc = inVal * 1000.0 / 2.99792458E8;
            return Math.pow((1.0 + vdivc) / (1.0 - vdivc), 0.5) - 1.0;
        }
        double tmpVal = Redshift.convert(inVal, fromUnits, Z);
        return Redshift.convert(tmpVal, Z, toUnits);
    }

    public static void addDefaultUnitsChangeListener(PropertyChangeListener listener) {
        Quantity.addDefaultUnitsChangeListener(class$jsky$science$Redshift == null ? (class$jsky$science$Redshift = Redshift.class$("jsky.science.Redshift")) : class$jsky$science$Redshift, listener);
    }

    public static void removeDefaultUnitsChangeListener(PropertyChangeListener listener) {
        Quantity.removeDefaultUnitsChangeListener(class$jsky$science$Redshift == null ? (class$jsky$science$Redshift = Redshift.class$("jsky.science.Redshift")) : class$jsky$science$Redshift, listener);
    }

    public static String getDefaultUnitsAbbrev() {
        return Quantity.getDefaultUnitsAbbrev(class$jsky$science$Redshift == null ? (class$jsky$science$Redshift = Redshift.class$("jsky.science.Redshift")) : class$jsky$science$Redshift);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ArrayList<String> unitNames = new ArrayList<String>();
        unitNames.add(Z);
        unitNames.add(RADIALVELOCITY);
        ArrayList<String> unitAbbrev = new ArrayList<String>();
        unitAbbrev.add(ZABBREV);
        unitAbbrev.add(RADIALVELOCITYABBREV);
        Quantity.initializeSubClass(class$jsky$science$Redshift == null ? (class$jsky$science$Redshift = Redshift.class$("jsky.science.Redshift")) : class$jsky$science$Redshift, unitNames, unitAbbrev, Z, DEFAULTUNITS_PROPERTY);
    }
}

