/*
 * Decompiled with CFR 0.152.
 */
package jsky.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.text.DecimalFormat;
import jsky.science.Time;
import jsky.timeline.DefaultVetoableTimeLineNodeModel;
import jsky.timeline.DetailedPropertyVetoException;
import jsky.timeline.TimeLine;
import jsky.timeline.TimeLineNode;
import jsky.timeline.TimeLineNodeModel;

public class BlockTimeLineNode
implements TimeLineNode {
    private static float sThumbHeight = 12.0f;
    protected VetoableChangeSupport fChangeSupport = null;
    private DefaultVetoableTimeLineNodeModel fModel;
    private Color fUnselectedColor = Color.gray;
    private float fThumbBegin = 0.0f;
    private float fThumbEnd = 0.0f;
    private BasicStroke fDefaultStroke = new BasicStroke();
    private BasicStroke fShadowStroke = new BasicStroke(1.0f);
    private Line2D.Float fThumbShadowLine = new Line2D.Float();
    private Line2D.Float fThumbTopShadowLine = new Line2D.Float();
    private Line2D.Float fThumbRightShadowLine = new Line2D.Float();
    private Line2D.Float fThumbLeftShadowLine = new Line2D.Float();
    private TimeLine fTimeLine = null;
    protected Rectangle2D.Float fThumb = new Rectangle2D.Float();

    public BlockTimeLineNode(Time start, Time end) {
        this(start, end, "unknown");
    }

    public BlockTimeLineNode(Time startTime, Time endTime, String name) {
        this.fModel = new DefaultVetoableTimeLineNodeModel(startTime, endTime, name, true);
        this.fChangeSupport = new VetoableChangeSupport(this);
        this.fModel.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                BlockTimeLineNode.this.fChangeSupport.fireVetoableChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public void setSelectionMode(int mode) {
    }

    public int getSelectionMode() {
        return 0;
    }

    public void setUnselectedColor(Color color) {
        block3: {
            if (color == this.fUnselectedColor) break block3;
            Color oldColor = this.fUnselectedColor;
            try {
                this.fUnselectedColor = color;
                this.fChangeSupport.fireVetoableChange("UnselectedColor", oldColor, color);
            }
            catch (DetailedPropertyVetoException ex) {
                this.fUnselectedColor = oldColor;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Color getUnselectedColor() {
        return this.fUnselectedColor;
    }

    public void setSelectedColor(Color color) {
    }

    public Color getSelectedColor() {
        return null;
    }

    public Time getStartTime() {
        return this.fModel.getStartTime();
    }

    public void setStartTime(Time time) throws DetailedPropertyVetoException {
        try {
            this.fModel.setValidStartTime(time);
        }
        catch (DetailedPropertyVetoException ex) {
            this.calculateNodeDimensions();
            throw ex;
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public void moveTimeLineNodeBy(Time time) throws DetailedPropertyVetoException {
        try {
            this.fModel.moveTimeLineNodeByValid(time);
        }
        catch (DetailedPropertyVetoException ex) {
            this.calculateNodeDimensions();
            throw ex;
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public Time getEndTime() {
        return this.fModel.getEndTime();
    }

    public void setEndTime(Time time) throws DetailedPropertyVetoException {
        try {
            this.fModel.setValidEndTime(time);
        }
        catch (DetailedPropertyVetoException ex) {
            this.calculateNodeDimensions();
            throw ex;
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public Time getDuration() {
        return this.fModel.getDuration();
    }

    public void setDuration(Time durationLength) throws DetailedPropertyVetoException {
        try {
            this.fModel.setValidDuration(durationLength);
        }
        catch (DetailedPropertyVetoException ex) {
            this.calculateNodeDimensions();
            throw ex;
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public void paintTimeLineNode(Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font origFont = graphics.getFont();
        Time startTime = this.fModel.getStartTime();
        Time endTime = this.fModel.getEndTime();
        if (!(startTime.getValue(Time.SECOND) > this.fTimeLine.getDisplayEnd().getValue(Time.SECOND)) && !(endTime.getValue(Time.SECOND) < this.fTimeLine.getDisplayStart().getValue(Time.SECOND))) {
            this.calculateNodeDimensions();
            float thumbWidth = this.fThumbEnd - this.fThumbBegin;
            this.fThumb.height = sThumbHeight;
            this.fThumb.width = thumbWidth;
            this.fThumb.x = this.fThumbBegin;
            this.fThumb.y = (float)this.fTimeLine.getHeight() / 2.0f - sThumbHeight / 2.0f;
            graphics.setStroke(this.fDefaultStroke);
            graphics.setColor(this.fUnselectedColor);
            graphics.draw(this.fThumb);
            graphics.fill(this.fThumb);
            this.fThumbShadowLine.x1 = this.fThumb.x;
            this.fThumbShadowLine.y1 = this.fThumb.y + sThumbHeight;
            this.fThumbShadowLine.x2 = this.fThumb.x + thumbWidth;
            this.fThumbShadowLine.y2 = this.fThumb.y + sThumbHeight;
            graphics.setStroke(this.fShadowStroke);
            graphics.setColor(Color.black);
            graphics.draw(this.fThumbShadowLine);
            this.fThumbTopShadowLine.x1 = this.fThumb.x;
            this.fThumbTopShadowLine.y1 = this.fThumb.y;
            this.fThumbTopShadowLine.x2 = this.fThumb.x + thumbWidth;
            this.fThumbTopShadowLine.y2 = this.fThumb.y;
            graphics.setStroke(this.fShadowStroke);
            graphics.setColor(Color.white);
            graphics.draw(this.fThumbTopShadowLine);
            this.fThumbLeftShadowLine.x1 = this.fThumb.x;
            this.fThumbLeftShadowLine.y1 = this.fThumb.y;
            this.fThumbLeftShadowLine.x2 = this.fThumb.x;
            this.fThumbLeftShadowLine.y2 = this.fThumb.y + sThumbHeight;
            graphics.setStroke(this.fShadowStroke);
            graphics.setColor(Color.lightGray);
            graphics.draw(this.fThumbLeftShadowLine);
            this.fThumbRightShadowLine.x1 = this.fThumb.x + thumbWidth;
            this.fThumbRightShadowLine.y1 = this.fThumb.y;
            this.fThumbRightShadowLine.x2 = this.fThumb.x + thumbWidth;
            this.fThumbRightShadowLine.y2 = this.fThumb.y + sThumbHeight;
            graphics.setStroke(this.fShadowStroke);
            graphics.setColor(Color.black);
            graphics.draw(this.fThumbRightShadowLine);
            DecimalFormat startForm = new DecimalFormat();
            startForm.setMaximumFractionDigits(1);
            if (startTime.getValue() > this.fTimeLine.getDisplayStart().getValue()) {
                graphics.setFont(TimeLineNode.DEFAULT_FONT);
                String startStr = startForm.format(startTime.getValue(Time.MINUTE));
                Rectangle2D startBounds = graphics.getFontMetrics().getStringBounds(startStr, graphics);
                graphics.setColor(Color.black);
                float startX = this.fThumb.x - (float)(startBounds.getWidth() / 2.0);
                float startY = this.fThumb.y + sThumbHeight + (float)(startBounds.getHeight() + 2.0);
                if (startBounds.getWidth() > (double)(thumbWidth / 2.0f)) {
                    graphics.setFont(TimeLineNode.REVERSE_ROTATED_FONT);
                }
                graphics.drawString(startStr, startX, startY);
                graphics.setFont(origFont);
            }
            if (endTime.getValue() < this.fTimeLine.getDisplayEnd().getValue()) {
                graphics.setFont(TimeLineNode.DEFAULT_FONT);
                DecimalFormat endForm = new DecimalFormat();
                endForm.setMaximumFractionDigits(1);
                String endStr = startForm.format(endTime.getValue(Time.MINUTE));
                Rectangle2D endBounds = graphics.getFontMetrics().getStringBounds(endStr, graphics);
                graphics.setColor(Color.black);
                float endX = this.fThumb.x + thumbWidth - (float)(endBounds.getWidth() / 2.0);
                float endY = this.fThumb.y + sThumbHeight + (float)(endBounds.getHeight() + 2.0);
                if (endBounds.getWidth() > (double)(thumbWidth / 2.0f)) {
                    graphics.setFont(TimeLineNode.REVERSE_ROTATED_FONT);
                }
                graphics.drawString(endStr, endX, endY);
                graphics.setFont(origFont);
            }
            graphics.setFont(TimeLineNode.DEFAULT_FONT);
            Rectangle2D nameBounds = graphics.getFontMetrics().getStringBounds(this.getTimeLineNodeName(), graphics);
            graphics.setColor(Color.black);
            float textX = this.fThumb.x + thumbWidth / 2.0f - (float)(nameBounds.getWidth() / 2.0);
            float textY = this.fThumb.y - (float)(nameBounds.getHeight() - 2.0);
            if (nameBounds.getWidth() > (double)thumbWidth) {
                graphics.setFont(TimeLineNode.ROTATED_FONT);
                textX = this.fThumb.x + thumbWidth / 2.0f;
            }
            graphics.drawString(this.getTimeLineNodeName(), textX, textY);
            graphics.setFont(origFont);
        }
    }

    public void handleMouseEvent(MouseEvent evt) {
    }

    public void handleMouseDragEvent(MouseEvent evt) {
    }

    public void handleMouseMoveEvent(MouseEvent evt) {
    }

    public void handleKeyEvent(KeyEvent evt) throws DetailedPropertyVetoException {
    }

    public void setTimeLineNodeName(String name) {
        this.fModel.setTimeLineNodeName(name);
    }

    public String getTimeLineNodeName() {
        return this.fModel.getTimeLineNodeName();
    }

    public void setParent(TimeLine timeLine) {
        this.fTimeLine = timeLine;
    }

    public TimeLine getParent() {
        return this.fTimeLine;
    }

    protected void calculateNodeDimensions() {
        this.fThumbBegin = this.fTimeLine.getPointForTime(this.getStartTime());
        this.fThumbEnd = this.fTimeLine.getPointForTime(this.getEndTime());
    }

    public boolean isDragging() {
        return false;
    }

    public boolean isSelected() {
        return false;
    }

    public void revertToPrevious() {
        this.fModel.revertToPrevious();
    }

    public void vetoableChange(PropertyChangeEvent evt) throws DetailedPropertyVetoException {
        TimeLineNode node;
        if (evt.getPropertyName() != "node removed" && evt.getSource() instanceof TimeLineNode && (node = (TimeLineNode)evt.getSource()) != this && (this.intersects(node) || node.intersects(this))) {
            throw new DetailedPropertyVetoException(this, "Node Overlap", "node " + this.getTimeLineNodeName() + " overlaps " + node.getTimeLineNodeName(), evt);
        }
    }

    public int getAreaForPoint(Point pt) {
        int result = 0;
        if (this.fThumb.contains(pt.x, pt.y)) {
            result = 2;
        }
        return result;
    }

    public boolean intersects(TimeLineNode node) {
        boolean result = this.fModel.intersects(node.getModel());
        return result;
    }

    public Point getCenterPoint() {
        double value = this.fModel.getStartTime().getValue() + (this.fModel.getEndTime().getValue() - this.fModel.getStartTime().getValue()) / 2.0;
        Time centerTime = new Time(value);
        float x = this.fTimeLine.getPointForTime(centerTime);
        float y = (float)this.fTimeLine.getHeight() / 2.0f;
        Point pt = new Point(Math.round(x), Math.round(y));
        return pt;
    }

    public synchronized void setTimeLineNode(Time start, Time end) throws DetailedPropertyVetoException {
        block5: {
            Time oldStartTime = this.fModel.getStartTime();
            Time oldEndTime = this.fModel.getEndTime();
            try {
                this.fModel.setValidTimeLineNode(start, end);
                if (this.fTimeLine == null) break block5;
                Time displayEdge = this.fTimeLine.getDisplayStart();
                if (this.fModel.getStartTime().getValue() < displayEdge.getValue() && oldStartTime.getValue() >= displayEdge.getValue()) {
                    this.fChangeSupport.fireVetoableChange("HitLeftEdge", oldStartTime, this.fModel.getStartTime());
                }
                displayEdge = this.fTimeLine.getDisplayEnd();
                if (this.fModel.getEndTime().getValue() > displayEdge.getValue() && oldEndTime.getValue() <= displayEdge.getValue()) {
                    this.fChangeSupport.fireVetoableChange("HitRightEdge", oldEndTime, this.fModel.getEndTime());
                }
            }
            catch (DetailedPropertyVetoException ex) {
                throw ex;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean containsPoint(Point pt) {
        Time time = this.fTimeLine.getTimeForPoint(pt.x);
        boolean result = false;
        if (time.getValue() >= this.fModel.getStartTime().getValue() && time.getValue() <= this.fModel.getEndTime().getValue()) {
            result = true;
        }
        return result;
    }

    public String getDescription(Point pt) {
        String result = null;
        if (this.fThumb.contains(pt.x, pt.y)) {
            result = this.getTimeLineNodeName();
            Time duration = this.getDuration();
            DecimalFormat form = new DecimalFormat();
            form.setMaximumFractionDigits(2);
            String str = form.format(duration.getValue(this.fTimeLine.getUnitsType()));
            str = str + " " + Time.getUnitsAbbrev(this.fTimeLine.getUnitsType());
            result = result + " = " + str;
        }
        return result;
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.fChangeSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.fChangeSupport.removeVetoableChangeListener(listener);
    }

    public TimeLineNodeModel getModel() {
        return this.fModel;
    }

    public void setModel(TimeLineNodeModel model) {
    }

    public Cursor getCursor(MouseEvent evt) {
        return this.getParent().getCursor();
    }

    public String toString() {
        return this.fModel.toString();
    }
}

