/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class FileUtil {
    public static URL makeURL(URL context, String fileOrUrlStr) {
        URL url = null;
        try {
            if (context != null || fileOrUrlStr.startsWith("http:") || fileOrUrlStr.startsWith("file:") || fileOrUrlStr.startsWith("jar:") || fileOrUrlStr.startsWith("ftp:")) {
                url = context != null ? new URL(context, fileOrUrlStr) : new URL(fileOrUrlStr);
            } else {
                File file = new File(fileOrUrlStr);
                url = file.getAbsoluteFile().toURL();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public static InputStream makeURLStream(URL url) {
        try {
            InputStream stream = url.openStream();
            if (!(stream instanceof BufferedInputStream)) {
                stream = new BufferedInputStream(stream);
            }
            return stream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream makeURLStream(URL context, String fileOrUrlStr) {
        return FileUtil.makeURLStream(FileUtil.makeURL(context, fileOrUrlStr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURL(URL url) throws IOException {
        String string;
        InputStream in = FileUtil.makeURLStream(url);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            FileUtil.copy(in, out);
            string = out.toString();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return string;
    }

    public static String getSuffix(String filename) {
        int index = filename.indexOf(46);
        if (index != -1) {
            return filename.substring(index);
        }
        return "";
    }

    public static void main(String[] args) {
        block3: {
            System.out.println("test FileUtil.makeURL");
            try {
                URL url = FileUtil.makeURL(new URL("http://testing/"), "/test/passed");
                if (url.toString().equals("http://testing/test/passed")) {
                    System.out.println("test passed");
                    break block3;
                }
                System.out.println("test failed: " + url);
            }
            catch (Exception e) {
                System.out.println("test failed: " + e.getMessage());
            }
        }
    }
}

