/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import jsky.science.MathUtilities;

public class FormatUtilities {
    private static String INFINITY = Double.toString(Double.POSITIVE_INFINITY);
    private static String ZERO = "0";
    private static String NAN = Double.toString(Double.NaN);

    public static void writeError(Object source, Object message) {
        StringBuffer sb = new StringBuffer("[ERROR] ");
        sb.append(source);
        sb.append(": ");
        sb.append(message);
        System.err.println(sb.toString());
    }

    public static String formatDouble(double inVal, int inDecs) {
        return FormatUtilities.formatDouble(inVal, inDecs, 14, false);
    }

    public static String formatDouble(double inVal, int inDecs, int inLeftOfDec) {
        return FormatUtilities.formatDouble(inVal, inDecs, inLeftOfDec, false);
    }

    private static String formatDouble(double inVal, int inDecs, int inLeftOfDec, boolean recursing) {
        String returnVal = "";
        if (Double.isInfinite(inVal)) {
            returnVal = INFINITY;
        } else if (Double.isNaN(inVal)) {
            returnVal = NAN;
        } else if (inVal == 0.0) {
            StringBuffer sb = new StringBuffer("0");
            if (inDecs > 0) {
                sb.append(".");
            }
            int i = 0;
            while (i < inDecs) {
                sb.append("0");
                ++i;
            }
            returnVal = sb.toString();
        } else {
            double adjVal;
            boolean doSN;
            inLeftOfDec = Math.max(inLeftOfDec, 1);
            int maxExp = inLeftOfDec - inDecs;
            if (inDecs == 0) {
                ++maxExp;
            }
            if (inVal < 0.0) {
                --maxExp;
            }
            int minExp = -inDecs;
            boolean bl = Math.abs(inVal) > FormatUtilities.pow10(maxExp) ? true : (doSN = Math.abs(inVal) < FormatUtilities.pow10(minExp));
            if (!doSN) {
                String ret = null;
                if (inDecs == 0) {
                    ret = Long.toString(Math.round(inVal));
                } else {
                    double p10 = FormatUtilities.pow10(inDecs);
                    ret = Double.toString((double)Math.round(inVal * p10) / p10);
                    int dotLoc = ret.indexOf(".");
                    if (inDecs > 0 && dotLoc > 0) {
                        ret = ret.substring(0, Math.min(ret.length(), dotLoc + inDecs + 1));
                    }
                }
                return ret;
            }
            inLeftOfDec = Math.max(inLeftOfDec, 1);
            int sign = 1;
            if (inVal < 0.0) {
                sign = -1;
                inVal = -inVal;
            }
            int p10 = 0;
            if (inVal != 0.0) {
                p10 = (int)Math.floor(MathUtilities.log10(inVal));
            }
            if (Double.isNaN(adjVal = (double)sign * inVal / FormatUtilities.pow10(p10))) {
                returnVal = NAN;
            } else {
                StringBuffer sb = new StringBuffer(recursing ? Double.toString(inVal) : FormatUtilities.formatDouble(adjVal, inDecs, inLeftOfDec, true));
                sb.append("e");
                sb.append(p10);
                returnVal = sb.toString();
            }
        }
        return returnVal;
    }

    private static double pow10(int n) {
        if (n == 0) {
            return 1.0;
        }
        if (n > 0) {
            double d = 1.0;
            int i = 0;
            while (i < n) {
                d *= 10.0;
                ++i;
            }
            return d;
        }
        double d = 1.0;
        int i = 0;
        while (i > n) {
            d /= 10.0;
            --i;
        }
        return d;
    }
}

