/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import jsky.util.gui.DialogUtil;

public final class JarManager {
    public void JarManager() {
    }

    public void show(OutputStream out) throws IOException {
        String classPath = System.getProperty("java.class.path");
        String sep = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(classPath, sep);
        Properties props = new Properties();
        while (st.hasMoreTokens()) {
            String fileName = st.nextToken();
            if (!fileName.endsWith(".jar")) continue;
            File file = new File(fileName);
            long size = file.length();
            long sum = this._getChecksum(file);
            props.setProperty(file.getName(), "" + size + " " + sum);
        }
        props.store(out, "JarManager v1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long _getChecksum(File file) throws IOException {
        byte[] buf = new byte[8192];
        FileInputStream in = null;
        CRC32 cs = new CRC32();
        try {
            in = new FileInputStream(file);
            while (in.read(buf) != -1) {
                cs.update(buf, 0, buf.length);
            }
            Object var6_5 = null;
            if (in == null) return cs.getValue();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
        return cs.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void show(String fileName) {
        FileOutputStream out = null;
        out = new FileOutputStream(fileName);
        this.show(out);
        Object var5_3 = null;
        if (out == null) return;
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException ex) {
            DialogUtil.error(ex);
        }
        return;
        {
            catch (Exception e) {
                DialogUtil.error(e);
                Object var5_4 = null;
                if (out == null) return;
                try {
                    ((OutputStream)out).close();
                    return;
                }
                catch (IOException ex) {
                    DialogUtil.error(ex);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException ex) {
                DialogUtil.error(ex);
            }
            throw throwable;
        }
    }

    public void update(String baseURL, String fileName) {
    }

    public static void main(String[] args) {
        try {
            new JarManager().show(System.out);
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(1);
        }
        System.exit(0);
    }
}

